/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Bitmap;
import android.graphics.Bitmap_Delegate;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Path_Delegate;
import android.graphics.Rect;
import android.graphics.Region;
import android.view.RectShadowPainter;
import android.view.ShadowPainter;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.animation.Transformation;
import com.android.resources.Density;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class ViewGroup_Delegate {
    @LayoutlibDelegate
    static boolean drawChild(ViewGroup thisVG, Canvas canvas, View child, long drawingTime) {
        if (child.getZ() > thisVG.getZ()) {
            child.setBackgroundBounds();
            ViewOutlineProvider outlineProvider = child.getOutlineProvider();
            if (outlineProvider != null) {
                Outline outline = child.mAttachInfo.mTmpOutline;
                outlineProvider.getOutline(child, outline);
                if (outline.mPath != null || outline.mRect != null && !outline.mRect.isEmpty()) {
                    int restoreTo = ViewGroup_Delegate.transformCanvas(thisVG, canvas, child);
                    ViewGroup_Delegate.drawShadow(thisVG, canvas, child, outline);
                    canvas.restoreToCount(restoreTo);
                }
            }
        }
        return thisVG.drawChild_Original(canvas, child, drawingTime);
    }

    private static void drawShadow(ViewGroup parent, Canvas canvas, View child, Outline outline) {
        float elevation = ViewGroup_Delegate.getElevation(child, parent);
        if (outline.mMode == 1 && outline.mRect != null) {
            RectShadowPainter.paintShadow(outline, elevation, canvas);
            return;
        }
        BufferedImage shadow = null;
        if (outline.mPath != null) {
            shadow = ViewGroup_Delegate.getPathShadow(outline, canvas, elevation);
        }
        if (shadow == null) {
            return;
        }
        Bitmap bitmap = Bitmap_Delegate.createBitmap(shadow, false, Density.getEnum((int)canvas.getDensity()));
        Rect clipBounds = canvas.getClipBounds();
        Rect newBounds = new Rect(clipBounds);
        newBounds.inset((int)(-elevation), (int)(-elevation));
        canvas.clipRect(newBounds, Region.Op.REPLACE);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        canvas.clipRect(clipBounds, Region.Op.REPLACE);
    }

    private static float getElevation(View child, ViewGroup parent) {
        return child.getZ() - parent.getZ();
    }

    private static BufferedImage getPathShadow(Outline outline, Canvas canvas, float elevation) {
        Rect clipBounds = canvas.getClipBounds();
        if (clipBounds.isEmpty()) {
            return null;
        }
        BufferedImage image = new BufferedImage(clipBounds.width(), clipBounds.height(), 2);
        Graphics2D graphics = image.createGraphics();
        graphics.draw(Path_Delegate.getDelegate(outline.mPath.mNativePath).getJavaShape());
        graphics.dispose();
        return ShadowPainter.createDropShadow(image, (int)elevation);
    }

    private static int transformCanvas(ViewGroup thisVG, Canvas canvas, View child) {
        Transformation t;
        boolean hasTransform;
        int restoreTo = canvas.save();
        boolean childHasIdentityMatrix = child.hasIdentityMatrix();
        int flags = thisVG.mGroupFlags;
        Transformation transformToApply = null;
        boolean concatMatrix = false;
        if ((flags & 0x800) != 0 && (hasTransform = thisVG.getChildStaticTransformation(child, t = thisVG.getChildTransformation()))) {
            int transformType = t.getTransformationType();
            transformToApply = transformType != 0 ? t : null;
            concatMatrix = (transformType & 2) != 0;
        }
        concatMatrix |= childHasIdentityMatrix;
        child.computeScroll();
        int sx = child.mScrollX;
        int sy = child.mScrollY;
        canvas.translate(child.mLeft - sx, child.mTop - sy);
        float alpha = child.getAlpha() * child.getTransitionAlpha();
        if (!(transformToApply == null && !(alpha < 1.0f) && childHasIdentityMatrix || transformToApply == null && childHasIdentityMatrix)) {
            int transX = -sx;
            int transY = -sy;
            if (transformToApply != null) {
                if (concatMatrix) {
                    canvas.translate(-transX, -transY);
                    canvas.concat(transformToApply.getMatrix());
                    canvas.translate(transX, transY);
                }
                if (!childHasIdentityMatrix) {
                    canvas.translate(-transX, -transY);
                    canvas.concat(child.getMatrix());
                    canvas.translate(transX, transY);
                }
            }
        }
        return restoreTo;
    }
}

