/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.icu.text.DecimalFormatSymbols;
import android.os.Parcelable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.text.style.TtsSpan;
import android.util.AttributeSet;
import android.util.StateSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageButton;
import android.widget.RadialTimePickerView;
import android.widget.RadioButton;
import android.widget.RelativeLayout;
import android.widget.TextInputTimePickerView;
import android.widget.TextView;
import android.widget.TimePicker;
import com.android.internal.R;
import com.android.internal.widget.NumericTextView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Calendar;

class TimePickerClockDelegate
extends TimePicker.AbstractTimePickerDelegate {
    private static final long DELAY_COMMIT_MILLIS = 2000L;
    private static final int FROM_EXTERNAL_API = 0;
    private static final int FROM_RADIAL_PICKER = 1;
    private static final int FROM_INPUT_PICKER = 2;
    private static final int HOUR_INDEX = 0;
    private static final int MINUTE_INDEX = 1;
    private static final int[] ATTRS_TEXT_COLOR = new int[]{16842904};
    private static final int[] ATTRS_DISABLED_ALPHA = new int[]{0x1010033};
    private static final int AM = 0;
    private static final int PM = 1;
    private static final int HOURS_IN_HALF_DAY = 12;
    private final NumericTextView mHourView;
    private final NumericTextView mMinuteView;
    private final View mAmPmLayout;
    private final RadioButton mAmLabel;
    private final RadioButton mPmLabel;
    private final RadialTimePickerView mRadialTimePickerView;
    private final TextView mSeparatorView;
    private boolean mRadialPickerModeEnabled = true;
    private final ImageButton mRadialTimePickerModeButton;
    private final String mRadialTimePickerModeEnabledDescription;
    private final String mTextInputPickerModeEnabledDescription;
    private final View mRadialTimePickerHeader;
    private final View mTextInputPickerHeader;
    private final TextInputTimePickerView mTextInputPickerView;
    private final Calendar mTempCalendar;
    private final String mSelectHours;
    private final String mSelectMinutes;
    private boolean mIsEnabled = true;
    private boolean mAllowAutoAdvance;
    private int mCurrentHour;
    private int mCurrentMinute;
    private boolean mIs24Hour;
    private boolean mIsAmPmAtLeft = false;
    private boolean mIsAmPmAtTop = false;
    private boolean mHourFormatShowLeadingZero;
    private boolean mHourFormatStartsAtZero;
    private CharSequence mLastAnnouncedText;
    private boolean mLastAnnouncedIsHour;
    private final RadialTimePickerView.OnValueSelectedListener mOnValueSelectedListener = new RadialTimePickerView.OnValueSelectedListener(){

        @Override
        public void onValueSelected(int pickerType, int newValue, boolean autoAdvance) {
            boolean valueChanged = false;
            switch (pickerType) {
                case 0: {
                    if (TimePickerClockDelegate.this.getHour() != newValue) {
                        valueChanged = true;
                    }
                    boolean isTransition = TimePickerClockDelegate.this.mAllowAutoAdvance && autoAdvance;
                    TimePickerClockDelegate.this.setHourInternal(newValue, 1, !isTransition, true);
                    if (!isTransition) break;
                    TimePickerClockDelegate.this.setCurrentItemShowing(1, true, false);
                    int localizedHour = TimePickerClockDelegate.this.getLocalizedHour(newValue);
                    TimePickerClockDelegate.this.mDelegator.announceForAccessibility(localizedHour + ". " + TimePickerClockDelegate.this.mSelectMinutes);
                    break;
                }
                case 1: {
                    if (TimePickerClockDelegate.this.getMinute() != newValue) {
                        valueChanged = true;
                    }
                    TimePickerClockDelegate.this.setMinuteInternal(newValue, 1, true);
                }
            }
            if (TimePickerClockDelegate.this.mOnTimeChangedListener != null && valueChanged) {
                TimePickerClockDelegate.this.mOnTimeChangedListener.onTimeChanged(TimePickerClockDelegate.this.mDelegator, TimePickerClockDelegate.this.getHour(), TimePickerClockDelegate.this.getMinute());
            }
        }
    };
    private final TextInputTimePickerView.OnValueTypedListener mOnValueTypedListener = new TextInputTimePickerView.OnValueTypedListener(){

        @Override
        public void onValueChanged(int pickerType, int newValue) {
            switch (pickerType) {
                case 0: {
                    TimePickerClockDelegate.this.setHourInternal(newValue, 2, false, true);
                    break;
                }
                case 1: {
                    TimePickerClockDelegate.this.setMinuteInternal(newValue, 2, true);
                    break;
                }
                case 2: {
                    TimePickerClockDelegate.this.setAmOrPm(newValue);
                }
            }
        }
    };
    private final NumericTextView.OnValueChangedListener mDigitEnteredListener = new NumericTextView.OnValueChangedListener(){

        @Override
        public void onValueChanged(NumericTextView view, int value, boolean isValid, boolean isFinished) {
            NumericTextView nextFocusTarget;
            Runnable commitCallback;
            if (view == TimePickerClockDelegate.this.mHourView) {
                commitCallback = TimePickerClockDelegate.this.mCommitHour;
                nextFocusTarget = view.isFocused() ? TimePickerClockDelegate.this.mMinuteView : null;
            } else if (view == TimePickerClockDelegate.this.mMinuteView) {
                commitCallback = TimePickerClockDelegate.this.mCommitMinute;
                nextFocusTarget = null;
            } else {
                return;
            }
            view.removeCallbacks(commitCallback);
            if (isValid) {
                if (isFinished) {
                    commitCallback.run();
                    if (nextFocusTarget != null) {
                        nextFocusTarget.requestFocus();
                    }
                } else {
                    view.postDelayed(commitCallback, 2000L);
                }
            }
        }
    };
    private final Runnable mCommitHour = new Runnable(){

        @Override
        public void run() {
            TimePickerClockDelegate.this.setHour(TimePickerClockDelegate.this.mHourView.getValue());
        }
    };
    private final Runnable mCommitMinute = new Runnable(){

        @Override
        public void run() {
            TimePickerClockDelegate.this.setMinute(TimePickerClockDelegate.this.mMinuteView.getValue());
        }
    };
    private final View.OnFocusChangeListener mFocusListener = new View.OnFocusChangeListener(){

        @Override
        public void onFocusChange(View v, boolean focused) {
            if (focused) {
                switch (v.getId()) {
                    case 16908709: {
                        TimePickerClockDelegate.this.setAmOrPm(0);
                        break;
                    }
                    case 16909162: {
                        TimePickerClockDelegate.this.setAmOrPm(1);
                        break;
                    }
                    case 16908938: {
                        TimePickerClockDelegate.this.setCurrentItemShowing(0, true, true);
                        break;
                    }
                    case 16909048: {
                        TimePickerClockDelegate.this.setCurrentItemShowing(1, true, true);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                TimePickerClockDelegate.this.tryVibrate();
            }
        }
    };
    private final View.OnClickListener mClickListener = new View.OnClickListener(){

        @Override
        public void onClick(View v) {
            switch (v.getId()) {
                case 16908709: {
                    TimePickerClockDelegate.this.setAmOrPm(0);
                    break;
                }
                case 16909162: {
                    TimePickerClockDelegate.this.setAmOrPm(1);
                    break;
                }
                case 16908938: {
                    TimePickerClockDelegate.this.setCurrentItemShowing(0, true, true);
                    break;
                }
                case 16909048: {
                    TimePickerClockDelegate.this.setCurrentItemShowing(1, true, true);
                    break;
                }
                default: {
                    return;
                }
            }
            TimePickerClockDelegate.this.tryVibrate();
        }
    };

    public TimePickerClockDelegate(TimePicker delegator, Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(delegator, context);
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.TimePicker, defStyleAttr, defStyleRes);
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        Resources res = this.mContext.getResources();
        this.mSelectHours = res.getString(17040747);
        this.mSelectMinutes = res.getString(17040751);
        int layoutResourceId = a.getResourceId(12, 0x1090101);
        View mainView = inflater.inflate(layoutResourceId, (ViewGroup)delegator);
        mainView.setSaveFromParentEnabled(false);
        this.mRadialTimePickerHeader = mainView.findViewById(16909369);
        this.mRadialTimePickerHeader.setOnTouchListener(new NearestTouchDelegate());
        this.mHourView = (NumericTextView)mainView.findViewById(16908938);
        this.mHourView.setOnClickListener(this.mClickListener);
        this.mHourView.setOnFocusChangeListener(this.mFocusListener);
        this.mHourView.setOnDigitEnteredListener(this.mDigitEnteredListener);
        this.mHourView.setAccessibilityDelegate(new ClickActionDelegate(context, 17040747));
        this.mSeparatorView = (TextView)mainView.findViewById(16909251);
        this.mMinuteView = (NumericTextView)mainView.findViewById(16909048);
        this.mMinuteView.setOnClickListener(this.mClickListener);
        this.mMinuteView.setOnFocusChangeListener(this.mFocusListener);
        this.mMinuteView.setOnDigitEnteredListener(this.mDigitEnteredListener);
        this.mMinuteView.setAccessibilityDelegate(new ClickActionDelegate(context, 17040751));
        this.mMinuteView.setRange(0, 59);
        this.mAmPmLayout = mainView.findViewById(16908711);
        this.mAmPmLayout.setOnTouchListener(new NearestTouchDelegate());
        String[] amPmStrings = TimePicker.getAmPmStrings(context);
        this.mAmLabel = (RadioButton)this.mAmPmLayout.findViewById(16908709);
        this.mAmLabel.setText(TimePickerClockDelegate.obtainVerbatim(amPmStrings[0]));
        this.mAmLabel.setOnClickListener(this.mClickListener);
        TimePickerClockDelegate.ensureMinimumTextWidth(this.mAmLabel);
        this.mPmLabel = (RadioButton)this.mAmPmLayout.findViewById(16909162);
        this.mPmLabel.setText(TimePickerClockDelegate.obtainVerbatim(amPmStrings[1]));
        this.mPmLabel.setOnClickListener(this.mClickListener);
        TimePickerClockDelegate.ensureMinimumTextWidth(this.mPmLabel);
        ColorStateList headerTextColor = null;
        int timeHeaderTextAppearance = a.getResourceId(1, 0);
        if (timeHeaderTextAppearance != 0) {
            TypedArray textAppearance = this.mContext.obtainStyledAttributes(null, ATTRS_TEXT_COLOR, 0, timeHeaderTextAppearance);
            ColorStateList legacyHeaderTextColor = textAppearance.getColorStateList(0);
            headerTextColor = this.applyLegacyColorFixes(legacyHeaderTextColor);
            textAppearance.recycle();
        }
        if (headerTextColor == null) {
            headerTextColor = a.getColorStateList(11);
        }
        this.mTextInputPickerHeader = mainView.findViewById(16908966);
        if (headerTextColor != null) {
            this.mHourView.setTextColor(headerTextColor);
            this.mSeparatorView.setTextColor(headerTextColor);
            this.mMinuteView.setTextColor(headerTextColor);
            this.mAmLabel.setTextColor(headerTextColor);
            this.mPmLabel.setTextColor(headerTextColor);
        }
        if (a.hasValueOrEmpty(0)) {
            this.mRadialTimePickerHeader.setBackground(a.getDrawable(0));
            this.mTextInputPickerHeader.setBackground(a.getDrawable(0));
        }
        a.recycle();
        this.mRadialTimePickerView = (RadialTimePickerView)mainView.findViewById(16909187);
        this.mRadialTimePickerView.applyAttributes(attrs, defStyleAttr, defStyleRes);
        this.mRadialTimePickerView.setOnValueSelectedListener(this.mOnValueSelectedListener);
        this.mTextInputPickerView = (TextInputTimePickerView)mainView.findViewById(16908969);
        this.mTextInputPickerView.setListener(this.mOnValueTypedListener);
        this.mRadialTimePickerModeButton = (ImageButton)mainView.findViewById(16909385);
        this.mRadialTimePickerModeButton.setOnClickListener(new View.OnClickListener(){

            @Override
            public void onClick(View v) {
                TimePickerClockDelegate.this.toggleRadialPickerMode();
            }
        });
        this.mRadialTimePickerModeEnabledDescription = context.getResources().getString(17040892);
        this.mTextInputPickerModeEnabledDescription = context.getResources().getString(17040893);
        this.mAllowAutoAdvance = true;
        this.updateHourFormat();
        this.mTempCalendar = Calendar.getInstance(this.mLocale);
        int currentHour = this.mTempCalendar.get(11);
        int currentMinute = this.mTempCalendar.get(12);
        this.initialize(currentHour, currentMinute, this.mIs24Hour, 0);
    }

    private void toggleRadialPickerMode() {
        if (this.mRadialPickerModeEnabled) {
            this.mRadialTimePickerView.setVisibility(8);
            this.mRadialTimePickerHeader.setVisibility(8);
            this.mTextInputPickerHeader.setVisibility(0);
            this.mTextInputPickerView.setVisibility(0);
            this.mRadialTimePickerModeButton.setImageResource(17301787);
            this.mRadialTimePickerModeButton.setContentDescription(this.mRadialTimePickerModeEnabledDescription);
            this.mRadialPickerModeEnabled = false;
        } else {
            this.mRadialTimePickerView.setVisibility(0);
            this.mRadialTimePickerHeader.setVisibility(0);
            this.mTextInputPickerHeader.setVisibility(8);
            this.mTextInputPickerView.setVisibility(8);
            this.mRadialTimePickerModeButton.setImageResource(17301864);
            this.mRadialTimePickerModeButton.setContentDescription(this.mTextInputPickerModeEnabledDescription);
            this.updateTextInputPicker();
            InputMethodManager imm = InputMethodManager.peekInstance();
            if (imm != null) {
                imm.hideSoftInputFromWindow(this.mDelegator.getWindowToken(), 0);
            }
            this.mRadialPickerModeEnabled = true;
        }
    }

    @Override
    public boolean validateInput() {
        return this.mTextInputPickerView.validateInput();
    }

    private static void ensureMinimumTextWidth(TextView v) {
        v.measure(0, 0);
        int minWidth = v.getMeasuredWidth();
        v.setMinWidth(minWidth);
        v.setMinimumWidth(minWidth);
    }

    private void updateHourFormat() {
        String bestDateTimePattern = DateFormat.getBestDateTimePattern(this.mLocale, this.mIs24Hour ? "Hm" : "hm");
        int lengthPattern = bestDateTimePattern.length();
        boolean showLeadingZero = false;
        int hourFormat = 0;
        for (int i = 0; i < lengthPattern; ++i) {
            char c = bestDateTimePattern.charAt(i);
            if (c != 'H' && c != 'h' && c != 'K' && c != 'k') continue;
            hourFormat = c;
            if (i + 1 >= lengthPattern || c != bestDateTimePattern.charAt(i + 1)) break;
            showLeadingZero = true;
            break;
        }
        this.mHourFormatShowLeadingZero = showLeadingZero;
        this.mHourFormatStartsAtZero = hourFormat == 75 || hourFormat == 72;
        int minHour = this.mHourFormatStartsAtZero ? 0 : 1;
        int maxHour = (this.mIs24Hour ? 23 : 11) + minHour;
        this.mHourView.setRange(minHour, maxHour);
        this.mHourView.setShowLeadingZeroes(this.mHourFormatShowLeadingZero);
        String[] digits = DecimalFormatSymbols.getInstance(this.mLocale).getDigitStrings();
        int maxCharLength = 0;
        for (int i = 0; i < 10; ++i) {
            maxCharLength = Math.max(maxCharLength, digits[i].length());
        }
        this.mTextInputPickerView.setHourFormat(maxCharLength * 2);
    }

    static CharSequence obtainVerbatim(String text) {
        return new SpannableStringBuilder().append((CharSequence)text, new TtsSpan.VerbatimBuilder(text).build(), 0);
    }

    private ColorStateList applyLegacyColorFixes(ColorStateList color2) {
        int defaultColor;
        int activatedColor;
        if (color2 == null || color2.hasState(16843518)) {
            return color2;
        }
        if (color2.hasState(0x10100A1)) {
            activatedColor = color2.getColorForState(StateSet.get(10), 0);
            defaultColor = color2.getColorForState(StateSet.get(8), 0);
        } else {
            activatedColor = color2.getDefaultColor();
            TypedArray ta = this.mContext.obtainStyledAttributes(ATTRS_DISABLED_ALPHA);
            float disabledAlpha = ta.getFloat(0, 0.3f);
            defaultColor = this.multiplyAlphaComponent(activatedColor, disabledAlpha);
        }
        if (activatedColor == 0 || defaultColor == 0) {
            return null;
        }
        int[][] stateSet = new int[][]{{16843518}, new int[0]};
        int[] colors = new int[]{activatedColor, defaultColor};
        return new ColorStateList(stateSet, colors);
    }

    private int multiplyAlphaComponent(int color2, float alphaMod) {
        int srcRgb = color2 & 0xFFFFFF;
        int srcAlpha = color2 >> 24 & 0xFF;
        int dstAlpha = (int)((float)srcAlpha * alphaMod + 0.5f);
        return srcRgb | dstAlpha << 24;
    }

    private void initialize(int hourOfDay, int minute, boolean is24HourView, int index) {
        this.mCurrentHour = hourOfDay;
        this.mCurrentMinute = minute;
        this.mIs24Hour = is24HourView;
        this.updateUI(index);
    }

    private void updateUI(int index) {
        this.updateHeaderAmPm();
        this.updateHeaderHour(this.mCurrentHour, false);
        this.updateHeaderSeparator();
        this.updateHeaderMinute(this.mCurrentMinute, false);
        this.updateRadialPicker(index);
        this.updateTextInputPicker();
        this.mDelegator.invalidate();
    }

    private void updateTextInputPicker() {
        this.mTextInputPickerView.updateTextInputValues(this.getLocalizedHour(this.mCurrentHour), this.mCurrentMinute, this.mCurrentHour < 12 ? 0 : 1, this.mIs24Hour, this.mHourFormatStartsAtZero);
    }

    private void updateRadialPicker(int index) {
        this.mRadialTimePickerView.initialize(this.mCurrentHour, this.mCurrentMinute, this.mIs24Hour);
        this.setCurrentItemShowing(index, false, true);
    }

    private void updateHeaderAmPm() {
        if (this.mIs24Hour) {
            this.mAmPmLayout.setVisibility(8);
        } else {
            String dateTimePattern = DateFormat.getBestDateTimePattern(this.mLocale, "hm");
            boolean isAmPmAtStart = dateTimePattern.startsWith("a");
            this.setAmPmStart(isAmPmAtStart);
            this.updateAmPmLabelStates(this.mCurrentHour < 12 ? 0 : 1);
        }
    }

    private void setAmPmStart(boolean isAmPmAtStart) {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mAmPmLayout.getLayoutParams();
        if (params.getRule(1) != 0 || params.getRule(0) != 0) {
            boolean isAmPmAtLeft;
            if (TextUtils.getLayoutDirectionFromLocale(this.mLocale) == 0) {
                isAmPmAtLeft = isAmPmAtStart;
            } else {
                boolean bl = isAmPmAtLeft = !isAmPmAtStart;
            }
            if (this.mIsAmPmAtLeft == isAmPmAtLeft) {
                return;
            }
            if (isAmPmAtLeft) {
                params.removeRule(1);
                params.addRule(0, this.mHourView.getId());
            } else {
                params.removeRule(0);
                params.addRule(1, this.mMinuteView.getId());
            }
            this.mIsAmPmAtLeft = isAmPmAtLeft;
        } else if (params.getRule(3) != 0 || params.getRule(2) != 0) {
            int otherViewId;
            if (this.mIsAmPmAtTop == isAmPmAtStart) {
                return;
            }
            if (isAmPmAtStart) {
                otherViewId = params.getRule(3);
                params.removeRule(3);
                params.addRule(2, otherViewId);
            } else {
                otherViewId = params.getRule(2);
                params.removeRule(2);
                params.addRule(3, otherViewId);
            }
            Object otherView = this.mRadialTimePickerHeader.findViewById(otherViewId);
            int top = ((View)otherView).getPaddingTop();
            int bottom = ((View)otherView).getPaddingBottom();
            int left = ((View)otherView).getPaddingLeft();
            int right = ((View)otherView).getPaddingRight();
            ((View)otherView).setPadding(left, bottom, right, top);
            this.mIsAmPmAtTop = isAmPmAtStart;
        }
        this.mAmPmLayout.setLayoutParams(params);
    }

    @Override
    public void setDate(int hour, int minute) {
        this.setHourInternal(hour, 0, true, false);
        this.setMinuteInternal(minute, 0, false);
        this.onTimeChanged();
    }

    @Override
    public void setHour(int hour) {
        this.setHourInternal(hour, 0, true, true);
    }

    private void setHourInternal(int hour, int source, boolean announce, boolean notify) {
        if (this.mCurrentHour == hour) {
            return;
        }
        this.resetAutofilledValue();
        this.mCurrentHour = hour;
        this.updateHeaderHour(hour, announce);
        this.updateHeaderAmPm();
        if (source != 1) {
            this.mRadialTimePickerView.setCurrentHour(hour);
            this.mRadialTimePickerView.setAmOrPm(hour < 12 ? 0 : 1);
        }
        if (source != 2) {
            this.updateTextInputPicker();
        }
        this.mDelegator.invalidate();
        if (notify) {
            this.onTimeChanged();
        }
    }

    @Override
    public int getHour() {
        int currentHour = this.mRadialTimePickerView.getCurrentHour();
        if (this.mIs24Hour) {
            return currentHour;
        }
        if (this.mRadialTimePickerView.getAmOrPm() == 1) {
            return currentHour % 12 + 12;
        }
        return currentHour % 12;
    }

    @Override
    public void setMinute(int minute) {
        this.setMinuteInternal(minute, 0, true);
    }

    private void setMinuteInternal(int minute, int source, boolean notify) {
        if (this.mCurrentMinute == minute) {
            return;
        }
        this.resetAutofilledValue();
        this.mCurrentMinute = minute;
        this.updateHeaderMinute(minute, true);
        if (source != 1) {
            this.mRadialTimePickerView.setCurrentMinute(minute);
        }
        if (source != 2) {
            this.updateTextInputPicker();
        }
        this.mDelegator.invalidate();
        if (notify) {
            this.onTimeChanged();
        }
    }

    @Override
    public int getMinute() {
        return this.mRadialTimePickerView.getCurrentMinute();
    }

    @Override
    public void setIs24Hour(boolean is24Hour) {
        if (this.mIs24Hour != is24Hour) {
            this.mIs24Hour = is24Hour;
            this.mCurrentHour = this.getHour();
            this.updateHourFormat();
            this.updateUI(this.mRadialTimePickerView.getCurrentItemShowing());
        }
    }

    @Override
    public boolean is24Hour() {
        return this.mIs24Hour;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.mHourView.setEnabled(enabled);
        this.mMinuteView.setEnabled(enabled);
        this.mAmLabel.setEnabled(enabled);
        this.mPmLabel.setEnabled(enabled);
        this.mRadialTimePickerView.setEnabled(enabled);
        this.mIsEnabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    @Override
    public int getBaseline() {
        return -1;
    }

    @Override
    public Parcelable onSaveInstanceState(Parcelable superState) {
        return new TimePicker.AbstractTimePickerDelegate.SavedState(superState, this.getHour(), this.getMinute(), this.is24Hour(), this.getCurrentItemShowing());
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof TimePicker.AbstractTimePickerDelegate.SavedState) {
            TimePicker.AbstractTimePickerDelegate.SavedState ss = (TimePicker.AbstractTimePickerDelegate.SavedState)state;
            this.initialize(ss.getHour(), ss.getMinute(), ss.is24HourMode(), ss.getCurrentItemShowing());
            this.mRadialTimePickerView.invalidate();
        }
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        this.onPopulateAccessibilityEvent(event);
        return true;
    }

    @Override
    public void onPopulateAccessibilityEvent(AccessibilityEvent event) {
        int flags = 1;
        flags = this.mIs24Hour ? (flags |= 0x80) : (flags |= 0x40);
        this.mTempCalendar.set(11, this.getHour());
        this.mTempCalendar.set(12, this.getMinute());
        String selectedTime = DateUtils.formatDateTime(this.mContext, this.mTempCalendar.getTimeInMillis(), flags);
        String selectionMode = this.mRadialTimePickerView.getCurrentItemShowing() == 0 ? this.mSelectHours : this.mSelectMinutes;
        event.getText().add(selectedTime + " " + selectionMode);
    }

    @Override
    public View getHourView() {
        return this.mHourView;
    }

    @Override
    public View getMinuteView() {
        return this.mMinuteView;
    }

    @Override
    public View getAmView() {
        return this.mAmLabel;
    }

    @Override
    public View getPmView() {
        return this.mPmLabel;
    }

    private int getCurrentItemShowing() {
        return this.mRadialTimePickerView.getCurrentItemShowing();
    }

    private void onTimeChanged() {
        this.mDelegator.sendAccessibilityEvent(4);
        if (this.mOnTimeChangedListener != null) {
            this.mOnTimeChangedListener.onTimeChanged(this.mDelegator, this.getHour(), this.getMinute());
        }
        if (this.mAutoFillChangeListener != null) {
            this.mAutoFillChangeListener.onTimeChanged(this.mDelegator, this.getHour(), this.getMinute());
        }
    }

    private void tryVibrate() {
        this.mDelegator.performHapticFeedback(4);
    }

    private void updateAmPmLabelStates(int amOrPm) {
        boolean isAm = amOrPm == 0;
        this.mAmLabel.setActivated(isAm);
        this.mAmLabel.setChecked(isAm);
        boolean isPm = amOrPm == 1;
        this.mPmLabel.setActivated(isPm);
        this.mPmLabel.setChecked(isPm);
    }

    private int getLocalizedHour(int hourOfDay) {
        if (!this.mIs24Hour) {
            hourOfDay %= 12;
        }
        if (!this.mHourFormatStartsAtZero && hourOfDay == 0) {
            hourOfDay = this.mIs24Hour ? 24 : 12;
        }
        return hourOfDay;
    }

    private void updateHeaderHour(int hourOfDay, boolean announce) {
        int localizedHour = this.getLocalizedHour(hourOfDay);
        this.mHourView.setValue(localizedHour);
        if (announce) {
            this.tryAnnounceForAccessibility(this.mHourView.getText(), true);
        }
    }

    private void updateHeaderMinute(int minuteOfHour, boolean announce) {
        this.mMinuteView.setValue(minuteOfHour);
        if (announce) {
            this.tryAnnounceForAccessibility(this.mMinuteView.getText(), false);
        }
    }

    private void updateHeaderSeparator() {
        String bestDateTimePattern = DateFormat.getBestDateTimePattern(this.mLocale, this.mIs24Hour ? "Hm" : "hm");
        char[] hourFormats = new char[]{'H', 'h', 'K', 'k'};
        int hIndex = TimePickerClockDelegate.lastIndexOfAny(bestDateTimePattern, hourFormats);
        String separatorText = hIndex == -1 ? ":" : Character.toString(bestDateTimePattern.charAt(hIndex + 1));
        this.mSeparatorView.setText(separatorText);
        this.mTextInputPickerView.updateSeparator(separatorText);
    }

    private static int lastIndexOfAny(String str, char[] any) {
        int lengthAny = any.length;
        if (lengthAny > 0) {
            for (int i = str.length() - 1; i >= 0; --i) {
                char c = str.charAt(i);
                for (int j = 0; j < lengthAny; ++j) {
                    if (c != any[j]) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    private void tryAnnounceForAccessibility(CharSequence text, boolean isHour) {
        if (this.mLastAnnouncedIsHour != isHour || !text.equals(this.mLastAnnouncedText)) {
            this.mDelegator.announceForAccessibility(text);
            this.mLastAnnouncedText = text;
            this.mLastAnnouncedIsHour = isHour;
        }
    }

    private void setCurrentItemShowing(int index, boolean animateCircle, boolean announce) {
        this.mRadialTimePickerView.setCurrentItemShowing(index, animateCircle);
        if (index == 0) {
            if (announce) {
                this.mDelegator.announceForAccessibility(this.mSelectHours);
            }
        } else if (announce) {
            this.mDelegator.announceForAccessibility(this.mSelectMinutes);
        }
        this.mHourView.setActivated(index == 0);
        this.mMinuteView.setActivated(index == 1);
    }

    private void setAmOrPm(int amOrPm) {
        this.updateAmPmLabelStates(amOrPm);
        if (this.mRadialTimePickerView.setAmOrPm(amOrPm)) {
            this.mCurrentHour = this.getHour();
            this.updateTextInputPicker();
            if (this.mOnTimeChangedListener != null) {
                this.mOnTimeChangedListener.onTimeChanged(this.mDelegator, this.getHour(), this.getMinute());
            }
        }
    }

    private static class NearestTouchDelegate
    implements View.OnTouchListener {
        private View mInitialTouchTarget;

        private NearestTouchDelegate() {
        }

        @Override
        public boolean onTouch(View view, MotionEvent motionEvent) {
            View child;
            int actionMasked = motionEvent.getActionMasked();
            if (actionMasked == 0) {
                this.mInitialTouchTarget = view instanceof ViewGroup ? this.findNearestChild((ViewGroup)view, (int)motionEvent.getX(), (int)motionEvent.getY()) : null;
            }
            if ((child = this.mInitialTouchTarget) == null) {
                return false;
            }
            float offsetX = view.getScrollX() - child.getLeft();
            float offsetY = view.getScrollY() - child.getTop();
            motionEvent.offsetLocation(offsetX, offsetY);
            boolean handled = child.dispatchTouchEvent(motionEvent);
            motionEvent.offsetLocation(-offsetX, -offsetY);
            if (actionMasked == 1 || actionMasked == 3) {
                this.mInitialTouchTarget = null;
            }
            return handled;
        }

        private View findNearestChild(ViewGroup v, int x, int y) {
            View bestChild = null;
            int bestDist = Integer.MAX_VALUE;
            int count = v.getChildCount();
            for (int i = 0; i < count; ++i) {
                int dY;
                View child = v.getChildAt(i);
                int dX = x - (child.getLeft() + child.getWidth() / 2);
                int dist = dX * dX + (dY = y - (child.getTop() + child.getHeight() / 2)) * dY;
                if (bestDist <= dist) continue;
                bestChild = child;
                bestDist = dist;
            }
            return bestChild;
        }
    }

    private static class ClickActionDelegate
    extends View.AccessibilityDelegate {
        private final AccessibilityNodeInfo.AccessibilityAction mClickAction;

        public ClickActionDelegate(Context context, int resId) {
            this.mClickAction = new AccessibilityNodeInfo.AccessibilityAction(16, context.getString(resId));
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfo info) {
            super.onInitializeAccessibilityNodeInfo(host, info);
            info.addAction(this.mClickAction);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface ChangeSource {
    }
}

