/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import android.system.ErrnoException;
import android.system.OsConstants;
import android.system.StructStat;
import com.android.tools.layoutlib.java.System_Delegate;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import libcore.io.ClassPathURLStreamHandler;
import libcore.io.IoUtils;
import libcore.io.Libcore;

class DexPathList {
    private static final String DEX_SUFFIX = ".dex";
    private static final String zipSeparator = "!/";
    private final ClassLoader definingContext;
    private Element[] dexElements;
    private final NativeLibraryElement[] nativeLibraryPathElements;
    private final List<File> nativeLibraryDirectories;
    private final List<File> systemNativeLibraryDirectories;
    private IOException[] dexElementsSuppressedExceptions;

    public DexPathList(ClassLoader definingContext, ByteBuffer[] dexFiles) {
        if (definingContext == null) {
            throw new NullPointerException("definingContext == null");
        }
        if (dexFiles == null) {
            throw new NullPointerException("dexFiles == null");
        }
        if (Arrays.stream(dexFiles).anyMatch(v -> v == null)) {
            throw new NullPointerException("dexFiles contains a null Buffer!");
        }
        this.definingContext = definingContext;
        this.nativeLibraryDirectories = Collections.emptyList();
        this.systemNativeLibraryDirectories = DexPathList.splitPaths(System.getProperty("java.library.path"), true);
        this.nativeLibraryPathElements = DexPathList.makePathElements(this.systemNativeLibraryDirectories);
        ArrayList<IOException> suppressedExceptions = new ArrayList<IOException>();
        this.dexElements = DexPathList.makeInMemoryDexElements(dexFiles, suppressedExceptions);
        this.dexElementsSuppressedExceptions = suppressedExceptions.size() > 0 ? suppressedExceptions.toArray(new IOException[suppressedExceptions.size()]) : null;
    }

    public DexPathList(ClassLoader definingContext, String dexPath, String librarySearchPath, File optimizedDirectory) {
        if (definingContext == null) {
            throw new NullPointerException("definingContext == null");
        }
        if (dexPath == null) {
            throw new NullPointerException("dexPath == null");
        }
        if (optimizedDirectory != null) {
            if (!optimizedDirectory.exists()) {
                throw new IllegalArgumentException("optimizedDirectory doesn't exist: " + optimizedDirectory);
            }
            if (!optimizedDirectory.canRead() || !optimizedDirectory.canWrite()) {
                throw new IllegalArgumentException("optimizedDirectory not readable/writable: " + optimizedDirectory);
            }
        }
        this.definingContext = definingContext;
        ArrayList<IOException> suppressedExceptions = new ArrayList<IOException>();
        this.dexElements = DexPathList.makeDexElements(DexPathList.splitDexPath(dexPath), optimizedDirectory, suppressedExceptions, definingContext);
        this.nativeLibraryDirectories = DexPathList.splitPaths(librarySearchPath, false);
        this.systemNativeLibraryDirectories = DexPathList.splitPaths(System.getProperty("java.library.path"), true);
        ArrayList<File> allNativeLibraryDirectories = new ArrayList<File>(this.nativeLibraryDirectories);
        allNativeLibraryDirectories.addAll(this.systemNativeLibraryDirectories);
        this.nativeLibraryPathElements = DexPathList.makePathElements(allNativeLibraryDirectories);
        this.dexElementsSuppressedExceptions = suppressedExceptions.size() > 0 ? suppressedExceptions.toArray(new IOException[suppressedExceptions.size()]) : null;
    }

    public String toString() {
        ArrayList<File> allNativeLibraryDirectories = new ArrayList<File>(this.nativeLibraryDirectories);
        allNativeLibraryDirectories.addAll(this.systemNativeLibraryDirectories);
        Object[] nativeLibraryDirectoriesArray = allNativeLibraryDirectories.toArray(new File[allNativeLibraryDirectories.size()]);
        return "DexPathList[" + Arrays.toString(this.dexElements) + ",nativeLibraryDirectories=" + Arrays.toString(nativeLibraryDirectoriesArray) + "]";
    }

    public List<File> getNativeLibraryDirectories() {
        return this.nativeLibraryDirectories;
    }

    public void addDexPath(String dexPath, File optimizedDirectory) {
        ArrayList<IOException> suppressedExceptionList = new ArrayList<IOException>();
        Element[] newElements = DexPathList.makeDexElements(DexPathList.splitDexPath(dexPath), optimizedDirectory, suppressedExceptionList, this.definingContext);
        if (newElements != null && newElements.length > 0) {
            Element[] oldElements = this.dexElements;
            this.dexElements = new Element[oldElements.length + newElements.length];
            System.arraycopy(oldElements, 0, this.dexElements, 0, oldElements.length);
            System.arraycopy(newElements, 0, this.dexElements, oldElements.length, newElements.length);
        }
        if (suppressedExceptionList.size() > 0) {
            IOException[] newSuppressedExceptions = suppressedExceptionList.toArray(new IOException[suppressedExceptionList.size()]);
            if (this.dexElementsSuppressedExceptions != null) {
                IOException[] oldSuppressedExceptions = this.dexElementsSuppressedExceptions;
                int suppressedExceptionsLength = oldSuppressedExceptions.length + newSuppressedExceptions.length;
                this.dexElementsSuppressedExceptions = new IOException[suppressedExceptionsLength];
                System.arraycopy(oldSuppressedExceptions, 0, this.dexElementsSuppressedExceptions, 0, oldSuppressedExceptions.length);
                System.arraycopy(newSuppressedExceptions, 0, this.dexElementsSuppressedExceptions, oldSuppressedExceptions.length, newSuppressedExceptions.length);
            } else {
                this.dexElementsSuppressedExceptions = newSuppressedExceptions;
            }
        }
    }

    private static List<File> splitDexPath(String path) {
        return DexPathList.splitPaths(path, false);
    }

    private static List<File> splitPaths(String searchPath, boolean directoriesOnly) {
        ArrayList<File> result = new ArrayList<File>();
        if (searchPath != null) {
            for (String path : searchPath.split(File.pathSeparator)) {
                if (directoriesOnly) {
                    try {
                        StructStat sb = Libcore.os.stat(path);
                        if (!OsConstants.S_ISDIR(sb.st_mode)) {
                        }
                    }
                    catch (ErrnoException ignored) {}
                    continue;
                }
                result.add(new File(path));
            }
        }
        return result;
    }

    private static Element[] makeInMemoryDexElements(ByteBuffer[] dexFiles, List<IOException> suppressedExceptions) {
        Element[] elements = new Element[dexFiles.length];
        int elementPos = 0;
        for (ByteBuffer buf : dexFiles) {
            try {
                DexFile dex = new DexFile(buf);
                elements[elementPos++] = new Element(dex);
            }
            catch (IOException suppressed) {
                System_Delegate.log("Unable to load dex file: " + buf, suppressed);
                suppressedExceptions.add(suppressed);
            }
        }
        if (elementPos != elements.length) {
            elements = Arrays.copyOf(elements, elementPos);
        }
        return elements;
    }

    private static Element[] makeDexElements(List<File> files, File optimizedDirectory, List<IOException> suppressedExceptions, ClassLoader loader) {
        Element[] elements = new Element[files.size()];
        int elementsPos = 0;
        for (File file : files) {
            if (file.isDirectory()) {
                elements[elementsPos++] = new Element(file);
                continue;
            }
            if (file.isFile()) {
                DexFile dex;
                String name = file.getName();
                if (name.endsWith(DEX_SUFFIX)) {
                    try {
                        dex = DexPathList.loadDexFile(file, optimizedDirectory, loader, elements);
                        if (dex == null) continue;
                        elements[elementsPos++] = new Element(dex, null);
                    }
                    catch (IOException suppressed) {
                        System_Delegate.log("Unable to load dex file: " + file, suppressed);
                        suppressedExceptions.add(suppressed);
                    }
                    continue;
                }
                dex = null;
                try {
                    dex = DexPathList.loadDexFile(file, optimizedDirectory, loader, elements);
                }
                catch (IOException suppressed) {
                    suppressedExceptions.add(suppressed);
                }
                if (dex == null) {
                    elements[elementsPos++] = new Element(file);
                    continue;
                }
                elements[elementsPos++] = new Element(dex, file);
                continue;
            }
            System_Delegate.log("ClassLoader referenced unknown path: " + file);
        }
        if (elementsPos != elements.length) {
            elements = Arrays.copyOf(elements, elementsPos);
        }
        return elements;
    }

    private static DexFile loadDexFile(File file, File optimizedDirectory, ClassLoader loader, Element[] elements) throws IOException {
        if (optimizedDirectory == null) {
            return new DexFile(file, loader, elements);
        }
        String optimizedPath = DexPathList.optimizedPathFor(file, optimizedDirectory);
        return DexFile.loadDex(file.getPath(), optimizedPath, 0, loader, elements);
    }

    private static String optimizedPathFor(File path, File optimizedDirectory) {
        String fileName = path.getName();
        if (!fileName.endsWith(DEX_SUFFIX)) {
            int lastDot = fileName.lastIndexOf(".");
            if (lastDot < 0) {
                fileName = fileName + DEX_SUFFIX;
            } else {
                StringBuilder sb = new StringBuilder(lastDot + 4);
                sb.append(fileName, 0, lastDot);
                sb.append(DEX_SUFFIX);
                fileName = sb.toString();
            }
        }
        File result = new File(optimizedDirectory, fileName);
        return result.getPath();
    }

    private static Element[] makePathElements(List<File> files, File optimizedDirectory, List<IOException> suppressedExceptions) {
        return DexPathList.makeDexElements(files, optimizedDirectory, suppressedExceptions, null);
    }

    private static NativeLibraryElement[] makePathElements(List<File> files) {
        NativeLibraryElement[] elements = new NativeLibraryElement[files.size()];
        int elementsPos = 0;
        for (File file : files) {
            String path = file.getPath();
            if (path.contains(zipSeparator)) {
                String[] split = path.split(zipSeparator, 2);
                File zip = new File(split[0]);
                String dir = split[1];
                elements[elementsPos++] = new NativeLibraryElement(zip, dir);
                continue;
            }
            if (!file.isDirectory()) continue;
            elements[elementsPos++] = new NativeLibraryElement(file);
        }
        if (elementsPos != elements.length) {
            elements = Arrays.copyOf(elements, elementsPos);
        }
        return elements;
    }

    public Class<?> findClass(String name, List<Throwable> suppressed) {
        for (Element element : this.dexElements) {
            Class<?> clazz = element.findClass(name, this.definingContext, suppressed);
            if (clazz == null) continue;
            return clazz;
        }
        if (this.dexElementsSuppressedExceptions != null) {
            suppressed.addAll(Arrays.asList(this.dexElementsSuppressedExceptions));
        }
        return null;
    }

    public URL findResource(String name) {
        for (Element element : this.dexElements) {
            URL url = element.findResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public Enumeration<URL> findResources(String name) {
        ArrayList<URL> result = new ArrayList<URL>();
        for (Element element : this.dexElements) {
            URL url = element.findResource(name);
            if (url == null) continue;
            result.add(url);
        }
        return Collections.enumeration(result);
    }

    public String findLibrary(String libraryName) {
        String fileName = System.mapLibraryName(libraryName);
        for (NativeLibraryElement element : this.nativeLibraryPathElements) {
            String path = element.findNativeLibrary(fileName);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    List<String> getDexPaths() {
        ArrayList<String> dexPaths = new ArrayList<String>();
        for (Element e : this.dexElements) {
            String dexPath = e.getDexPath();
            if (dexPath == null) continue;
            dexPaths.add(dexPath);
        }
        return dexPaths;
    }

    static class NativeLibraryElement {
        private final File path;
        private final String zipDir;
        private ClassPathURLStreamHandler urlHandler;
        private boolean initialized;

        public NativeLibraryElement(File dir) {
            this.path = dir;
            this.zipDir = null;
        }

        public NativeLibraryElement(File zip, String zipDir) {
            this.path = zip;
            this.zipDir = zipDir;
            if (zipDir == null) {
                throw new IllegalArgumentException();
            }
        }

        public String toString() {
            if (this.zipDir == null) {
                return "directory \"" + this.path + "\"";
            }
            return "zip file \"" + this.path + "\"" + (!this.zipDir.isEmpty() ? ", dir \"" + this.zipDir + "\"" : "");
        }

        public synchronized void maybeInit() {
            if (this.initialized) {
                return;
            }
            if (this.zipDir == null) {
                this.initialized = true;
                return;
            }
            try {
                this.urlHandler = new ClassPathURLStreamHandler(this.path.getPath());
            }
            catch (IOException ioe) {
                System_Delegate.log("Unable to open zip file: " + this.path, ioe);
                this.urlHandler = null;
            }
            this.initialized = true;
        }

        public String findNativeLibrary(String name) {
            String entryName;
            this.maybeInit();
            if (this.zipDir == null) {
                String entryPath = new File(this.path, name).getPath();
                if (IoUtils.canOpenReadOnly(entryPath)) {
                    return entryPath;
                }
            } else if (this.urlHandler != null && this.urlHandler.isEntryStored(entryName = this.zipDir + '/' + name)) {
                return this.path.getPath() + DexPathList.zipSeparator + entryName;
            }
            return null;
        }
    }

    static class Element {
        private final File path;
        private final DexFile dexFile;
        private ClassPathURLStreamHandler urlHandler;
        private boolean initialized;

        public Element(DexFile dexFile, File dexZipPath) {
            this.dexFile = dexFile;
            this.path = dexZipPath;
        }

        public Element(DexFile dexFile) {
            this.dexFile = dexFile;
            this.path = null;
        }

        public Element(File path) {
            this.path = path;
            this.dexFile = null;
        }

        @Deprecated
        public Element(File dir, boolean isDirectory, File zip, DexFile dexFile) {
            System.err.println("Warning: Using deprecated Element constructor. Do not use internal APIs, this constructor will be removed in the future.");
            if (dir != null && (zip != null || dexFile != null)) {
                throw new IllegalArgumentException("Using dir and zip|dexFile no longer supported.");
            }
            if (isDirectory && (zip != null || dexFile != null)) {
                throw new IllegalArgumentException("Unsupported argument combination.");
            }
            if (dir != null) {
                this.path = dir;
                this.dexFile = null;
            } else {
                this.path = zip;
                this.dexFile = dexFile;
            }
        }

        private String getDexPath() {
            if (this.path != null) {
                return this.path.isDirectory() ? null : this.path.getAbsolutePath();
            }
            if (this.dexFile != null) {
                return this.dexFile.getName();
            }
            return null;
        }

        public String toString() {
            if (this.dexFile == null) {
                return (this.path.isDirectory() ? "directory \"" : "zip file \"") + this.path + "\"";
            }
            if (this.path == null) {
                return "dex file \"" + this.dexFile + "\"";
            }
            return "zip file \"" + this.path + "\"";
        }

        public synchronized void maybeInit() {
            if (this.initialized) {
                return;
            }
            if (this.path == null || this.path.isDirectory()) {
                this.initialized = true;
                return;
            }
            try {
                this.urlHandler = new ClassPathURLStreamHandler(this.path.getPath());
            }
            catch (IOException ioe) {
                System_Delegate.log("Unable to open zip file: " + this.path, ioe);
                this.urlHandler = null;
            }
            this.initialized = true;
        }

        public Class<?> findClass(String name, ClassLoader definingContext, List<Throwable> suppressed) {
            return this.dexFile != null ? this.dexFile.loadClassBinaryName(name, definingContext, suppressed) : null;
        }

        public URL findResource(String name) {
            File resourceFile;
            this.maybeInit();
            if (this.urlHandler != null) {
                return this.urlHandler.getEntryUrlOrNull(name);
            }
            if (this.path != null && this.path.isDirectory() && (resourceFile = new File(this.path, name)).exists()) {
                try {
                    return resourceFile.toURI().toURL();
                }
                catch (MalformedURLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return null;
        }
    }
}

