/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.publishing;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.model.PublishableProjectModel;
import com.jetbrains.rider.projectView.nodes.ProjectModelNode;
import com.jetbrains.rider.run.configurations.publishing.PublishAndUploadRunConfigurationType;
import com.jetbrains.rider.run.configurations.publishing.RiderContextPublishProvider;
import com.jetbrains.rider.run.configurations.publishing.base.PublishRunConfiguration;
import com.jetbrains.rider.run.configurations.publishing.base.PublishRunConfigurationFactory;
import icons.RiderIcons;
import java.util.Map;
import java.util.UUID;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/publishing/CustomServerContextPublishProvider;", "Lcom/jetbrains/rider/run/configurations/publishing/RiderContextPublishProvider;", "()V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "name", "", "getName", "()Ljava/lang/String;", "getConfigurationForNode", "Lkotlin/Pair;", "Lcom/intellij/execution/configurations/RunConfiguration;", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "project", "Lcom/intellij/openapi/project/Project;", "projectModelNode", "Lcom/jetbrains/rider/projectView/nodes/ProjectModelNode;", "isAvailable", "", "rider-publish-custom-server"})
public final class CustomServerContextPublishProvider
implements RiderContextPublishProvider {
    @NotNull
    private final Icon icon = RiderIcons.Publish.PublishCustomServer;
    @NotNull
    private final String name = "Publish to custom server";

    public boolean isAvailable(@NotNull Project project, @NotNull ProjectModelNode projectModelNode) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)projectModelNode, (String)"projectModelNode");
        Map.Entry projectData = RiderContextPublishProvider.Companion.getProjectData(project, projectModelNode);
        return projectData != null && ((PublishableProjectModel)projectData.getValue()).isDotNetCore();
    }

    @NotNull
    public Pair<RunConfiguration, ConfigurationFactory> getConfigurationForNode(@NotNull Project project, @NotNull ProjectModelNode projectModelNode) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)projectModelNode, (String)"projectModelNode");
        Map.Entry entry = RiderContextPublishProvider.Companion.getProjectData(project, projectModelNode);
        if (entry == null) {
            String string = "Unsupported project model node, bug?";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Map.Entry projectData = entry;
        Object object = ArraysKt.single((Object[])((PublishAndUploadRunConfigurationType)ConfigurationTypeUtil.findConfigurationType(PublishAndUploadRunConfigurationType.class)).getConfigurationFactories());
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.rider.run.configurations.publishing.base.PublishRunConfigurationFactory<*>");
        }
        PublishRunConfigurationFactory factory = (PublishRunConfigurationFactory)object;
        PublishRunConfiguration configuration = new PublishRunConfiguration(project, factory, "Publish " + ((PublishableProjectModel)projectData.getValue()).getProjectName() + " to custom server");
        configuration.getSettings().setUuid((UUID)projectData.getKey());
        return new Pair((Object)configuration, (Object)factory);
    }

    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @NotNull
    public String getName() {
        return this.name;
    }
}

