/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import git4idea.DialogManager;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.ui.GithubChooseAccountDialog;
import org.jetbrains.plugins.github.util.GitRemoteUrlCoordinates;
import org.jetbrains.plugins.github.util.GithubAccountsMigrationHelper;
import org.jetbrains.plugins.github.util.GithubGitHelper;
import org.jetbrains.plugins.github.util.GithubUrlUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J8\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H$J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J0\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u00042\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00150\u001eH\u0002J\u0006\u0010\u001f\u001a\u00020\u0017J\u001a\u0010 \u001a\u0004\u0018\u00010\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u001b\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0006\u0010&\u001a\u00020\u0017J\u000e\u0010'\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/github/AbstractGithubUrlGroupingAction;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "text", "", "description", "icon", "Ljavax/swing/Icon;", "(Ljava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "remoteUrl", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "canBePerformed", "", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "chooseAccount", "authenticationManager", "Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;", "accounts", "", "disableIfNoVisibleChildren", "getAccount", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "isEnabledAndVisible", "isPopup", "update", "intellij.vcs.github"})
public abstract class AbstractGithubUrlGroupingAction
extends ActionGroup
implements DumbAware {
    public final void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(this.isEnabledAndVisible(e));
    }

    protected boolean isEnabledAndVisible(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDefault()) {
            return false;
        }
        Object object = ServiceManager.getService(GithubGitHelper.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
        return ((GithubGitHelper)object).havePossibleRemotes(project);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray;
        AnActionEvent anActionEvent = e;
        if (anActionEvent == null || (anActionEvent = (Project)anActionEvent.getData(CommonDataKeys.PROJECT)) == null) {
            Intrinsics.checkExpressionValueIsNotNull((Object)AnAction.EMPTY_ARRAY, (String)"AnAction.EMPTY_ARRAY");
            return AnAction.EMPTY_ARRAY;
        }
        AnActionEvent project = anActionEvent;
        Object object = ServiceManager.getService(GithubGitHelper.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
        GithubGitHelper githubGitHelper = (GithubGitHelper)object;
        AnActionEvent anActionEvent2 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)anActionEvent2, (String)"project");
        Set<GitRemoteUrlCoordinates> coordinates = githubGitHelper.getPossibleRemoteUrlCoordinates((Project)anActionEvent2);
        if (coordinates.size() > 1) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)coordinates;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                GitRemoteUrlCoordinates gitRemoteUrlCoordinates = (GitRemoteUrlCoordinates)item$iv$iv;
                Collection collection = destination$iv$iv;
                DumbAwareAction dumbAwareAction = new DumbAwareAction((GitRemoteUrlCoordinates)it, GithubUrlUtil.removeProtocolPrefix(it.getUrl()), this, (Project)project){
                    final /* synthetic */ GitRemoteUrlCoordinates $it;
                    final /* synthetic */ AbstractGithubUrlGroupingAction this$0;
                    final /* synthetic */ Project $project$inlined;
                    {
                        this.$it = $captured_local_variable$1;
                        this.this$0 = abstractGithubUrlGroupingAction;
                        this.$project$inlined = project;
                        super($super_call_param$2);
                    }

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                        Project project = this.$project$inlined;
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                        AbstractGithubUrlGroupingAction.access$actionPerformed(this.this$0, e, project, this.$it.getRepository(), this.$it.getRemote(), this.$it.getUrl());
                    }
                };
                collection.add(dumbAwareAction);
            }
            $receiver$iv = (List)destination$iv$iv;
            Iterable thisCollection$iv = $receiver$iv;
            AnAction[] anActionArray2 = thisCollection$iv.toArray(new AnAction[0]);
            if (anActionArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            anActionArray = anActionArray2;
        } else {
            anActionArray = AnAction.EMPTY_ARRAY;
            Intrinsics.checkExpressionValueIsNotNull((Object)AnAction.EMPTY_ARRAY, (String)"AnAction.EMPTY_ARRAY");
        }
        return anActionArray;
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        block1: {
            GitRemoteUrlCoordinates gitRemoteUrlCoordinates;
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            if (project == null) {
                return;
            }
            Project project2 = project;
            Object object = ServiceManager.getService(GithubGitHelper.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
            GithubGitHelper githubGitHelper = (GithubGitHelper)object;
            Project project3 = project2;
            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
            Set<GitRemoteUrlCoordinates> coordinates = githubGitHelper.getPossibleRemoteUrlCoordinates(project3);
            GitRemoteUrlCoordinates gitRemoteUrlCoordinates2 = (GitRemoteUrlCoordinates)CollectionsKt.singleOrNull((Iterable)coordinates);
            if (gitRemoteUrlCoordinates2 == null) break block1;
            GitRemoteUrlCoordinates it = gitRemoteUrlCoordinates = gitRemoteUrlCoordinates2;
            this.actionPerformed(e, project2, it.getRepository(), it.getRemote(), it.getUrl());
        }
    }

    public final boolean canBePerformed(@NotNull DataContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Project project = (Project)context.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return false;
        }
        Project project2 = project;
        Object object = ServiceManager.getService(GithubGitHelper.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
        GithubGitHelper githubGitHelper = (GithubGitHelper)object;
        Project project3 = project2;
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        Set<GitRemoteUrlCoordinates> coordinates = githubGitHelper.getPossibleRemoteUrlCoordinates(project3);
        return coordinates.size() == 1;
    }

    public final boolean isPopup() {
        return true;
    }

    public final boolean disableIfNoVisibleChildren() {
        return false;
    }

    private final void actionPerformed(AnActionEvent e, Project project, GitRepository repository, GitRemote remote, String remoteUrl) {
        Object object = ServiceManager.getService(GithubAccountsMigrationHelper.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
        if (!GithubAccountsMigrationHelper.migrate$default((GithubAccountsMigrationHelper)object, project, null, 2, null)) {
            return;
        }
        GithubAccount githubAccount = this.getAccount(project, remoteUrl);
        if (githubAccount == null) {
            return;
        }
        GithubAccount account = githubAccount;
        this.actionPerformed(e, project, repository, remote, remoteUrl, account);
    }

    /*
     * WARNING - void declaration
     */
    private final GithubAccount getAccount(Project project, String remoteUrl) {
        GithubAccount githubAccount;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Object object = ServiceManager.getService(GithubAuthenticationManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
        GithubAuthenticationManager authenticationManager = (GithubAuthenticationManager)object;
        Iterable iterable = $receiver$iv = (Iterable)authenticationManager.getAccounts();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            GithubAccount it = (GithubAccount)element$iv$iv;
            if (!it.getServer().matches(remoteUrl)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List accounts = (List)destination$iv$iv;
        if (accounts.isEmpty()) {
            if (!GithubServerPath.DEFAULT_SERVER.matches(remoteUrl)) {
                throw (Throwable)new IllegalArgumentException("Remote " + remoteUrl + " does not match " + GithubServerPath.DEFAULT_SERVER);
            }
            GithubServerPath githubServerPath = GithubServerPath.DEFAULT_SERVER;
            Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"GithubServerPath.DEFAULT_SERVER");
            return GithubAuthenticationManager.requestNewAccountForServer$default(authenticationManager, githubServerPath, project, null, 4, null);
        }
        GithubAccount githubAccount2 = (GithubAccount)CollectionsKt.singleOrNull((List)accounts);
        if (githubAccount2 == null) {
            Iterator iterator;
            block6: {
                Iterable iterable2;
                iterable = iterable2 = (Iterable)accounts;
                for (Iterator iterator2 : iterable) {
                    GithubAccount it = (GithubAccount)((Object)iterator2);
                    if (!Intrinsics.areEqual((Object)it, (Object)authenticationManager.getDefaultAccount(project))) continue;
                    iterator = iterator2;
                    break block6;
                }
                iterator = null;
            }
            githubAccount2 = githubAccount = (GithubAccount)((Object)iterator);
        }
        if (githubAccount2 == null) {
            githubAccount = this.chooseAccount(project, authenticationManager, remoteUrl, accounts);
        }
        return githubAccount;
    }

    private final GithubAccount chooseAccount(Project project, GithubAuthenticationManager authenticationManager, String remoteUrl, List<? extends GithubAccount> accounts) {
        GithubChooseAccountDialog dialog2 = new GithubChooseAccountDialog(project, null, accounts, "Choose GitHub account for: " + remoteUrl, false, true, null, null, 192, null);
        DialogManager.show((DialogWrapper)dialog2);
        if (!dialog2.isOK()) {
            return null;
        }
        GithubAccount account = dialog2.getAccount();
        if (dialog2.getSetDefault()) {
            authenticationManager.setDefaultAccount(project, account);
        }
        return account;
    }

    protected abstract void actionPerformed(@NotNull AnActionEvent var1, @NotNull Project var2, @NotNull GitRepository var3, @NotNull GitRemote var4, @NotNull String var5, @NotNull GithubAccount var6);

    public AbstractGithubUrlGroupingAction(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    public static final /* synthetic */ void access$actionPerformed(AbstractGithubUrlGroupingAction $this, @NotNull AnActionEvent e, @NotNull Project project, @NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String remoteUrl) {
        $this.actionPerformed(e, project, repository, remote, remoteUrl);
    }
}

