/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitBranchUiHandlerImpl;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchWorker;
import git4idea.branch.GitNewBranchOptions;
import git4idea.commands.Git;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GithubSearchedIssue;
import org.jetbrains.plugins.github.pullrequest.action.GithubPullRequestCreateBranchAction;
import org.jetbrains.plugins.github.pullrequest.action.GithubPullRequestKeys;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestDataProvider;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/action/GithubPullRequestCreateBranchAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.vcs.github"})
public final class GithubPullRequestCreateBranchAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        GithubSearchedIssue pullRequest = (GithubSearchedIssue)e.getData(GithubPullRequestKeys.getSELECTED_PULL_REQUEST());
        GithubPullRequestDataProvider dataProvider = (GithubPullRequestDataProvider)e.getData(GithubPullRequestKeys.getSELECTED_PULL_REQUEST_DATA_PROVIDER());
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabled(project != null && !project.isDefault() && pullRequest != null && dataProvider != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        GithubSearchedIssue pullRequest = (GithubSearchedIssue)e.getRequiredData(GithubPullRequestKeys.getSELECTED_PULL_REQUEST());
        GitRepository repository = (GitRepository)e.getRequiredData(GithubPullRequestKeys.getREPOSITORY());
        List repositoryList = CollectionsKt.listOf((Object)repository);
        CompletableFuture<Couple<String>> hashesFuture = ((GithubPullRequestDataProvider)e.getRequiredData(GithubPullRequestKeys.getSELECTED_PULL_REQUEST_DATA_PROVIDER())).getBranchFetchRequest();
        Collection collection = repositoryList;
        StringBuilder stringBuilder = new StringBuilder().append("Checkout New Branch From Pull Request #");
        GithubSearchedIssue githubSearchedIssue = pullRequest;
        Intrinsics.checkExpressionValueIsNotNull((Object)githubSearchedIssue, (String)"pullRequest");
        GitNewBranchOptions gitNewBranchOptions = GitBranchUtil.getNewBranchNameFromUser((Project)project, (Collection)collection, (String)stringBuilder.append(githubSearchedIssue.getNumber()).toString(), (String)("pull/" + pullRequest.getNumber()));
        if (gitNewBranchOptions == null) {
            return;
        }
        GitNewBranchOptions options = gitNewBranchOptions;
        if (options.shouldCheckout()) {
            new Task.Backgroundable(hashesFuture, project, options, repositoryList, project, "Creating Branch From Pull Request", true){
                private final Git git;
                private final VcsNotifier vcsNotifier;
                final /* synthetic */ CompletableFuture $hashesFuture;
                final /* synthetic */ Project $project;
                final /* synthetic */ GitNewBranchOptions $options;
                final /* synthetic */ List $repositoryList;

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                    String sha = (String)((Couple)this.$hashesFuture.get()).second;
                    indicator.setText("Creating branch");
                    new GitBranchWorker(this.$project, this.git, (GitBranchUiHandler)new GitBranchUiHandlerImpl(this.$project, this.git, indicator)).checkoutNewBranchStartingFrom(this.$options.getName(), sha, this.$repositoryList);
                }

                public void onSuccess() {
                    this.vcsNotifier.notifySuccess("Created Branch " + this.$options.getName());
                }

                public void onThrowable(@NotNull Throwable error) {
                    Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                    String string = error.getMessage();
                    String string2 = "Failed To Create Branch";
                    VcsNotifier vcsNotifier = this.vcsNotifier;
                    String string3 = string;
                    if (string3 == null) {
                        string3 = "";
                    }
                    String string4 = string3;
                    vcsNotifier.notifyError(string2, string4);
                }
                {
                    void $receiver$iv;
                    this.$hashesFuture = $captured_local_variable$0;
                    this.$project = $captured_local_variable$1;
                    this.$options = $captured_local_variable$2;
                    this.$repositoryList = $captured_local_variable$3;
                    super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                    this.git = Git.getInstance();
                    Project project = $captured_local_variable$1;
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                    Project project2 = project;
                    actionPerformed.1 var10_9 = this;
                    Object object = ServiceManager.getService((Project)$receiver$iv, VcsNotifier.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(this, T::class.java)");
                    Object object2 = object;
                    var10_9.vcsNotifier = (VcsNotifier)object2;
                }
            }.queue();
        } else {
            new Task.Backgroundable(hashesFuture, project, options, repository, project, "Checking Out Branch From Pull Request", true){
                private final Git git;
                private final VcsNotifier vcsNotifier;
                final /* synthetic */ CompletableFuture $hashesFuture;
                final /* synthetic */ Project $project;
                final /* synthetic */ GitNewBranchOptions $options;
                final /* synthetic */ GitRepository $repository;

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                    String sha = (String)((Couple)this.$hashesFuture.get()).second;
                    indicator.setText("Checking out branch");
                    new GitBranchWorker(this.$project, this.git, (GitBranchUiHandler)new GitBranchUiHandlerImpl(this.$project, this.git, indicator)).createBranch(this.$options.getName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)this.$repository, (Object)sha)));
                }

                public void onSuccess() {
                    this.vcsNotifier.notifySuccess("Checked Out Branch " + this.$options.getName());
                }

                public void onThrowable(@NotNull Throwable error) {
                    Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                    String string = error.getMessage();
                    String string2 = "Failed to Checkout Branch";
                    VcsNotifier vcsNotifier = this.vcsNotifier;
                    String string3 = string;
                    if (string3 == null) {
                        string3 = "";
                    }
                    String string4 = string3;
                    vcsNotifier.notifyError(string2, string4);
                }
                {
                    void $receiver$iv;
                    this.$hashesFuture = $captured_local_variable$0;
                    this.$project = $captured_local_variable$1;
                    this.$options = $captured_local_variable$2;
                    this.$repository = $captured_local_variable$3;
                    super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                    this.git = Git.getInstance();
                    Project project = $captured_local_variable$1;
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                    Project project2 = project;
                    actionPerformed.2 var10_9 = this;
                    Object object = ServiceManager.getService((Project)$receiver$iv, VcsNotifier.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(this, T::class.java)");
                    Object object2 = object;
                    var10_9.vcsNotifier = (VcsNotifier)object2;
                }
            }.queue();
        }
    }

    public GithubPullRequestCreateBranchAction() {
        super("Create New Local Branch...", "Checkout synthetic pull request branch", null);
    }
}

