/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.avatars;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import icons.GithubIcons;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.data.GithubUser;
import org.jetbrains.plugins.github.pullrequest.avatars.CachingGithubAvatarIconsProvider$getIcon$;
import org.jetbrains.plugins.github.util.CachingGithubUserAvatarLoader;
import org.jetbrains.plugins.github.util.GithubImageResizer;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000e0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider;", "Lcom/intellij/openapi/Disposable;", "avatarsLoader", "Lorg/jetbrains/plugins/github/util/CachingGithubUserAvatarLoader;", "imagesResizer", "Lorg/jetbrains/plugins/github/util/GithubImageResizer;", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "iconSize", "Lcom/intellij/util/ui/JBValue;", "component", "Ljava/awt/Component;", "(Lorg/jetbrains/plugins/github/util/CachingGithubUserAvatarLoader;Lorg/jetbrains/plugins/github/util/GithubImageResizer;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lcom/intellij/util/ui/JBValue;Ljava/awt/Component;)V", "defaultIcon", "Ljavax/swing/Icon;", "icons", "", "Lorg/jetbrains/plugins/github/api/data/GithubUser;", "scaleContext", "Lcom/intellij/util/ui/JBUI$ScaleContext;", "createDefaultIcon", "size", "", "dispose", "", "getIcon", "user", "DelegatingIcon", "Factory", "intellij.vcs.github"})
public final class CachingGithubAvatarIconsProvider
implements Disposable {
    private final JBUI.ScaleContext scaleContext;
    private Icon defaultIcon;
    private final Map<GithubUser, Icon> icons;
    private final CachingGithubUserAvatarLoader avatarsLoader;
    private final GithubImageResizer imagesResizer;
    private final GithubApiRequestExecutor requestExecutor;
    private final JBValue iconSize;
    private final Component component;

    private final Icon createDefaultIcon(int size) {
        Icon standardDefaultAvatar = GithubIcons.DefaultAvatar_40;
        float f = size;
        Icon icon = standardDefaultAvatar;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"standardDefaultAvatar");
        float scale = f / (float)icon.getIconWidth();
        Icon icon2 = IconUtil.scale((Icon)standardDefaultAvatar, null, (float)scale);
        Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"IconUtil.scale(standardDefaultAvatar, null, scale)");
        return icon2;
    }

    @NotNull
    public final Icon getIcon(@NotNull GithubUser user) {
        Icon icon;
        Map<GithubUser, Icon> $receiver$iv;
        Icon value$iv;
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        int iconSize = this.iconSize.get();
        if (this.scaleContext.update((JBUI.BaseScaleContext)JBUI.ScaleContext.create((Component)this.component))) {
            this.defaultIcon = this.createDefaultIcon(iconSize);
            this.icons.clear();
        }
        if ((value$iv = ($receiver$iv = this.icons).get(user)) == null) {
            DelegatingIcon icon2 = new DelegatingIcon(this.defaultIcon);
            ((CompletableFuture)this.avatarsLoader.requestAvatar(this.requestExecutor, user).thenCompose(new Function<T, CompletionStage<U>>(this, user, iconSize){
                final /* synthetic */ CachingGithubAvatarIconsProvider this$0;
                final /* synthetic */ GithubUser $user$inlined;
                final /* synthetic */ int $iconSize$inlined;
                {
                    this.this$0 = cachingGithubAvatarIconsProvider;
                    this.$user$inlined = githubUser;
                    this.$iconSize$inlined = n;
                }

                public final CompletionStage<Image> apply(@Nullable Image it) {
                    CompletionStage completionStage;
                    if (it != null) {
                        GithubImageResizer githubImageResizer = CachingGithubAvatarIconsProvider.access$getImagesResizer$p(this.this$0);
                        JBUI.ScaleContext scaleContext = CachingGithubAvatarIconsProvider.access$getScaleContext$p(this.this$0);
                        Intrinsics.checkExpressionValueIsNotNull((Object)scaleContext, (String)"scaleContext");
                        completionStage = githubImageResizer.requestImageResize(it, this.$iconSize$inlined, scaleContext);
                    } else {
                        completionStage = CompletableFuture.completedFuture(null);
                    }
                    return completionStage;
                }
            })).thenAccept(new Consumer<Image>(icon2, this, user, iconSize){
                final /* synthetic */ DelegatingIcon $icon;
                final /* synthetic */ CachingGithubAvatarIconsProvider this$0;
                final /* synthetic */ GithubUser $user$inlined;
                final /* synthetic */ int $iconSize$inlined;
                {
                    this.$icon = delegatingIcon;
                    this.this$0 = cachingGithubAvatarIconsProvider;
                    this.$user$inlined = githubUser;
                    this.$iconSize$inlined = n;
                }

                public final void accept(@Nullable Image it) {
                    if (it != null) {
                        Application app$iv;
                        ModalityState modalityState$iv = null;
                        Application application = app$iv = ApplicationManager.getApplication();
                        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
                        if (application.isDispatchThread()) {
                            JBImageIcon jBImageIcon = IconUtil.createImageIcon((Image)it);
                            Intrinsics.checkExpressionValueIsNotNull((Object)jBImageIcon, (String)"IconUtil.createImageIcon(it)");
                            this.$icon.setDelegate((Icon)jBImageIcon);
                            CachingGithubAvatarIconsProvider.access$getComponent$p(this.this$0).repaint();
                        } else {
                            app$iv.invokeLater(new Runnable(this, it){
                                final /* synthetic */ getIcon$$inlined$getOrPut$lambda$2 this$0;
                                final /* synthetic */ Image $it$inlined;
                                {
                                    this.this$0 = var1_1;
                                    this.$it$inlined = image2;
                                }

                                public final void run() {
                                    DelegatingIcon delegatingIcon = this.this$0.$icon;
                                    JBImageIcon jBImageIcon = IconUtil.createImageIcon((Image)this.$it$inlined);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)jBImageIcon, (String)"IconUtil.createImageIcon(it)");
                                    delegatingIcon.setDelegate((Icon)jBImageIcon);
                                    CachingGithubAvatarIconsProvider.access$getComponent$p(this.this$0.this$0).repaint();
                                }
                            }, ModalityState.defaultModalityState());
                        }
                    }
                }
            });
            DelegatingIcon answer$iv = icon2;
            $receiver$iv.put(user, answer$iv);
            icon = answer$iv;
        } else {
            icon = value$iv;
        }
        return icon;
    }

    public void dispose() {
    }

    public CachingGithubAvatarIconsProvider(@NotNull CachingGithubUserAvatarLoader avatarsLoader, @NotNull GithubImageResizer imagesResizer, @NotNull GithubApiRequestExecutor requestExecutor, @NotNull JBValue iconSize, @NotNull Component component) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)avatarsLoader, (String)"avatarsLoader");
        Intrinsics.checkParameterIsNotNull((Object)imagesResizer, (String)"imagesResizer");
        Intrinsics.checkParameterIsNotNull((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkParameterIsNotNull((Object)iconSize, (String)"iconSize");
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        this.avatarsLoader = avatarsLoader;
        this.imagesResizer = imagesResizer;
        this.requestExecutor = requestExecutor;
        this.iconSize = iconSize;
        this.component = component;
        this.scaleContext = JBUI.ScaleContext.create((Component)this.component);
        this.defaultIcon = this.createDefaultIcon(this.iconSize.get());
        CachingGithubAvatarIconsProvider cachingGithubAvatarIconsProvider = this;
        cachingGithubAvatarIconsProvider.icons = map2 = (Map)new LinkedHashMap();
        LowMemoryWatcher.register((Runnable)new Runnable(){

            @Override
            public final void run() {
                icons.clear();
            }
        }, (Disposable)this);
    }

    @NotNull
    public static final /* synthetic */ GithubImageResizer access$getImagesResizer$p(CachingGithubAvatarIconsProvider $this) {
        return $this.imagesResizer;
    }

    @NotNull
    public static final /* synthetic */ JBUI.ScaleContext access$getScaleContext$p(CachingGithubAvatarIconsProvider $this) {
        return $this.scaleContext;
    }

    @NotNull
    public static final /* synthetic */ Component access$getComponent$p(CachingGithubAvatarIconsProvider $this) {
        return $this.component;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J,\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0016R\u001a\u0010\u0002\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0003\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider$DelegatingIcon;", "Ljavax/swing/Icon;", "delegate", "(Ljavax/swing/Icon;)V", "getDelegate", "()Ljavax/swing/Icon;", "setDelegate", "getIconHeight", "", "getIconWidth", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "intellij.vcs.github"})
    private static final class DelegatingIcon
    implements Icon {
        @NotNull
        private Icon delegate;

        @Override
        public int getIconHeight() {
            return this.delegate.getIconHeight();
        }

        @Override
        public int getIconWidth() {
            return this.delegate.getIconWidth();
        }

        @Override
        public void paintIcon(@Nullable Component c, @Nullable Graphics g, int x, int y) {
            this.delegate.paintIcon(c, g, x, y);
        }

        @NotNull
        public final Icon getDelegate() {
            return this.delegate;
        }

        public final void setDelegate(@NotNull Icon icon) {
            Intrinsics.checkParameterIsNotNull((Object)icon, (String)"<set-?>");
            this.delegate = icon;
        }

        public DelegatingIcon(@NotNull Icon delegate) {
            Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
            this.delegate = delegate;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider$Factory;", "", "avatarsLoader", "Lorg/jetbrains/plugins/github/util/CachingGithubUserAvatarLoader;", "imagesResizer", "Lorg/jetbrains/plugins/github/util/GithubImageResizer;", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "(Lorg/jetbrains/plugins/github/util/CachingGithubUserAvatarLoader;Lorg/jetbrains/plugins/github/util/GithubImageResizer;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;)V", "create", "Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider;", "iconSize", "Lcom/intellij/util/ui/JBValue;", "component", "Ljava/awt/Component;", "intellij.vcs.github"})
    public static final class Factory {
        private final CachingGithubUserAvatarLoader avatarsLoader;
        private final GithubImageResizer imagesResizer;
        private final GithubApiRequestExecutor requestExecutor;

        @NotNull
        public final CachingGithubAvatarIconsProvider create(@NotNull JBValue iconSize, @NotNull Component component) {
            Intrinsics.checkParameterIsNotNull((Object)iconSize, (String)"iconSize");
            Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
            return new CachingGithubAvatarIconsProvider(this.avatarsLoader, this.imagesResizer, this.requestExecutor, iconSize, component);
        }

        public Factory(@NotNull CachingGithubUserAvatarLoader avatarsLoader, @NotNull GithubImageResizer imagesResizer, @NotNull GithubApiRequestExecutor requestExecutor) {
            Intrinsics.checkParameterIsNotNull((Object)avatarsLoader, (String)"avatarsLoader");
            Intrinsics.checkParameterIsNotNull((Object)imagesResizer, (String)"imagesResizer");
            Intrinsics.checkParameterIsNotNull((Object)requestExecutor, (String)"requestExecutor");
            this.avatarsLoader = avatarsLoader;
            this.imagesResizer = imagesResizer;
            this.requestExecutor = requestExecutor;
        }
    }
}

