/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListUtil;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.log.ui.frame.ProgressStripe;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GithubErrorMessage;
import org.jetbrains.plugins.github.api.data.GithubResponsePage;
import org.jetbrains.plugins.github.api.data.GithubSearchedIssue;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.plugins.github.pullrequest.action.GithubPullRequestKeys;
import org.jetbrains.plugins.github.pullrequest.avatars.CachingGithubAvatarIconsProvider;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestsLoader;
import org.jetbrains.plugins.github.pullrequest.search.GithubPullRequestSearchComponent;
import org.jetbrains.plugins.github.pullrequest.search.GithubPullRequestSearchModel;
import org.jetbrains.plugins.github.pullrequest.ui.GithubPullRequestsList;
import org.jetbrains.plugins.github.pullrequest.ui.GithubPullRequestsListSelectionModel;
import org.jetbrains.plugins.github.pullrequest.ui.HtmlErrorPanel;
import org.jetbrains.plugins.github.util.GithubAsyncUtil;
import org.jetbrains.plugins.github.util.GithubAsyncUtilKt;
import org.jetbrains.plugins.github.util.ProgressStripeProgressIndicator;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0002J\b\u0010,\u001a\u00020-H\u0016J\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020*H\u0016J\u001a\u00101\u001a\u00020*2\u0006\u00102\u001a\u0002032\b\b\u0002\u00104\u001a\u00020*H\u0002J\u0010\u00105\u001a\u00020\u00142\u0006\u00106\u001a\u000207H\u0002J\b\u00108\u001a\u00020-H\u0002J\u0010\u00109\u001a\u00020-2\u0006\u00102\u001a\u000203H\u0002J\u001e\u0010:\u001a\u00020-2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00190<2\u0006\u0010=\u001a\u00020\u0014H\u0002J\b\u0010>\u001a\u00020-H\u0002J\u0006\u0010?\u001a\u00020-J\b\u0010@\u001a\u00020-H\u0002R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006A"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestsListComponent;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "copyPasteManager", "Lcom/intellij/openapi/ide/CopyPasteManager;", "actionManager", "Lcom/intellij/openapi/actionSystem/ActionManager;", "autoPopupController", "Lcom/intellij/codeInsight/AutoPopupController;", "loader", "Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsLoader;", "avatarIconsProviderFactory", "Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider$Factory;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/ide/CopyPasteManager;Lcom/intellij/openapi/actionSystem/ActionManager;Lcom/intellij/codeInsight/AutoPopupController;Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsLoader;Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider$Factory;)V", "errorPanel", "Lorg/jetbrains/plugins/github/pullrequest/ui/HtmlErrorPanel;", "isDisposed", "", "list", "Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestsList;", "listModel", "Lcom/intellij/ui/CollectionListModel;", "Lorg/jetbrains/plugins/github/api/data/GithubSearchedIssue;", "loadOnScrollThreshold", "progressIndicator", "Lorg/jetbrains/plugins/github/util/ProgressStripeProgressIndicator;", "progressStripe", "Lcom/intellij/vcs/log/ui/frame/ProgressStripe;", "scrollPane", "Ljavax/swing/JScrollPane;", "search", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchComponent;", "searchModel", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchModel;", "selectionModel", "Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestsListSelectionModel;", "getSelectionModel", "()Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestsListSelectionModel;", "addDotIfNeeded", "", "line", "dispose", "", "getData", "", "dataId", "getLoadingErrorText", "error", "", "newLineSeparator", "isScrollAtThreshold", "verticalScrollBar", "Ljavax/swing/JScrollBar;", "loadMore", "loadingErrorOccurred", "moreDataLoaded", "data", "", "hasNext", "potentiallyLoadMore", "refresh", "resetSearch", "intellij.vcs.github"})
public final class GithubPullRequestsListComponent
extends BorderLayoutPanel
implements Disposable,
DataProvider {
    @NotNull
    private final GithubPullRequestsListSelectionModel selectionModel;
    private final CollectionListModel<GithubSearchedIssue> listModel;
    private final GithubPullRequestsList list;
    private final JScrollPane scrollPane;
    private boolean loadOnScrollThreshold;
    private boolean isDisposed;
    private final HtmlErrorPanel errorPanel;
    private final ProgressStripe progressStripe;
    private ProgressStripeProgressIndicator progressIndicator;
    private final GithubPullRequestSearchModel searchModel;
    private final GithubPullRequestSearchComponent search;
    private final GithubPullRequestsLoader loader;

    @NotNull
    public final GithubPullRequestsListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkParameterIsNotNull((Object)dataId, (String)"dataId");
        return GithubPullRequestKeys.getSELECTED_PULL_REQUEST().is(dataId) ? this.selectionModel.getCurrent() : null;
    }

    public final void refresh() {
        this.loadOnScrollThreshold = false;
        this.list.getSelectionModel().clearSelection();
        this.listModel.removeAll();
        this.progressIndicator.cancel();
        this.progressIndicator = new ProgressStripeProgressIndicator(this.progressStripe, true);
        this.loader.reset();
        this.loadMore();
    }

    private final void potentiallyLoadMore() {
        if (this.loadOnScrollThreshold) {
            JScrollPane jScrollPane = this.scrollPane;
            Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane, (String)"scrollPane");
            JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
            Intrinsics.checkExpressionValueIsNotNull((Object)jScrollBar, (String)"scrollPane.verticalScrollBar");
            if (this.isScrollAtThreshold(jScrollBar)) {
                this.loadMore();
            }
        }
    }

    private final void loadMore() {
        if (this.isDisposed) {
            return;
        }
        this.loadOnScrollThreshold = false;
        this.errorPanel.setError(null);
        StatusText statusText = this.list.getEmptyText();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusText, (String)"list.emptyText");
        statusText.setText("Loading pull requests...");
        ProgressStripeProgressIndicator indicator = this.progressIndicator;
        GithubAsyncUtilKt.handleOnEdt(this.loader.requestLoadMore((ProgressIndicator)indicator), (Function2)new Function2<GithubResponsePage<GithubSearchedIssue>, Throwable, Unit>(this, indicator){
            final /* synthetic */ GithubPullRequestsListComponent this$0;
            final /* synthetic */ ProgressStripeProgressIndicator $indicator;

            public final void invoke(@Nullable GithubResponsePage<GithubSearchedIssue> responsePage, @Nullable Throwable error) {
                if (this.$indicator.isCanceled()) {
                    return;
                }
                if (error != null && !GithubAsyncUtil.INSTANCE.isCancellation(error)) {
                    GithubPullRequestsListComponent.access$loadingErrorOccurred(this.this$0, error);
                } else if (responsePage != null) {
                    GithubPullRequestsListComponent.access$moreDataLoaded(this.this$0, responsePage.getItems(), responsePage.getHasNext());
                }
            }
            {
                this.this$0 = githubPullRequestsListComponent;
                this.$indicator = progressStripeProgressIndicator;
                super(2);
            }
        });
    }

    private final boolean isScrollAtThreshold(JScrollBar verticalScrollBar) {
        int visibleAmount = verticalScrollBar.getVisibleAmount();
        int value = verticalScrollBar.getValue();
        int maximum = verticalScrollBar.getMaximum();
        if (maximum == 0) {
            return false;
        }
        float scrollFraction = (float)(visibleAmount + value) / (float)maximum;
        return !((double)scrollFraction < 0.5);
    }

    private final void moreDataLoaded(List<? extends GithubSearchedIssue> data, boolean hasNext) {
        if (this.searchModel.getQuery().isEmpty()) {
            StatusText statusText = this.list.getEmptyText();
            Intrinsics.checkExpressionValueIsNotNull((Object)statusText, (String)"list.emptyText");
            statusText.setText("No pull requests loaded.");
        } else {
            StatusText statusText = this.list.getEmptyText();
            Intrinsics.checkExpressionValueIsNotNull((Object)statusText, (String)"list.emptyText");
            statusText.setText("No pull requests matching filters.");
            Intrinsics.checkExpressionValueIsNotNull((Object)this.list.getEmptyText().appendSecondaryText("Reset Filters", SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(this){
                final /* synthetic */ GithubPullRequestsListComponent this$0;

                public final void actionPerformed(ActionEvent it) {
                    GithubPullRequestsListComponent.access$resetSearch(this.this$0);
                }
                {
                    this.this$0 = githubPullRequestsListComponent;
                }
            }), (String)"list.emptyText.appendSec\u2026    resetSearch()\n      }");
        }
        this.loadOnScrollThreshold = hasNext;
        this.listModel.add(data);
        JScrollPane jScrollPane = this.scrollPane;
        Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane, (String)"scrollPane");
        jScrollPane.getViewport().validate();
        this.potentiallyLoadMore();
    }

    private final void resetSearch() {
        this.search.setSearchText("state:open");
    }

    private final void loadingErrorOccurred(Throwable error) {
        this.loadOnScrollThreshold = false;
        String prefix = this.list.isEmpty() ? "Cannot load pull requests." : "Cannot load full pull requests list.";
        this.list.getEmptyText().clear().appendText(prefix, SimpleTextAttributes.ERROR_ATTRIBUTES).appendSecondaryText(GithubPullRequestsListComponent.getLoadingErrorText$default(this, error, null, 2, null), SimpleTextAttributes.ERROR_ATTRIBUTES, null).appendSecondaryText("  ", SimpleTextAttributes.ERROR_ATTRIBUTES, null).appendSecondaryText("Retry", SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(this){
            final /* synthetic */ GithubPullRequestsListComponent this$0;

            public final void actionPerformed(ActionEvent it) {
                this.this$0.refresh();
            }
            {
                this.this$0 = githubPullRequestsListComponent;
            }
        });
        if (!this.list.isEmpty()) {
            String errorText = "<html><body>" + prefix + "<br/>" + this.getLoadingErrorText(error, "<br/>") + "<a href=''>Retry</a></body></html>";
            HtmlErrorPanel.setError$default(this.errorPanel, errorText, null, (Function1)new Function1<HyperlinkEvent, Unit>(this){
                final /* synthetic */ GithubPullRequestsListComponent this$0;

                public final void invoke(@NotNull HyperlinkEvent it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    this.this$0.refresh();
                }
                {
                    this.this$0 = githubPullRequestsListComponent;
                    super(1);
                }
            }, 2, null);
        }
    }

    private final String getLoadingErrorText(Throwable error, String newLineSeparator) {
        String string;
        String it;
        if (error instanceof GithubStatusCodeException && ((GithubStatusCodeException)error).getError() != null) {
            GithubErrorMessage githubError;
            GithubErrorMessage githubErrorMessage = ((GithubStatusCodeException)error).getError();
            if (githubErrorMessage == null) {
                Intrinsics.throwNpe();
            }
            GithubErrorMessage githubErrorMessage2 = githubError = githubErrorMessage;
            Intrinsics.checkExpressionValueIsNotNull((Object)githubErrorMessage2, (String)"githubError");
            StringBuilder builder = new StringBuilder(githubErrorMessage2.getMessage());
            List<GithubErrorMessage.Error> list2 = githubError.getErrors();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"githubError.errors");
            Collection collection = list2;
            if (!collection.isEmpty()) {
                builder.append(": ").append(newLineSeparator);
                Iterator<GithubErrorMessage.Error> iterator = githubError.getErrors().iterator();
                while (iterator.hasNext()) {
                    GithubErrorMessage.Error e;
                    GithubErrorMessage.Error error2 = e = iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)error2, (String)"e");
                    String string2 = error2.getMessage();
                    if (string2 == null) {
                        string2 = e.getCode() + " error in " + e.getResource() + " field " + e.getField();
                    }
                    builder.append(string2).append(newLineSeparator);
                }
            }
            String string3 = builder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"builder.toString()");
            return string3;
        }
        String string4 = error.getMessage();
        if (string4 == null || (string4 = this.addDotIfNeeded(it = (string = string4))) == null) {
            string4 = "Unknown loading error.";
        }
        return string4;
    }

    static /* synthetic */ String getLoadingErrorText$default(GithubPullRequestsListComponent githubPullRequestsListComponent, Throwable throwable, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "\n";
        }
        return githubPullRequestsListComponent.getLoadingErrorText(throwable, string);
    }

    private final String addDotIfNeeded(String line) {
        return StringsKt.endsWith$default((CharSequence)line, (char)'.', (boolean)false, (int)2, null) ? line : line + '.';
    }

    public void dispose() {
        this.isDisposed = true;
    }

    public GithubPullRequestsListComponent(@NotNull Project project, @NotNull CopyPasteManager copyPasteManager, @NotNull ActionManager actionManager, @NotNull AutoPopupController autoPopupController, @NotNull GithubPullRequestsLoader loader, @NotNull CachingGithubAvatarIconsProvider.Factory avatarIconsProviderFactory) {
        JScrollPane jScrollPane;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)copyPasteManager, (String)"copyPasteManager");
        Intrinsics.checkParameterIsNotNull((Object)actionManager, (String)"actionManager");
        Intrinsics.checkParameterIsNotNull((Object)autoPopupController, (String)"autoPopupController");
        Intrinsics.checkParameterIsNotNull((Object)loader, (String)"loader");
        Intrinsics.checkParameterIsNotNull((Object)avatarIconsProviderFactory, (String)"avatarIconsProviderFactory");
        this.loader = loader;
        this.selectionModel = new GithubPullRequestsListSelectionModel();
        this.listModel = new CollectionListModel((Object[])new GithubSearchedIssue[0]);
        this.list = new GithubPullRequestsList(copyPasteManager, avatarIconsProviderFactory, (ListModel)this.listModel);
        Object object = ScrollPaneFactory.createScrollPane((Component)((Component)((Object)this.list)), (int)20, (int)31);
        GithubPullRequestsListComponent githubPullRequestsListComponent = this;
        JScrollPane $receiver = object;
        $receiver.setBorder((Border)JBUI.Borders.empty());
        JScrollBar jScrollBar = $receiver.getVerticalScrollBar();
        Intrinsics.checkExpressionValueIsNotNull((Object)jScrollBar, (String)"verticalScrollBar");
        jScrollBar.getModel().addChangeListener(new ChangeListener(this){
            final /* synthetic */ GithubPullRequestsListComponent this$0;
            {
                this.this$0 = githubPullRequestsListComponent;
            }

            public final void stateChanged(ChangeEvent it) {
                GithubPullRequestsListComponent.access$potentiallyLoadMore(this.this$0);
            }
        });
        githubPullRequestsListComponent.scrollPane = jScrollPane = object;
        this.loadOnScrollThreshold = true;
        this.errorPanel = new HtmlErrorPanel();
        this.progressStripe = new ProgressStripe((JComponent)this.scrollPane, (Disposable)this, 300);
        this.progressIndicator = new ProgressStripeProgressIndicator(this.progressStripe, true);
        this.searchModel = new GithubPullRequestSearchModel();
        object = new GithubPullRequestSearchComponent(project, autoPopupController, this.searchModel);
        githubPullRequestsListComponent = this;
        $receiver = object;
        $receiver.setBorder(IdeBorderFactory.createBorder((int)8));
        jScrollPane = object;
        githubPullRequestsListComponent.search = jScrollPane;
        this.searchModel.addListener(new GithubPullRequestSearchModel.StateListener(){

            @Override
            public void queryChanged() {
                loader.setSearchQuery(searchModel.getQuery());
                this.refresh();
            }
        }, this);
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public final void valueChanged(@NotNull ListSelectionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                if (!e.getValueIsAdjusting()) {
                    if (list.getSelectedIndex() < 0) {
                        this.getSelectionModel().setCurrent(null);
                    } else {
                        this.getSelectionModel().setCurrent((GithubSearchedIssue)listModel.getElementAt(list.getSelectedIndex()));
                    }
                }
            }
        });
        PopupHandler popupHandler2 = new PopupHandler(this, actionManager){
            final /* synthetic */ GithubPullRequestsListComponent this$0;
            final /* synthetic */ ActionManager $actionManager;

            public void invokePopup(@NotNull Component comp, int x, int y) {
                Intrinsics.checkParameterIsNotNull((Object)comp, (String)"comp");
                if (ListUtil.isPointOnSelection((JList)((JList)((Object)GithubPullRequestsListComponent.access$getList$p(this.this$0))), (int)x, (int)y)) {
                    AnAction anAction = this.$actionManager.getAction("Github.PullRequest.ToolWindow.List.Popup");
                    if (anAction == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
                    }
                    ActionPopupMenu popupMenu = this.$actionManager.createActionPopupMenu("GithubPullRequestListPopup", (ActionGroup)anAction);
                    popupMenu.setTargetComponent((JComponent)((Object)this.this$0));
                    ActionPopupMenu actionPopupMenu = popupMenu;
                    Intrinsics.checkExpressionValueIsNotNull((Object)actionPopupMenu, (String)"popupMenu");
                    actionPopupMenu.getComponent().show(comp, x, y);
                }
            }
            {
                this.this$0 = $outer;
                this.$actionManager = $captured_local_variable$1;
            }
        };
        this.list.addMouseListener((MouseListener)popupHandler2);
        BorderLayoutPanel tableWithError = JBUI.Panels.simplePanel((Component)((Component)this.progressStripe)).addToTop((Component)((Object)this.errorPanel));
        this.addToTop((Component)((Object)this.search));
        this.addToCenter((Component)tableWithError);
        this.resetSearch();
        Disposer.register((Disposable)this, (Disposable)this.list);
    }

    public static final /* synthetic */ void access$loadingErrorOccurred(GithubPullRequestsListComponent $this, @NotNull Throwable error) {
        $this.loadingErrorOccurred(error);
    }

    public static final /* synthetic */ void access$moreDataLoaded(GithubPullRequestsListComponent $this, @NotNull List data, boolean hasNext) {
        $this.moreDataLoaded(data, hasNext);
    }

    public static final /* synthetic */ void access$resetSearch(GithubPullRequestsListComponent $this) {
        $this.resetSearch();
    }

    public static final /* synthetic */ void access$potentiallyLoadMore(GithubPullRequestsListComponent $this) {
        $this.potentiallyLoadMore();
    }
}

