/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GithubIssueLabel;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/util/GithubUIUtil;", "", "()V", "computeForeground", "Ljava/awt/Color;", "kotlin.jvm.PlatformType", "bg", "createIssueLabelLabel", "Lcom/intellij/ui/components/JBLabel;", "label", "Lorg/jetbrains/plugins/github/api/data/GithubIssueLabel;", "List", "intellij.vcs.github"})
public final class GithubUIUtil {
    public static final GithubUIUtil INSTANCE;

    @NotNull
    public final JBLabel createIssueLabelLabel(@NotNull GithubIssueLabel label) {
        JBLabel jBLabel;
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        JBLabel $receiver = jBLabel = new JBLabel(' ' + label.getName() + ' ', UIUtil.ComponentStyle.MINI);
        Color apiColor = ColorUtil.fromHex((String)label.getColor());
        $receiver.setBackground((Color)new JBColor(apiColor, ColorUtil.darker((Color)apiColor, (int)3)));
        Color color = $receiver.getBackground();
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"background");
        $receiver.setForeground(INSTANCE.computeForeground(color));
        JBLabel jBLabel2 = jBLabel.andOpaque();
        Intrinsics.checkExpressionValueIsNotNull((Object)jBLabel2, (String)"JBLabel(\" ${label.name} \u2026ckground)\n  }.andOpaque()");
        return jBLabel2;
    }

    private final Color computeForeground(Color bg) {
        return ColorUtil.isDark((Color)bg) ? Color.white : Color.black;
    }

    private GithubUIUtil() {
    }

    static {
        GithubUIUtil githubUIUtil;
        INSTANCE = githubUIUtil = new GithubUIUtil();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/plugins/github/util/GithubUIUtil$List;", "", "()V", "WithTallRow", "intellij.vcs.github"})
    public static final class List {
        public static final List INSTANCE;

        private List() {
        }

        static {
            List list2;
            INSTANCE = list2 = new List();
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\f\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\r\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/util/GithubUIUtil$List$WithTallRow;", "", "()V", "selectionBackground", "Lcom/intellij/ui/JBColor;", "unfocusedSelectionBackground", "background", "Ljava/awt/Color;", "list", "Ljavax/swing/JList;", "isSelected", "", "foreground", "secondaryForeground", "intellij.vcs.github"})
        public static final class WithTallRow {
            private static final JBColor selectionBackground;
            private static final JBColor unfocusedSelectionBackground;
            public static final WithTallRow INSTANCE;

            @NotNull
            public final Color foreground(@NotNull JList<?> list2, boolean isSelected) {
                Color color;
                Intrinsics.checkParameterIsNotNull(list2, (String)"list");
                Color color2 = UIUtil.getListForeground();
                if (isSelected) {
                    JBColor jBColor = list2.hasFocus() ? JBColor.namedColor((String)"Github.List.tallRow.selectionForeground", (Color)color2) : JBColor.namedColor((String)"Github.List.tallRow.selectionForeground.unfocused", (Color)color2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)jBColor, (String)"if (list.hasFocus()) JBC\u2026ound.unfocused\", default)");
                    color = (Color)jBColor;
                } else {
                    JBColor jBColor = JBColor.namedColor((String)"Github.List.tallRow.foreground", (Color)color2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)jBColor, (String)"JBColor.namedColor(\"Gith\u2026Row.foreground\", default)");
                    color = (Color)jBColor;
                }
                return color;
            }

            @NotNull
            public final Color secondaryForeground(@NotNull JList<?> list2, boolean isSelected) {
                Color color;
                Intrinsics.checkParameterIsNotNull(list2, (String)"list");
                if (isSelected) {
                    color = this.foreground(list2, true);
                } else {
                    JBColor jBColor = JBColor.namedColor((String)"Github.List.tallRow.secondary.foreground", (Color)UIUtil.getContextHelpForeground());
                    Intrinsics.checkExpressionValueIsNotNull((Object)jBColor, (String)"JBColor.namedColor(\"Gith\u2026tContextHelpForeground())");
                    color = (Color)jBColor;
                }
                return color;
            }

            @NotNull
            public final Color background(@NotNull JList<?> list2, boolean isSelected) {
                Color color;
                Intrinsics.checkParameterIsNotNull(list2, (String)"list");
                if (isSelected) {
                    JBColor jBColor = list2.hasFocus() ? JBColor.namedColor((String)"Github.List.tallRow.selectionBackground", (Color)((Color)selectionBackground)) : JBColor.namedColor((String)"Github.List.tallRow.selectionBackground.unfocused", (Color)((Color)unfocusedSelectionBackground));
                    Intrinsics.checkExpressionValueIsNotNull((Object)jBColor, (String)"if (list.hasFocus()) JBC\u2026cusedSelectionBackground)");
                    color = (Color)jBColor;
                } else {
                    Color color2 = list2.getBackground();
                    color = color2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)color2, (String)"list.background");
                }
                return color;
            }

            private WithTallRow() {
            }

            static {
                WithTallRow withTallRow;
                INSTANCE = withTallRow = new WithTallRow();
                selectionBackground = new JBColor(15331061, 4606541);
                unfocusedSelectionBackground = new JBColor(0xF5F5F5, 4606541);
            }
        }
    }
}

