/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.util.ScriptFileUtil;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.javascript.debugger.execution.DebuggableProcessRunConfiguration;
import com.intellij.javascript.debugger.execution.DebuggableProcessRunConfigurationBase;
import com.intellij.javascript.nodejs.execution.NodeRunConfigurationLocationFilterKt;
import com.intellij.javascript.testFramework.PreferableRunConfiguration;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThreeState;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import com.jetbrains.nodejs.run.NodeJsRunConfigurationType;
import com.jetbrains.nodejs.run.RcProducerManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000bH\u0016J \u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J&\u0010\u0017\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0014J\u0018\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005*\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/nodejs/run/NodeJsRunConfigurationProducer;", "Lcom/intellij/execution/actions/RunConfigurationProducer;", "Lcom/jetbrains/nodejs/run/NodeJsRunConfiguration;", "()V", "isAcceptable", "", "Lcom/intellij/execution/actions/ConfigurationContext;", "(Lcom/intellij/execution/actions/ConfigurationContext;)Z", "configureBeforeRun", "", "configuration", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "context", "isConfigurationFromContext", "isDefaultWorkingDirEmpty", "project", "Lcom/intellij/openapi/project/Project;", "isPreferredConfiguration", "self", "other", "onFirstRun", "startRunnable", "Ljava/lang/Runnable;", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "shouldReplace", "intellij.nodeJS"})
final class NodeJsRunConfigurationProducer
extends RunConfigurationProducer<NodeJsRunConfiguration> {
    private final boolean isAcceptable(@Nullable ConfigurationContext $receiver) {
        ConfigurationContext configurationContext = $receiver;
        RunConfiguration original = configurationContext != null ? configurationContext.getOriginalConfiguration(null) : null;
        return original == null || original instanceof NodeJsRunConfiguration;
    }

    protected boolean setupConfigurationFromContext(@NotNull NodeJsRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        FileType fileType;
        Project project;
        Intrinsics.checkParameterIsNotNull((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(sourceElement, (String)"sourceElement");
        if (!this.isAcceptable(context)) {
            return false;
        }
        PsiElement psiElement = (PsiElement)sourceElement.get();
        if (psiElement == null || (psiElement = psiElement.getContainingFile()) == null) {
            return false;
        }
        PsiElement psiFile = psiElement;
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        Project project2 = project = psiFile.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        if (ProjectKt.isDirectoryBased((Project)project2)) {
            Project $receiver$iv = project;
            Object object = ServiceManager.getService((Project)$receiver$iv, RcProducerManager.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(this, T::class.java)");
            if (((RcProducerManager)((Object)object)).setupConfigurationFromContext(virtualFile2, configuration, (PsiFile)psiFile, sourceElement, context) == ThreeState.YES) {
                return true;
            }
        }
        Language language = psiFile.getLanguage();
        Intrinsics.checkExpressionValueIsNotNull((Object)language, (String)"psiFile.language");
        LanguageFileType languageFileType = language.getAssociatedFileType();
        if (languageFileType != null) {
            fileType = (FileType)languageFileType;
        } else {
            FileType fileType2 = virtualFile2.getFileType();
            fileType = fileType2;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileType2, (String)"virtualFile.fileType");
        }
        if (NodeRunConfigurationLocationFilterKt.findNodeRunConfigurationLocationFilter((FileType)fileType) == null) {
            return false;
        }
        sourceElement.set((Object)psiFile);
        VirtualFile dir = virtualFile2.getParent();
        if (dir != null && dir.isInLocalFileSystem() && this.isDefaultWorkingDirEmpty(project) && ScratchFileService.getInstance().getRootType(virtualFile2) == null) {
            configuration.setWorkingDirectory(dir.getPath());
            configuration.setInputPath(virtualFile2.getName());
        } else {
            VirtualFile workingDir;
            configuration.setInputPath(ScriptFileUtil.getScriptFilePath((VirtualFile)virtualFile2));
            VirtualFile virtualFile3 = project.getBaseDir();
            if (virtualFile3 == null) {
                virtualFile3 = virtualFile2.getParent();
            }
            VirtualFile virtualFile4 = workingDir = virtualFile3;
            configuration.setWorkingDirectory(virtualFile4 != null ? virtualFile4.getPath() : null);
        }
        configuration.addCoffeeScriptNodeOptionIfNeeded();
        configuration.setGeneratedName();
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull NodeJsRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Location location;
        Intrinsics.checkParameterIsNotNull((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!this.isAcceptable(context)) {
            return false;
        }
        Location location2 = context.getLocation();
        if (location2 == null) {
            return false;
        }
        Location location3 = location = location2;
        Intrinsics.checkExpressionValueIsNotNull((Object)location3, (String)"location");
        VirtualFile virtualFile = location3.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file = virtualFile;
        Project project = location.getProject();
        VirtualFile virtualFile2 = file;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file");
        if (virtualFile2.isInLocalFileSystem()) {
            Project project2 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            if (ProjectKt.isDirectoryBased((Project)project2)) {
                Project $receiver$iv = project;
                Object object = ServiceManager.getService((Project)$receiver$iv, RcProducerManager.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(this, T::class.java)");
                ThreeState result = ((RcProducerManager)((Object)object)).isConfigurationFromContext(file, configuration, (Location<PsiElement>)location);
                if (result != ThreeState.UNSURE) {
                    return result.toBoolean();
                }
            }
        }
        return Intrinsics.areEqual((Object)ScriptFileUtil.getScriptFilePath((VirtualFile)file), (Object)configuration.getInputPath()) || Intrinsics.areEqual((Object)file, (Object)DebuggableProcessRunConfigurationBase.findInputVirtualFile((DebuggableProcessRunConfiguration)configuration));
    }

    public boolean isPreferredConfiguration(@NotNull ConfigurationFromContext self, @Nullable ConfigurationFromContext other) {
        Intrinsics.checkParameterIsNotNull((Object)self, (String)"self");
        PsiElement psiElement = self.getSourceElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"self.sourceElement");
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile != null && other != null) {
            PreferableRunConfiguration otherRc;
            RunConfiguration runConfiguration = other.getConfiguration();
            if (!(runConfiguration instanceof PreferableRunConfiguration)) {
                runConfiguration = null;
            }
            if ((otherRc = (PreferableRunConfiguration)runConfiguration) != null && otherRc.isPreferredOver(self.getConfiguration(), (PsiElement)psiFile)) {
                return this.shouldReplace(self, other);
            }
        }
        return psiFile != null && NodeModuleUtil.isModuleFile((PsiFile)psiFile);
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        Project project;
        PsiFile psiFile;
        Intrinsics.checkParameterIsNotNull((Object)self, (String)"self");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        if (other.getConfiguration() instanceof NodeJsRunConfiguration) {
            return false;
        }
        PsiElement psiElement = self.getSourceElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"self.sourceElement");
        PsiFile psiFile2 = psiFile = psiElement.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"psiFile");
        VirtualFile virtualFile = psiFile2.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file = virtualFile;
        Project project2 = project = psiFile.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        Project $receiver$iv = project2;
        Object object = ServiceManager.getService((Project)$receiver$iv, RcProducerManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(this, T::class.java)");
        RunConfiguration runConfiguration = self.getConfiguration();
        if (runConfiguration == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.nodejs.run.NodeJsRunConfiguration");
        }
        return ((RcProducerManager)((Object)object)).isConfigurationFromContext(file, (NodeJsRunConfiguration)runConfiguration, (Location<PsiElement>)((Location)new PsiLocation(self.getSourceElement()))) == ThreeState.YES;
    }

    public void onFirstRun(@NotNull ConfigurationFromContext configuration, @NotNull ConfigurationContext context, @NotNull Runnable startRunnable) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)startRunnable, (String)"startRunnable");
        this.configureBeforeRun(configuration, context);
        super.onFirstRun(configuration, context, startRunnable);
    }

    private final void configureBeforeRun(ConfigurationFromContext configuration, ConfigurationContext context) {
        Location location;
        Location location2 = context.getLocation();
        if (location2 == null) {
            return;
        }
        Location location3 = location = location2;
        Intrinsics.checkExpressionValueIsNotNull((Object)location3, (String)"location");
        VirtualFile virtualFile = location3.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        Project project = location.getProject();
        VirtualFile virtualFile2 = file;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file");
        if (virtualFile2.isInLocalFileSystem()) {
            Project project2 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            if (ProjectKt.isDirectoryBased((Project)project2)) {
                Project $receiver$iv = project;
                Object object = ServiceManager.getService((Project)$receiver$iv, RcProducerManager.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(this, T::class.java)");
                ((RcProducerManager)((Object)object)).configureBeforeFirstRun(file, configuration, context);
            }
        }
    }

    private final boolean isDefaultWorkingDirEmpty(Project project) {
        NodeJsRunConfiguration defaultConfiguration = NodeJsRunConfiguration.getDefaultRunConfiguration(project);
        return defaultConfiguration != null && StringUtil.isEmpty((String)defaultConfiguration.getWorkingDirectory());
    }

    public NodeJsRunConfigurationProducer() {
        super(NodeJsRunConfigurationType.class);
    }
}

