/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.calculation;

import com.jetbrains.nodejs.run.profile.heap.io.IntArraySerializer;
import com.jetbrains.nodejs.run.profile.heap.io.LongArraySerializer;
import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class TimeDistribution {
    public static final DistributionParameters STANDARD = new DistributionParameters(2L, 8);
    private final DistributionParameters myParameters;
    private final long[] myEndTimes;
    private final int[] myCounters;
    private final long[] mySampleStartTs;
    private int myOutOfScaleCounter;
    private long myMaxStartTs;
    private long myMax;

    public TimeDistribution() {
        this(STANDARD);
    }

    public TimeDistribution(DistributionParameters parameters) {
        this.myParameters = parameters;
        this.myCounters = new int[this.myParameters.getScaleSize()];
        this.mySampleStartTs = new long[this.myParameters.getScaleSize()];
        for (int i = 0; i < this.myParameters.getScaleSize(); ++i) {
            this.myCounters[i] = 0;
            this.mySampleStartTs[i] = -1L;
        }
        this.myEndTimes = new long[this.myParameters.getScaleSize()];
        this.fillEndTimes();
        this.myOutOfScaleCounter = 0;
        this.myMaxStartTs = -1L;
        this.myMax = 0L;
    }

    private void fillEndTimes() {
        long end = this.myParameters.getUnit() * 1000L;
        for (int i = 0; i < this.myParameters.getScaleSize(); ++i) {
            this.myEndTimes[i] = end;
            end *= 2L;
        }
    }

    public boolean isEmpty() {
        return this.myMaxStartTs == -1L;
    }

    public long[] getEndTimes() {
        return this.myEndTimes;
    }

    public int[] getCounters() {
        return this.myCounters;
    }

    public long[] getSampleStartTs() {
        return this.mySampleStartTs;
    }

    public int getOutOfScaleCounter() {
        return this.myOutOfScaleCounter;
    }

    public long getMaxStartTs() {
        return this.myMaxStartTs;
    }

    public long getMax() {
        return this.myMax;
    }

    public int getTypicalIndex() {
        int max = 0;
        int maxIdx = -1;
        for (int i = 0; i < this.myCounters.length; ++i) {
            int counter = this.myCounters[i];
            if (counter <= max) continue;
            max = counter;
            maxIdx = i;
        }
        return maxIdx;
    }

    private TimeDistribution(DistributionParameters parameters, int[] counters, long[] sampleStartTs, int outOfScaleCounter, long maxStartTs, long max) {
        this.myParameters = parameters;
        this.myEndTimes = new long[this.myParameters.getScaleSize()];
        this.fillEndTimes();
        this.myCounters = counters;
        this.mySampleStartTs = sampleStartTs;
        this.myOutOfScaleCounter = outOfScaleCounter;
        this.myMaxStartTs = maxStartTs;
        this.myMax = max;
    }

    public void register(long startTs, long duration) {
        int idx;
        int updateIdx;
        if (duration > this.myMax) {
            this.myMaxStartTs = startTs;
            this.myMax = duration;
        }
        int n = updateIdx = (idx = Arrays.binarySearch(this.myEndTimes, duration)) >= 0 ? idx : -1 - idx;
        if (updateIdx == this.myParameters.getScaleSize()) {
            ++this.myOutOfScaleCounter;
        } else {
            int n2 = updateIdx;
            this.myCounters[n2] = this.myCounters[n2] + 1;
            if (this.mySampleStartTs[updateIdx] == -1L) {
                this.mySampleStartTs[updateIdx] = startTs;
            }
        }
    }

    public static RawSerializer<TimeDistribution> getSerializer(final @NotNull DistributionParameters parameters) {
        if (parameters == null) {
            TimeDistribution.$$$reportNull$$$0(0);
        }
        final int size = parameters.getScaleSize();
        final LongArraySerializer longArraySerializer = new LongArraySerializer(size);
        final IntArraySerializer intArraySerializer = new IntArraySerializer(size);
        return new RawSerializer<TimeDistribution>(){

            @Override
            public long getRecordSize() {
                return size * 12 + 4 + 16;
            }

            @Override
            public void write(@NotNull DataOutput os, @NotNull TimeDistribution distribution) throws IOException {
                if (os == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (distribution == null) {
                    1.$$$reportNull$$$0(1);
                }
                longArraySerializer.write(os, distribution.mySampleStartTs);
                intArraySerializer.write(os, distribution.myCounters);
                RawSerializer.Helper.serializeInt(distribution.myOutOfScaleCounter, os);
                RawSerializer.Helper.serializeLong(distribution.myMaxStartTs, os);
                RawSerializer.Helper.serializeLong(distribution.myMax, os);
            }

            @Override
            public TimeDistribution read(@NotNull DataInput is) throws IOException {
                if (is == null) {
                    1.$$$reportNull$$$0(2);
                }
                long[] sampleStartTs = longArraySerializer.read(is);
                int[] counters = intArraySerializer.read(is);
                int outOfScale = RawSerializer.Helper.deserializeInt(is);
                long maxStartTs = RawSerializer.Helper.deserializeLong(is);
                long max = RawSerializer.Helper.deserializeLong(is);
                return new TimeDistribution(parameters, counters, sampleStartTs, outOfScale, maxStartTs, max);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "os";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "distribution";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "is";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/TimeDistribution$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "write";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/TimeDistribution", "getSerializer"));
    }

    public static class DistributionParameters {
        private final long myUnit;
        private final int myScaleSize;

        public DistributionParameters(long unit, int scaleSize) {
            this.myUnit = unit;
            this.myScaleSize = scaleSize;
        }

        public long getUnit() {
            return this.myUnit;
        }

        public int getScaleSize() {
            return this.myScaleSize;
        }
    }
}

