/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.auth.oauth;

import com.microsoft.alm.auth.PromptBehavior;
import com.microsoft.alm.auth.oauth.AzureDeviceFlow;
import com.microsoft.alm.auth.oauth.DeviceFlowResponse;
import com.microsoft.alm.auth.oauth.Global;
import com.microsoft.alm.auth.oauth.UserIdentifier;
import com.microsoft.alm.auth.oauth.UserIdentifierType;
import com.microsoft.alm.helpers.Action;
import com.microsoft.alm.helpers.Debug;
import com.microsoft.alm.helpers.Guid;
import com.microsoft.alm.helpers.HttpClient;
import com.microsoft.alm.helpers.ObjectExtensions;
import com.microsoft.alm.helpers.QueryString;
import com.microsoft.alm.helpers.StringContent;
import com.microsoft.alm.helpers.StringHelper;
import com.microsoft.alm.helpers.UriHelper;
import com.microsoft.alm.oauth2.useragent.AuthorizationException;
import com.microsoft.alm.oauth2.useragent.AuthorizationResponse;
import com.microsoft.alm.oauth2.useragent.UserAgent;
import com.microsoft.alm.oauth2.useragent.UserAgentImpl;
import com.microsoft.alm.secret.Token;
import com.microsoft.alm.secret.TokenPair;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureAuthority {
    private static final Logger logger = LoggerFactory.getLogger(AzureAuthority.class);
    public static final String AuthorityHostUrlBase = "https://login.microsoftonline.com";
    public static final String CommonTenant = "common";
    public static final String DefaultAuthorityHostUrl = "https://login.microsoftonline.com/common";
    public static final AzureAuthority DefaultAzureAuthority = new AzureAuthority();
    private static final String VSTS_BASE_DOMAIN = "visualstudio.com";
    private static final String VSTS_RESOURCE_TENANT_HEADER = "X-VSS-ResourceTenant";
    private final UserAgent userAgent;
    private final AzureDeviceFlow azureDeviceFlow;
    private String authorityHostUrl;

    public AzureAuthority() {
        this(DefaultAuthorityHostUrl);
    }

    public AzureAuthority(String authorityHostUrl) {
        this(authorityHostUrl, (UserAgent)new UserAgentImpl(), new AzureDeviceFlow());
    }

    AzureAuthority(String authorityHostUrl, UserAgent userAgent, AzureDeviceFlow azureDeviceFlow) {
        Debug.Assert((boolean)UriHelper.isWellFormedUriString((String)authorityHostUrl), (String)"The authorityHostUrl parameter is invalid.");
        Debug.Assert((userAgent != null ? 1 : 0) != 0, (String)"The userAgent parameter is null.");
        this.authorityHostUrl = authorityHostUrl;
        this.userAgent = userAgent;
        this.azureDeviceFlow = azureDeviceFlow;
    }

    static URI createAuthorizationEndpointUri(String authorityHostUrl, String resource, String clientId, URI redirectUri, UserIdentifier userId, String state, PromptBehavior promptBehavior, String queryParameters) {
        URI result;
        QueryString qs = new QueryString();
        qs.put((Object)"resource", (Object)resource);
        qs.put((Object)"client_id", (Object)clientId);
        qs.put((Object)"response_type", (Object)"code");
        qs.put((Object)"redirect_uri", (Object)redirectUri.toString());
        if (!(userId.isAnyUser() || userId.getType() != UserIdentifierType.OPTIONAL_DISPLAYABLE_ID && userId.getType() != UserIdentifierType.REQUIRED_DISPLAYABLE_ID)) {
            qs.put((Object)"login_hint", (Object)userId.getId());
        }
        if (state != null) {
            qs.put((Object)"state", (Object)state);
        }
        String promptValue = null;
        switch (promptBehavior) {
            case ALWAYS: {
                promptValue = "login";
                break;
            }
            case NEVER: {
                promptValue = "attempt_none";
            }
        }
        if (promptValue != null) {
            qs.put((Object)"prompt", (Object)promptValue);
        }
        StringBuilder sb = new StringBuilder(authorityHostUrl);
        sb.append("/oauth2/authorize?");
        sb.append(qs.toString());
        if (!StringHelper.isNullOrWhiteSpace((String)queryParameters)) {
            int start = queryParameters.charAt(0) == '&' ? 1 : 0;
            sb.append('&').append(queryParameters, start, queryParameters.length());
        }
        try {
            result = new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new Error(e);
        }
        return result;
    }

    static URI createTokenEndpointUri(String authorityHostUrl) {
        URI result;
        StringBuilder sb = new StringBuilder(authorityHostUrl);
        sb.append("/oauth2/token");
        try {
            result = new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new Error(e);
        }
        return result;
    }

    static StringContent createTokenRequest(String resource, String clientId, String authorizationCode, URI redirectUri, UUID correlationId) {
        QueryString qs = new QueryString();
        qs.put((Object)"resource", (Object)resource);
        qs.put((Object)"client_id", (Object)clientId);
        qs.put((Object)"grant_type", (Object)"authorization_code");
        qs.put((Object)"code", (Object)authorizationCode);
        qs.put((Object)"redirect_uri", (Object)redirectUri.toString());
        if (correlationId != null && !Guid.Empty.equals(correlationId)) {
            qs.put((Object)"client-request-id", (Object)correlationId.toString());
            qs.put((Object)"return-client-request-id", (Object)"true");
        }
        StringContent result = StringContent.createUrlEncoded((QueryString)qs);
        return result;
    }

    static StringContent createTokenRequestByRefreshToken(String resource, String clientId, Token refreshToken) {
        QueryString qs = new QueryString();
        qs.put((Object)"resource", (Object)resource);
        qs.put((Object)"client_id", (Object)clientId);
        qs.put((Object)"grant_type", (Object)"refresh_token");
        qs.put((Object)"refresh_token", (Object)refreshToken.Value);
        StringContent result = StringContent.createUrlEncoded((QueryString)qs);
        return result;
    }

    public static UUID detectTenantId(URI targetUri) throws IOException {
        HttpClient client;
        String tenant;
        AtomicReference<UUID> tenantId = new AtomicReference<UUID>(Guid.Empty);
        if ((StringHelper.endsWithIgnoreCase((String)targetUri.getHost(), (String)VSTS_BASE_DOMAIN) || UriHelper.isAzureHost((URI)targetUri)) && !StringHelper.isNullOrWhiteSpace((String)(tenant = (client = Global.getHttpClientFactory().createHttpClient()).getHeaderField(targetUri, VSTS_RESOURCE_TENANT_HEADER))) && Guid.tryParse((String)tenant, tenantId) && !Guid.Empty.equals(tenantId.get())) {
            return tenantId.get();
        }
        return null;
    }

    private TokenPair doAcquireToken(URI tokenEndpoint, StringContent requestContent) throws IOException {
        HttpClient client = Global.getHttpClientFactory().createHttpClient();
        String responseContent = client.getPostResponseText(tokenEndpoint, requestContent);
        TokenPair tokenPair = new TokenPair(responseContent);
        return tokenPair;
    }

    public TokenPair acquireToken(String clientId, String resource, URI redirectUri, String queryParameters) throws AuthorizationException {
        Debug.Assert((!StringHelper.isNullOrWhiteSpace((String)clientId) ? 1 : 0) != 0, (String)"The clientId parameter is null or empty");
        Debug.Assert((!StringHelper.isNullOrWhiteSpace((String)resource) ? 1 : 0) != 0, (String)"The resource parameter is null or empty");
        Debug.Assert((redirectUri != null ? 1 : 0) != 0, (String)"The redirectUri parameter is null");
        Debug.Assert((boolean)redirectUri.isAbsolute(), (String)"The redirectUri parameter is not an absolute Uri");
        logger.debug("AzureAuthority::acquireToken");
        UUID correlationId = null;
        TokenPair tokens = null;
        queryParameters = (String)ObjectExtensions.coalesce((Object)queryParameters, (Object)"");
        String authorizationCode = this.acquireAuthorizationCode(resource, clientId, redirectUri, queryParameters);
        if (authorizationCode == null) {
            logger.debug("   token acquisition failed.");
            return tokens;
        }
        try {
            URI tokenEndpoint = AzureAuthority.createTokenEndpointUri(this.authorityHostUrl);
            StringContent requestContent = AzureAuthority.createTokenRequest(resource, clientId, authorizationCode, redirectUri, correlationId);
            tokens = this.doAcquireToken(tokenEndpoint, requestContent);
            logger.debug("   token acquisition succeeded.");
        }
        catch (IOException e) {
            logger.debug("   token acquisition failed.");
            logger.debug("   IOException: {}", (Throwable)e);
        }
        return tokens;
    }

    public TokenPair acquireTokenByRefreshToken(String clientId, String resource, Token refreshToken) {
        Debug.Assert((!StringHelper.isNullOrWhiteSpace((String)clientId) ? 1 : 0) != 0, (String)"The clientId parameter is null or empty");
        Debug.Assert((!StringHelper.isNullOrWhiteSpace((String)resource) ? 1 : 0) != 0, (String)"The resource parameter is null or empty");
        Debug.Assert((refreshToken != null ? 1 : 0) != 0, (String)"The refreshToken parameter is null");
        logger.debug("AzureAuthority::acquireTokenByRefreshToken");
        URI tokenEndpoint = AzureAuthority.createTokenEndpointUri(this.authorityHostUrl);
        StringContent requestContent = AzureAuthority.createTokenRequestByRefreshToken(resource, clientId, refreshToken);
        try {
            TokenPair tokenPair = this.doAcquireToken(tokenEndpoint, requestContent);
            return tokenPair;
        }
        catch (IOException e) {
            logger.debug("   token acquisition failed.");
            logger.debug("   IOException: {}", (Throwable)e);
            return null;
        }
    }

    public TokenPair acquireToken(String clientId, String resource, URI redirectUri, Action<DeviceFlowResponse> callback) throws AuthorizationException {
        Debug.Assert((!StringHelper.isNullOrWhiteSpace((String)clientId) ? 1 : 0) != 0, (String)"The clientId parameter is null or empty");
        Debug.Assert((!StringHelper.isNullOrWhiteSpace((String)resource) ? 1 : 0) != 0, (String)"The resource parameter is null or empty");
        Debug.Assert((redirectUri != null ? 1 : 0) != 0, (String)"The redirectUri parameter is null");
        Debug.Assert((callback != null ? 1 : 0) != 0, (String)"The callback parameter is null");
        logger.debug("AzureAuthority::acquireToken");
        this.azureDeviceFlow.setResource(resource);
        this.azureDeviceFlow.setRedirectUri(redirectUri.toString());
        URI deviceEndpoint = URI.create(this.authorityHostUrl + "/oauth2/devicecode");
        DeviceFlowResponse response = this.azureDeviceFlow.requestAuthorization(deviceEndpoint, clientId, null);
        callback.call((Object)response);
        URI tokenEndpoint = AzureAuthority.createTokenEndpointUri(this.authorityHostUrl);
        TokenPair tokens = this.azureDeviceFlow.requestToken(tokenEndpoint, clientId, response);
        logger.debug("   token acquisition succeeded.");
        return tokens;
    }

    private String acquireAuthorizationCode(String resource, String clientId, URI redirectUri, String queryParameters) throws AuthorizationException {
        String expectedState = UUID.randomUUID().toString();
        String authorizationCode = null;
        URI authorizationEndpoint = AzureAuthority.createAuthorizationEndpointUri(this.authorityHostUrl, resource, clientId, redirectUri, UserIdentifier.ANY_USER, expectedState, PromptBehavior.ALWAYS, queryParameters);
        AuthorizationResponse response = this.userAgent.requestAuthorizationCode(authorizationEndpoint, redirectUri);
        authorizationCode = response.getCode();
        String actualState = response.getState();
        if (!expectedState.equals(actualState)) {
            authorizationCode = null;
        }
        return authorizationCode;
    }
}

