/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.auth.pat;

import com.microsoft.alm.auth.oauth.AzureAuthority;
import com.microsoft.alm.auth.oauth.Global;
import com.microsoft.alm.helpers.Debug;
import com.microsoft.alm.helpers.Guid;
import com.microsoft.alm.helpers.HttpClient;
import com.microsoft.alm.helpers.StringContent;
import com.microsoft.alm.helpers.StringHelper;
import com.microsoft.alm.helpers.UriHelper;
import com.microsoft.alm.secret.Token;
import com.microsoft.alm.secret.TokenType;
import com.microsoft.alm.secret.VsoTokenScope;
import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VsoAzureAuthority
extends AzureAuthority {
    private static final Logger logger = LoggerFactory.getLogger(VsoAzureAuthority.class);
    public static final int RequestTimeout = 15000;
    private static final String ALL_ACCOUNTS = "all_accounts";
    private static final Pattern TOKEN_PATTERN = Pattern.compile("\"token\"\\s*:\\s*\"([^\"]+)\"", 2);
    private static final Pattern INSTANCE_ID_PATTERN = Pattern.compile("\"instanceId\"\\s*:\\s*\"([^\"]+)\"", 2);
    private static final Pattern LOCATION_PATTERN = Pattern.compile("\"location\"\\s*:\\s*\"([^\"]+)\"", 2);

    VsoAzureAuthority() {
    }

    public Token generatePersonalAccessToken(URI targetUri, Token accessToken, VsoTokenScope tokenScope, boolean requireCompactToken, boolean shouldCreateGlobalToken, String displayName) {
        Debug.Assert((targetUri != null ? 1 : 0) != 0, (String)"The targetUri parameter is null");
        Debug.Assert((accessToken != null && !StringHelper.isNullOrWhiteSpace((String)accessToken.Value) && (accessToken.Type == TokenType.Access || accessToken.Type == TokenType.Federated) ? 1 : 0) != 0, (String)"The accessToken parameter is null or invalid");
        Debug.Assert((tokenScope != null ? 1 : 0) != 0, (String)"The tokenScope parameter is invalid");
        logger.debug("VsoAzureAuthority::generatePersonalAccessToken");
        try {
            HttpClient client = Global.getHttpClientFactory().createHttpClient();
            logger.debug("   using token to acquire personal access token");
            accessToken.contributeHeader(client.getHeaders());
            if (shouldCreateGlobalToken || this.populateTokenTargetId(targetUri, accessToken)) {
                StringContent content;
                URI requestUrl = this.createPersonalAccessTokenRequestUri(client, targetUri, requireCompactToken);
                String responseText = client.getPostResponseText(requestUrl, content = this.getAccessTokenRequestBody(accessToken, tokenScope, shouldCreateGlobalToken, displayName));
                Token token = VsoAzureAuthority.parsePersonalAccessTokenFromJson(responseText);
                if (token != null) {
                    logger.debug("   personal access token acquisition succeeded.");
                }
                return token;
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
        return null;
    }

    private URI createPersonalAccessTokenRequestUri(HttpClient client, URI targetUri, boolean requireCompactToken) throws IOException {
        String SessionTokenUrl = "_apis/token/sessiontokens?api-version=1.0";
        String CompactTokenUrl = "_apis/token/sessiontokens?api-version=1.0&tokentype=compact";
        Debug.Assert((client != null ? 1 : 0) != 0, (String)"The client is null");
        URI identityServiceUri = this.getIdentityServiceUri(client, targetUri);
        if (identityServiceUri == null) {
            throw new RuntimeException("Failed to find Identity Service for " + targetUri.toString());
        }
        String url = identityServiceUri.toString();
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        url = url + (requireCompactToken ? "_apis/token/sessiontokens?api-version=1.0&tokentype=compact" : "_apis/token/sessiontokens?api-version=1.0");
        return URI.create(url);
    }

    private URI getIdentityServiceUri(HttpClient client, URI targetUri) throws IOException {
        String locationServiceUrlFormat = "https://%1$s/_apis/ServiceDefinitions/LocationService2/951917AC-A960-4999-8464-E3F0AA25B381?api-version=1.0";
        Debug.Assert((client != null ? 1 : 0) != 0, (String)"The client parameter is null.");
        Debug.Assert((targetUri != null && targetUri.isAbsolute() ? 1 : 0) != 0, (String)"The targetUri parameter is null or invalid");
        String host = UriHelper.getFullAccount((URI)targetUri);
        String locationServiceUrl = String.format("https://%1$s/_apis/ServiceDefinitions/LocationService2/951917AC-A960-4999-8464-E3F0AA25B381?api-version=1.0", host);
        URI identityServiceUri = null;
        String responseText = client.getGetResponseText(URI.create(locationServiceUrl));
        identityServiceUri = VsoAzureAuthority.parseLocationFromJson(responseText);
        if (identityServiceUri != null) {
            logger.debug("   parsed identity service url: {}", (Object)identityServiceUri);
        }
        return identityServiceUri;
    }

    public boolean populateTokenTargetId(URI targetUri, Token accessToken) {
        Debug.Assert((targetUri != null && targetUri.isAbsolute() ? 1 : 0) != 0, (String)"The targetUri parameter is null or invalid");
        Debug.Assert((accessToken != null && !StringHelper.isNullOrWhiteSpace((String)accessToken.Value) && (accessToken.Type == TokenType.Access || accessToken.Type == TokenType.Federated) ? 1 : 0) != 0, (String)"The accessToken parameter is null or invalid");
        logger.debug("VsoAzureAuthority::populateTokenTargetId");
        String resultId = null;
        try {
            String content = this.readConnectionDataRequest(targetUri, accessToken);
            resultId = VsoAzureAuthority.parseInstanceIdFromJson(content);
        }
        catch (IOException e) {
            logger.debug("   server returned " + e.getMessage());
        }
        AtomicReference instanceId = new AtomicReference();
        if (Guid.tryParse((String)resultId, instanceId)) {
            logger.debug("   target identity is " + resultId);
            accessToken.setTargetIdentity((UUID)instanceId.get());
            return true;
        }
        return false;
    }

    static Token parsePersonalAccessTokenFromJson(String json) {
        Matcher matcher;
        Token token = null;
        if (!StringHelper.isNullOrWhiteSpace((String)json) && (matcher = TOKEN_PATTERN.matcher(json)).find()) {
            String tokenValue = matcher.group(1);
            token = new Token(tokenValue, TokenType.Personal);
        }
        return token;
    }

    static String parseInstanceIdFromJson(String json) {
        String result = null;
        Matcher matcher = INSTANCE_ID_PATTERN.matcher(json);
        if (matcher.find()) {
            result = matcher.group(1);
        }
        return result;
    }

    static URI parseLocationFromJson(String json) {
        Matcher matcher;
        URI locationServiceUri = null;
        if (!StringHelper.isNullOrWhiteSpace((String)json) && (matcher = LOCATION_PATTERN.matcher(json)).find()) {
            String location = matcher.group(1);
            locationServiceUri = URI.create(location);
        }
        return locationServiceUri;
    }

    private StringContent getAccessTokenRequestBody(Token accessToken, VsoTokenScope tokenScope, boolean shouldCreateGlobalToken, String displayName) {
        String ContentJsonFormat = "{ \"scope\" : \"%1$s\", \"targetAccounts\" : [\"%2$s\"], \"displayName\" : \"%3$s\" }";
        Debug.Assert((accessToken != null && (accessToken.Type == TokenType.Access || accessToken.Type == TokenType.Federated) ? 1 : 0) != 0, (String)"The accessToken parameter is null or invalid");
        Debug.Assert((tokenScope != null ? 1 : 0) != 0, (String)"The tokenScope parameter is null");
        String targetIdentity = shouldCreateGlobalToken ? ALL_ACCOUNTS : accessToken.getTargetIdentity().toString();
        logger.debug("   creating access token scoped to '" + tokenScope + "' for '" + targetIdentity + "'");
        String jsonContent = String.format("{ \"scope\" : \"%1$s\", \"targetAccounts\" : [\"%2$s\"], \"displayName\" : \"%3$s\" }", tokenScope, targetIdentity, displayName);
        StringContent content = StringContent.createJson((String)jsonContent);
        return content;
    }

    private String readConnectionDataRequest(URI targetUri, Token token) throws IOException {
        Debug.Assert((targetUri != null && targetUri.isAbsolute() ? 1 : 0) != 0, (String)"The targetUri parameter is null or invalid");
        Debug.Assert((token != null && (token.Type == TokenType.Access || token.Type == TokenType.Federated) ? 1 : 0) != 0, (String)"The token parameter is null or invalid");
        logger.debug("VsoAzureAuthority::createConnectionDataRequest");
        HttpClient client = Global.getHttpClientFactory().createHttpClient();
        URI requestUri = this.createConnectionDataUri(targetUri);
        logger.debug("   validating token");
        token.contributeHeader(client.getHeaders());
        return client.getGetResponseText(requestUri, 15000);
    }

    private URI createConnectionDataUri(URI targetUri) {
        String VsoValidationUrlFormat = "https://%1$s/_apis/connectiondata";
        Debug.Assert((boolean)(targetUri != null & targetUri.isAbsolute()), (String)"The targetUri parameter is null or invalid");
        String host = UriHelper.getFullAccount((URI)targetUri);
        String validationUrl = String.format("https://%1$s/_apis/connectiondata", host);
        URI result = URI.create(validationUrl);
        return result;
    }
}

