/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.helpers;

import com.microsoft.alm.helpers.QueryString;
import com.microsoft.alm.helpers.StringHelper;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;

public class UriHelper {
    public static final String HOST_AZURE = "azure.com";
    public static final String HOST_AZURE_ORG = ".azure.com";
    private static final Pattern PAIR_SEPARATOR = Pattern.compile("&");
    private static final Pattern NAME_VALUE_SEPARATOR = Pattern.compile("=");
    public static final String UTF_8 = "UTF-8";

    public static boolean isWellFormedUriString(String uriString) {
        try {
            new URI(uriString);
            return true;
        }
        catch (URISyntaxException ignored) {
            return false;
        }
    }

    public static QueryString deserializeParameters(String s) {
        String[] pairs;
        QueryString result = new QueryString();
        if (StringHelper.isNullOrWhiteSpace(s)) {
            return result;
        }
        String trimmed = s.trim();
        for (String pair : pairs = PAIR_SEPARATOR.split(trimmed)) {
            String trimmedPair = pair.trim();
            if (trimmedPair.length() == 0) continue;
            String[] nameAndValue = NAME_VALUE_SEPARATOR.split(pair, 2);
            try {
                String name = URLDecoder.decode(nameAndValue[0], UTF_8);
                String value = nameAndValue.length == 2 ? URLDecoder.decode(nameAndValue[1], UTF_8) : null;
                result.put(name, value);
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
        }
        return result;
    }

    public static String serializeParameters(Map<String, String> parameters) {
        try {
            StringBuilder sb = new StringBuilder();
            Iterator<Map.Entry<String, String>> iterator = parameters.entrySet().iterator();
            if (iterator.hasNext()) {
                String encodedValue;
                Map.Entry<String, String> entry = iterator.next();
                String key = entry.getKey();
                String encodedKey = URLEncoder.encode(key, UTF_8);
                sb.append(encodedKey);
                String value = entry.getValue();
                if (value != null) {
                    encodedValue = URLEncoder.encode(value, UTF_8);
                    sb.append('=').append(encodedValue);
                }
                while (iterator.hasNext()) {
                    sb.append('&');
                    entry = iterator.next();
                    key = entry.getKey();
                    encodedKey = URLEncoder.encode(key, UTF_8);
                    sb.append(encodedKey);
                    value = entry.getValue();
                    if (value == null) continue;
                    encodedValue = URLEncoder.encode(value, UTF_8);
                    sb.append('=').append(encodedValue);
                }
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public static boolean isAzureHost(URI uri) {
        return uri != null && uri.getHost() != null && (uri.getHost().equalsIgnoreCase(HOST_AZURE) || StringHelper.endsWithIgnoreCase(uri.getHost(), HOST_AZURE_ORG));
    }

    public static String getFullAccount(URI uri) {
        if (UriHelper.isAzureHost(uri)) {
            String[] paths = uri.getPath().split("/");
            if (paths.length > 1) {
                return uri.getHost() + "/" + paths[1];
            }
            if (!StringHelper.isNullOrWhiteSpace(uri.getUserInfo())) {
                return uri.getHost() + "/" + uri.getUserInfo();
            }
        }
        return uri.getHost();
    }
}

