/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution;

import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceLimits {
    private static final String LIMITS = "limits";
    private final int myDepth;
    private final int myPropNum;
    private final int myStrLength;
    private final int myArrLength;

    public TraceLimits(int depth, int propNum, int arrLength, int strLength) {
        this.myDepth = depth;
        this.myPropNum = propNum;
        this.myStrLength = strLength;
        this.myArrLength = arrLength;
    }

    public int getMaxDepth() {
        return this.myDepth;
    }

    public int getMaxPropertyNumber() {
        return this.myPropNum;
    }

    public int getMaxArrayLength() {
        return this.myArrLength;
    }

    public int getMaxStringLength() {
        return this.myStrLength;
    }

    @Nullable
    public static TraceLimits readExternal(@NotNull Element element) {
        if (element == null) {
            TraceLimits.$$$reportNull$$$0(0);
        }
        return TraceLimits.deserializeTraceLimits(TraceLimits.getAttrValue(element, LIMITS));
    }

    @Nullable
    private static String getAttrValue(Element element, String attrKey) {
        Attribute attribute = element.getAttribute(attrKey);
        return attribute != null ? attribute.getValue() : null;
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            TraceLimits.$$$reportNull$$$0(1);
        }
        element.setAttribute(LIMITS, String.format("%d,%d,%d,%d", this.getMaxDepth(), this.getMaxPropertyNumber(), this.getMaxArrayLength(), this.getMaxStringLength()));
    }

    public void addToConfigJson(@NotNull Map<String, Object> config) {
        if (config == null) {
            TraceLimits.$$$reportNull$$$0(2);
        }
        config.put(LIMITS, true);
        config.put("depth", this.getMaxDepth());
        config.put("propertyNumber", this.getMaxPropertyNumber());
        config.put("arrayLength", this.getMaxArrayLength());
        config.put("stringLength", this.getMaxStringLength());
    }

    @Nullable
    private static TraceLimits deserializeTraceLimits(@Nullable String serialized) {
        if (serialized == null) {
            return null;
        }
        String[] limits = serialized.split(",");
        return new TraceLimits(Integer.parseInt(limits[0]), Integer.parseInt(limits[1]), Integer.parseInt(limits[2]), Integer.parseInt(limits[3]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/trace/execution/TraceLimits";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addToConfigJson";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

