/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.common;

import com.intellij.javascript.trace.execution.code.CodeElement;
import com.intellij.javascript.trace.execution.code.CodeRange;
import com.intellij.javascript.trace.execution.code.StaticCodeElement;
import com.intellij.javascript.trace.execution.code.StaticFuncStart;
import com.intellij.javascript.trace.execution.code.StaticFunctionParameter;
import com.intellij.javascript.trace.execution.code.StaticProgramStart;
import com.intellij.javascript.trace.execution.code.StaticReturn;
import com.intellij.javascript.trace.execution.code.StaticUnknownElement;
import com.intellij.javascript.trace.execution.common.EventMetadata;
import com.intellij.javascript.trace.execution.common.RuntimeFunctionArgument;
import com.intellij.javascript.trace.execution.common.RuntimeReturnStatement;
import com.intellij.javascript.trace.execution.common.RuntimeStatement;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;

public class RuntimeFunctionScope
implements CodeElement {
    public static final RuntimeStatement FIRST_STATEMENT = new RuntimeStatement(StaticUnknownElement.INSTANCE);
    private final EventMetadata myEventMetadata;
    private final CodeElement myCodeElement;
    private final RuntimeStatement myCaller;
    private final boolean myIsProgramScope;
    private RuntimeFunctionArgument[] myArguments = new RuntimeFunctionArgument[0];
    private final List<RuntimeStatement> myStatements = new ArrayList<RuntimeStatement>();
    private Object myExceptionValue;
    private Object myReturnValue;
    private RuntimeReturnStatement myReturnStatement;
    private final boolean myDumpCaptured;
    private boolean myHasException;
    private boolean myHasReturnValue;
    private final String myFileId;
    private final int myFuncId;
    private Double myExecutionTime;

    public RuntimeFunctionScope(EventMetadata eventMetadata, StaticFuncStart element, Object argumentsDump, RuntimeStatement caller) {
        this.myEventMetadata = eventMetadata;
        this.myCodeElement = element;
        this.myCaller = caller;
        this.myIsProgramScope = false;
        this.myDumpCaptured = this.createFuncArgs(element, argumentsDump);
        this.myFileId = element.getFileId();
        this.myFuncId = element.getFuncId();
    }

    public RuntimeFunctionScope(EventMetadata eventMetadata, StaticProgramStart element, RuntimeStatement caller) {
        this.myEventMetadata = eventMetadata;
        this.myCodeElement = element;
        this.myCaller = caller;
        this.myIsProgramScope = true;
        this.myDumpCaptured = true;
        this.myFileId = element.getFileId();
        this.myFuncId = element.getFuncId();
    }

    private Boolean createFuncArgs(StaticFuncStart funcStart, Object argumentsDump) {
        if (!(argumentsDump instanceof JSONArray)) {
            return false;
        }
        StaticFunctionParameter[] parameters = funcStart.getParameters();
        ArrayList<RuntimeFunctionArgument> functionArgs = new ArrayList<RuntimeFunctionArgument>();
        JSONArray argsJsonArray = (JSONArray)argumentsDump;
        int argsJsonArrayLength = argsJsonArray.length();
        int length = Math.max(parameters.length, argsJsonArray.length());
        if (length > 0) {
            Object[] params = new StaticFunctionParameter[length];
            ArrayUtil.copy(Arrays.asList(parameters), (Object[])params, (int)0);
            for (int i = 0; i < length; ++i) {
                functionArgs.add(new RuntimeFunctionArgument(i, (StaticFunctionParameter)params[i], i < argsJsonArrayLength ? argsJsonArray.opt(i) : "U", funcStart));
            }
        }
        this.myArguments = functionArgs.toArray(new RuntimeFunctionArgument[0]);
        return true;
    }

    @NotNull
    public EventMetadata getEventMetadata() {
        EventMetadata eventMetadata = this.myEventMetadata;
        if (eventMetadata == null) {
            RuntimeFunctionScope.$$$reportNull$$$0(0);
        }
        return eventMetadata;
    }

    @NotNull
    public Boolean isProgram() {
        Boolean bl = this.myIsProgramScope;
        if (bl == null) {
            RuntimeFunctionScope.$$$reportNull$$$0(1);
        }
        return bl;
    }

    @NotNull
    public RuntimeFunctionArgument[] getArguments() {
        if (this.myArguments == null) {
            RuntimeFunctionScope.$$$reportNull$$$0(2);
        }
        return this.myArguments;
    }

    public RuntimeStatement addStatement(StaticCodeElement element) {
        RuntimeStatement statement = new RuntimeStatement(element);
        this.myStatements.add(statement);
        return statement;
    }

    public RuntimeStatement addReturnStatement(StaticReturn element) {
        this.myReturnStatement = new RuntimeReturnStatement(element);
        this.myStatements.add(this.myReturnStatement);
        return this.myReturnStatement;
    }

    public RuntimeStatement addStatementStub(StaticUnknownElement element, int id) {
        RuntimeStatement statement = new RuntimeStatement(element, id);
        this.myStatements.add(statement);
        return statement;
    }

    @NotNull
    public RuntimeStatement[] getStatements() {
        RuntimeStatement[] runtimeStatementArray = this.myStatements.toArray(new RuntimeStatement[0]);
        if (runtimeStatementArray == null) {
            RuntimeFunctionScope.$$$reportNull$$$0(3);
        }
        return runtimeStatementArray;
    }

    public RuntimeReturnStatement getReturnStatement() {
        return this.myReturnStatement;
    }

    public void setExceptionValue(Object exceptionValue) {
        this.myExceptionValue = exceptionValue;
        this.myHasException = true;
    }

    public boolean hasException() {
        return this.myHasException;
    }

    public Object getExceptionValue() {
        return this.myExceptionValue;
    }

    public void setReturnValue(Object returnValue) {
        this.myReturnValue = returnValue;
        this.myHasReturnValue = true;
    }

    public Object getReturnValue() {
        return this.myReturnValue;
    }

    public boolean hasReturnValue() {
        return this.myHasReturnValue;
    }

    public boolean isDumpCaptured() {
        return this.myDumpCaptured;
    }

    @Override
    @NotNull
    public String getFile() {
        String string = this.myCodeElement.getFile();
        if (string == null) {
            RuntimeFunctionScope.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFunc() {
        String string = this.myCodeElement.getFunc();
        if (string == null) {
            RuntimeFunctionScope.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public CodeRange getCodeRange() {
        CodeRange codeRange = this.myCodeElement.getCodeRange();
        if (codeRange == null) {
            RuntimeFunctionScope.$$$reportNull$$$0(6);
        }
        return codeRange;
    }

    @Nullable
    public RuntimeStatement getCallerStatement(RuntimeFunctionScope parentScope) {
        if (this.myCaller == null) {
            return null;
        }
        if (this.myCaller.equals(FIRST_STATEMENT) && parentScope.getStatements().length != 0) {
            return parentScope.getStatements()[0];
        }
        return this.myCaller;
    }

    @NotNull
    public String getFileId() {
        String string = this.myFileId;
        if (string == null) {
            RuntimeFunctionScope.$$$reportNull$$$0(7);
        }
        return string;
    }

    public int getFunctionId() {
        return this.myFuncId;
    }

    public void setExecutionTime(Double executionTime) {
        this.myExecutionTime = executionTime;
    }

    @Nullable
    public Double getExecutionTime() {
        return this.myExecutionTime;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/javascript/trace/execution/common/RuntimeFunctionScope";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventMetadata";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "isProgram";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunc";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeRange";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileId";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

