/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.common;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.Utils;
import com.intellij.javascript.trace.execution.code.CodeRange;
import com.intellij.javascript.trace.execution.code.StaticCodeElement;
import com.intellij.javascript.trace.execution.common.RuntimeFunctionArgument;
import com.intellij.javascript.trace.execution.common.RuntimeFunctionScope;
import com.intellij.javascript.trace.execution.common.RuntimeReturnStatement;
import com.intellij.javascript.trace.execution.common.TraceRangeValue;
import com.intellij.javascript.trace.execution.context.FunctionSummaryValue;
import com.intellij.javascript.trace.execution.context.ParameterValue;
import com.intellij.javascript.trace.execution.context.ReturnValue;
import com.intellij.javascript.trace.execution.context.StackFrameContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TraceVirtualFile
extends LightVirtualFile {
    private static final int FUNC_KEYWORD_LENGTH = "function".length();
    private static final int RET_KEYWORD_LENGTH = "return".length();
    public static final String TRACE_POSTFIX = " trace";
    private final String myPath;
    private final List<Runnable> myContextChangedHandlers = new ArrayList<Runnable>();
    private final List<TraceRangeValue> myRangeValues = new ArrayList<TraceRangeValue>();
    private StackFrameContext myContext;
    private final VirtualFile myLocalFile;
    private final String myStreamId;

    public TraceVirtualFile(String url, String content, VirtualFile localFile, String streamId) {
        super((localFile != null ? localFile.getPresentableName() : Utils.getShortFileNameWithExtension(url)) + TRACE_POSTFIX, (CharSequence)content);
        this.myPath = url;
        this.myLocalFile = localFile;
        this.myStreamId = streamId;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            TraceVirtualFile.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public TraceRangeValue[] getActiveRangeValues() {
        TraceRangeValue[] traceRangeValueArray = this.myRangeValues.toArray(new TraceRangeValue[0]);
        if (traceRangeValueArray == null) {
            TraceVirtualFile.$$$reportNull$$$0(1);
        }
        return traceRangeValueArray;
    }

    public void updateRangeValues(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (editor == null) {
            TraceVirtualFile.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            TraceVirtualFile.$$$reportNull$$$0(3);
        }
        this.myRangeValues.clear();
        Document document = editor.getDocument();
        RuntimeFunctionScope activeScope = this.myContext.getStackFrame();
        TextRange functionRange = this.getFunctionRange(editor, activeScope);
        if (activeScope.isDumpCaptured() && !activeScope.isProgram().booleanValue()) {
            TextRange returnStatementRange;
            for (RuntimeFunctionArgument argument : activeScope.getArguments()) {
                if (!argument.hasRange()) continue;
                TextRange paramRange = this.getParamRange(editor, argument);
                int startLine = document.getLineNumber(paramRange.getStartOffset());
                int endLine = document.getLineNumber(paramRange.getEndOffset());
                int startColumn = paramRange.getStartOffset() - document.getLineStartOffset(startLine);
                int endColumn = paramRange.getEndOffset() - document.getLineStartOffset(endLine);
                if (paramRange.equals((Object)TextRange.EMPTY_RANGE)) continue;
                this.myRangeValues.add(new TraceRangeValue(document, new CodeRange(startLine + 1, endLine + 1, startColumn, endColumn), new ParameterValue(argument)));
            }
            if (!functionRange.equals((Object)TextRange.EMPTY_RANGE) && PsiUtilCore.getElementAtOffset((PsiFile)psiFile, (int)functionRange.getStartOffset()).getTextLength() == FUNC_KEYWORD_LENGTH) {
                this.myRangeValues.add(new TraceRangeValue(new TextRange(functionRange.getStartOffset(), functionRange.getStartOffset() + FUNC_KEYWORD_LENGTH), new FunctionSummaryValue(this.myContext)));
            }
            if (activeScope.hasReturnValue() && !(returnStatementRange = this.getReturnStatementRange(editor, activeScope.getReturnStatement())).equals((Object)TextRange.EMPTY_RANGE)) {
                int contextLength = PsiUtilCore.getElementAtOffset((PsiFile)psiFile, (int)returnStatementRange.getStartOffset()).getTextLength();
                this.myRangeValues.add(new TraceRangeValue(contextLength == RET_KEYWORD_LENGTH ? new TextRange(returnStatementRange.getStartOffset(), returnStatementRange.getStartOffset() + contextLength) : returnStatementRange, new ReturnValue(activeScope.getReturnValue())));
            }
        }
    }

    public void addContextChangedHandler(Runnable contextChangedHandler) {
        this.myContextChangedHandlers.add(contextChangedHandler);
    }

    public void setContext(@NotNull StackFrameContext context) {
        if (context == null) {
            TraceVirtualFile.$$$reportNull$$$0(4);
        }
        this.myContext = context;
        for (Runnable handler : this.myContextChangedHandlers) {
            handler.run();
        }
    }

    public VirtualFile getProjectFile() {
        return this.myLocalFile;
    }

    @NotNull
    public TextRange getCurrentScopeApproxRange(@NotNull Editor editor) {
        RuntimeFunctionScope functionScope;
        TextRange functionRange;
        if (editor == null) {
            TraceVirtualFile.$$$reportNull$$$0(5);
        }
        if ((functionRange = this.getFunctionRange(editor, functionScope = this.myContext.getStackFrame())) != TextRange.EMPTY_RANGE) {
            TextRange textRange = functionRange;
            if (textRange == null) {
                TraceVirtualFile.$$$reportNull$$$0(6);
            }
            return textRange;
        }
        int minOffset = editor.getDocument().getTextLength();
        int maxOffset = 0;
        for (TextRange range : ContainerUtil.concat((List)ContainerUtil.map(this.myRangeValues, value -> value.getTextRange()), (List)ContainerUtil.map((Object[])functionScope.getStatements(), statement -> {
            if (editor == null) {
                TraceVirtualFile.$$$reportNull$$$0(10);
            }
            return this.getStatementRange(editor, functionScope, statement.getCodeElement());
        }))) {
            if (range == TextRange.EMPTY_RANGE) continue;
            if (range.getStartOffset() < minOffset) {
                minOffset = range.getStartOffset();
            }
            if (range.getEndOffset() <= maxOffset) continue;
            maxOffset = range.getEndOffset();
        }
        TextRange textRange = maxOffset > minOffset ? new TextRange(minOffset, maxOffset) : TextRange.EMPTY_RANGE;
        if (textRange == null) {
            TraceVirtualFile.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    @NotNull
    public abstract TextRange getFunctionRange(@NotNull Editor var1, @NotNull RuntimeFunctionScope var2);

    @NotNull
    public abstract TextRange getStatementRange(@NotNull Editor var1, @NotNull RuntimeFunctionScope var2, @NotNull StaticCodeElement var3);

    @NotNull
    public abstract TextRange getReturnStatementRange(@NotNull Editor var1, @NotNull RuntimeReturnStatement var2);

    @NotNull
    public abstract TextRange getParamRange(@NotNull Editor var1, @NotNull RuntimeFunctionArgument var2);

    public StackFrameContext getCurrentContext() {
        return this.myContext;
    }

    @NotNull
    public String getStreamId() {
        String string = this.myStreamId;
        if (string == null) {
            TraceVirtualFile.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public String getLineExtension(@NotNull Editor editor, int lineNumber) {
        if (editor == null) {
            TraceVirtualFile.$$$reportNull$$$0(9);
        }
        TextRange activeFunctionRange = this.getCurrentScopeApproxRange(editor);
        int startLine = editor.getDocument().getLineNumber(activeFunctionRange.getStartOffset());
        if (startLine != lineNumber) {
            return null;
        }
        Double time = this.myContext.getStackFrame().getExecutionTime();
        if (time == null) {
            return null;
        }
        return String.format(TraceBundle.message("console.trace.funcExecutedIn", new Object[0]), Utils.formatExecutionTime(time));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/trace/execution/common/TraceVirtualFile";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveRangeValues";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/trace/execution/common/TraceVirtualFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentScopeApproxRange";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStreamId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateRangeValues";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setContext";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentScopeApproxRange";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLineExtension";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCurrentScopeApproxRange$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

