/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.stack;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.javascript.trace.execution.code.CodeRange;
import com.intellij.javascript.trace.execution.common.FunctionNamePresentation;
import com.intellij.javascript.trace.execution.common.RuntimeFunctionScope;
import com.intellij.javascript.trace.execution.stack.StackTree;
import com.intellij.lang.javascript.ui.FileColor;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StackNode
extends SimpleNode {
    private FunctionNamePresentation myFuncName;
    private RuntimeFunctionScope myScope;
    private String myFile;
    private final Boolean myIsRootNode;
    private final List<StackNode> myChildren;
    private double myStartTime;
    private Double myExecutionTime;
    private String myDisplayName;
    private int myNodeIndex;
    private CodeRange myCodeRange;
    private String myText;
    private boolean myTakesSignificantTimeToExecute;

    public StackNode() {
        this.myChildren = new ArrayList<StackNode>();
        this.myText = "";
        this.myIsRootNode = true;
    }

    private StackNode(@NotNull RuntimeFunctionScope scope, @NotNull StackNode parent) {
        if (scope == null) {
            StackNode.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            StackNode.$$$reportNull$$$0(1);
        }
        super((SimpleNode)parent);
        this.myChildren = new ArrayList<StackNode>();
        this.myText = "";
        this.myIsRootNode = false;
        this.myScope = scope;
        this.myCodeRange = this.myScope.getCodeRange();
        this.myFuncName = new FunctionNamePresentation(this.myScope, this.myScope.isProgram(), this.myScope.hasException());
        this.myFile = this.myScope.getFile();
        this.setIcon(FileColor.getIcon((String)this.myFile));
        this.setText(this.getPresentation());
    }

    public StackNode createChild(RuntimeFunctionScope scope) {
        StackNode child = new StackNode(scope, this);
        this.myChildren.add(child);
        return child;
    }

    public RuntimeFunctionScope getScope() {
        return this.myScope;
    }

    @NotNull
    public SimpleNode[] getChildren() {
        SimpleNode[] simpleNodeArray = this.myChildren.toArray(new SimpleNode[0]);
        if (simpleNodeArray == null) {
            StackNode.$$$reportNull$$$0(2);
        }
        return simpleNodeArray;
    }

    public String getName() {
        if (this.myDisplayName == null && !this.myIsRootNode.booleanValue()) {
            this.myDisplayName = this.myFuncName.getFunctionName();
        }
        return this.myDisplayName;
    }

    public void startedAt(double time) {
        this.myStartTime = time;
    }

    public void finishedAt(double time) {
        this.myExecutionTime = time - this.myStartTime;
        this.setText(this.getPresentation());
        this.myScope.setExecutionTime(this.myExecutionTime);
    }

    public StackNode getParentStackNode() {
        if (this.myIsRootNode.booleanValue()) {
            return null;
        }
        return (StackNode)this.getParent();
    }

    protected void setText(PresentationData presentation) {
        presentation.clearText();
        this.myText = this.myFuncName.buildFullName(presentation, true, this.myExecutionTime, this.myTakesSignificantTimeToExecute);
    }

    @NotNull
    public String getFile() {
        String string = this.myFile;
        if (string == null) {
            StackNode.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public CodeRange getCodeRange() {
        CodeRange codeRange = this.myCodeRange;
        if (codeRange == null) {
            StackNode.$$$reportNull$$$0(4);
        }
        return codeRange;
    }

    public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
        ((StackTree)tree).stackNodeSelected(this);
    }

    public boolean isAlwaysLeaf() {
        return this.myChildren.size() == 0;
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    public int getNodeIndex() {
        return this.myNodeIndex;
    }

    public void setNodeIndex(int nodeIndex) {
        this.myNodeIndex = nodeIndex;
    }

    public String getText() {
        return this.myText;
    }

    public double getExecutionTime() {
        return this.myExecutionTime != null ? this.myExecutionTime : 0.0;
    }

    public void takesSignificantTimeToExecute() {
        this.myTakesSignificantTimeToExecute = true;
        this.setText(this.getPresentation());
    }

    public int getFunctionId() {
        return this.myScope.getFunctionId();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/trace/execution/stack/StackNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/trace/execution/stack/StackNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

