/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.sourcecontrol.webapi;

import com.microsoft.alm.client.utils.ArgumentUtility;
import com.microsoft.alm.sourcecontrol.webapi.GitHttpClientBase;
import com.microsoft.alm.sourcecontrol.webapi.model.GitItem;
import com.microsoft.alm.sourcecontrol.webapi.model.GitRef;
import com.microsoft.alm.sourcecontrol.webapi.model.GitRepository;
import com.microsoft.alm.sourcecontrol.webapi.model.GitVersionDescriptor;
import com.microsoft.alm.sourcecontrol.webapi.model.VersionControlRecursionType;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.client.Client;

public class GitHttpClient
extends GitHttpClientBase {
    public GitHttpClient(Client jaxrsClient, URI baseUrl) {
        super(jaxrsClient, baseUrl);
    }

    public GitItem getItem(String project, String repositoryId, String path, boolean includeContentMetadata) {
        ArgumentUtility.checkStringForNullOrEmpty((String)project, (String)"project", (boolean)true);
        ArgumentUtility.checkStringForNullOrEmpty((String)repositoryId, (String)"repositoryId", (boolean)true);
        return super.getItem(project, repositoryId, path, null, VersionControlRecursionType.NONE, (Boolean)includeContentMetadata, (Boolean)false, (Boolean)false, null);
    }

    public GitItem getItem(String project, String repositoryId, String path, boolean includeContentMetadata, boolean latestProcessedChange, GitVersionDescriptor versionDescriptor) {
        ArgumentUtility.checkStringForNullOrEmpty((String)project, (String)"project", (boolean)true);
        ArgumentUtility.checkStringForNullOrEmpty((String)repositoryId, (String)"repositoryId", (boolean)true);
        return super.getItem(project, repositoryId, path, null, VersionControlRecursionType.NONE, (Boolean)includeContentMetadata, (Boolean)latestProcessedChange, (Boolean)false, versionDescriptor);
    }

    public GitItem getItem(UUID repositoryId, String path, boolean includeContentMetadata) {
        ArgumentUtility.checkForEmptyGuid((UUID)repositoryId, (String)"repositoryId");
        return super.getItem(repositoryId, path, null, VersionControlRecursionType.NONE, (Boolean)includeContentMetadata, (Boolean)false, (Boolean)false, null);
    }

    public GitItem getItem(UUID repositoryId, String path, boolean includeContentMetadata, boolean latestProcessedChange, GitVersionDescriptor versionDescriptor) {
        ArgumentUtility.checkForEmptyGuid((UUID)repositoryId, (String)"repositoryId");
        return super.getItem(repositoryId, path, null, VersionControlRecursionType.NONE, (Boolean)includeContentMetadata, (Boolean)latestProcessedChange, (Boolean)false, versionDescriptor);
    }

    public List<GitItem> getItems(UUID repositoryId, String scopePath, VersionControlRecursionType recursionLevel, boolean includeContentMetadata, boolean latestProcessedChange, boolean includeLinks, GitVersionDescriptor versionDescriptor) {
        ArgumentUtility.checkForEmptyGuid((UUID)repositoryId, (String)"repositoryId");
        return super.getItems(repositoryId, scopePath, recursionLevel, (Boolean)includeContentMetadata, (Boolean)latestProcessedChange, (Boolean)false, (Boolean)includeLinks, versionDescriptor);
    }

    public List<GitItem> getItems(String project, String repositoryId, String scopePath, VersionControlRecursionType recursionLevel, boolean includeContentMetadata, boolean latestProcessedChange, boolean includeLinks, GitVersionDescriptor versionDescriptor) {
        ArgumentUtility.checkStringForNullOrEmpty((String)project, (String)"project", (boolean)true);
        ArgumentUtility.checkStringForNullOrEmpty((String)repositoryId, (String)"repositoryId", (boolean)true);
        return super.getItems(project, repositoryId, scopePath, recursionLevel, (Boolean)includeContentMetadata, (Boolean)latestProcessedChange, (Boolean)false, (Boolean)includeLinks, versionDescriptor);
    }

    public InputStream getItemContent(UUID repositoryId, String path, GitVersionDescriptor versionDescriptor) {
        ArgumentUtility.checkForEmptyGuid((UUID)repositoryId, (String)"repositoryId");
        return super.getItemContent(repositoryId, path, null, VersionControlRecursionType.NONE, (Boolean)false, (Boolean)false, (Boolean)true, versionDescriptor);
    }

    public InputStream getItemContent(String project, String repositoryId, String path, GitVersionDescriptor versionDescriptor) {
        ArgumentUtility.checkStringForNullOrEmpty((String)project, (String)"project", (boolean)true);
        ArgumentUtility.checkStringForNullOrEmpty((String)repositoryId, (String)"repositoryId", (boolean)true);
        return super.getItemContent(repositoryId, path, null, VersionControlRecursionType.NONE, (Boolean)false, (Boolean)false, (Boolean)true, versionDescriptor);
    }

    public InputStream getItemZip(String project, String repositoryId, String scopePath, GitVersionDescriptor versionDescriptor) {
        ArgumentUtility.checkStringForNullOrEmpty((String)project, (String)"project", (boolean)true);
        ArgumentUtility.checkStringForNullOrEmpty((String)repositoryId, (String)"repositoryId", (boolean)true);
        return super.getItemZip(project, repositoryId, null, scopePath, VersionControlRecursionType.FULL, (Boolean)false, (Boolean)false, (Boolean)true, versionDescriptor);
    }

    public InputStream getItemZip(UUID repositoryId, String scopePath, GitVersionDescriptor versionDescriptor) {
        ArgumentUtility.checkForEmptyGuid((UUID)repositoryId, (String)"repositoryId");
        return super.getItemZip(repositoryId, null, scopePath, VersionControlRecursionType.FULL, (Boolean)false, (Boolean)false, (Boolean)true, versionDescriptor);
    }

    public List<GitRef> getRefs(String repositoryId) {
        ArgumentUtility.checkStringForNullOrEmpty((String)repositoryId, (String)"repositoryId", (boolean)true);
        return super.getRefs(repositoryId, null, null);
    }

    public List<GitRef> getRefs(String repositoryId, boolean includeLinks) {
        ArgumentUtility.checkStringForNullOrEmpty((String)repositoryId, (String)"repositoryId");
        return super.getRefs(repositoryId, null, (Boolean)includeLinks);
    }

    public List<GitRef> getRefs(String repositoryId, String refType) {
        ArgumentUtility.checkStringForNullOrEmpty((String)repositoryId, (String)"repositoryId");
        return super.getRefs(repositoryId, refType, null);
    }

    public List<GitRef> getRefs(String repositoryId, String refType, boolean includeLinks) {
        ArgumentUtility.checkStringForNullOrEmpty((String)repositoryId, (String)"repositoryId");
        ArgumentUtility.checkStringForNullOrEmpty((String)refType, (String)"refType", (boolean)true);
        return super.getRefs(repositoryId, refType, (Boolean)includeLinks);
    }

    public List<GitRef> getRefs(UUID repositoryId) {
        return super.getRefs(repositoryId, null, null);
    }

    public List<GitRef> getRefs(UUID repositoryId, boolean includeLinks) {
        ArgumentUtility.checkForEmptyGuid((UUID)repositoryId, (String)"repositoryId");
        return super.getRefs(repositoryId, null, (Boolean)includeLinks);
    }

    public List<GitRef> getRefs(UUID repositoryId, String refType) {
        ArgumentUtility.checkForEmptyGuid((UUID)repositoryId, (String)"repositoryId");
        return super.getRefs(repositoryId, refType, null);
    }

    public List<GitRef> getRefs(UUID repositoryId, String refType, boolean includeLinks) {
        ArgumentUtility.checkForEmptyGuid((UUID)repositoryId, (String)"repositoryId");
        ArgumentUtility.checkStringForNullOrEmpty((String)refType, (String)"refType", (boolean)true);
        return super.getRefs(repositoryId, refType, (Boolean)includeLinks);
    }

    public List<GitRepository> getRepositories() {
        return super.getRepositories(null);
    }

    public List<GitRepository> getRepositories(boolean includeLinks) {
        return super.getRepositories(includeLinks);
    }

    public List<GitRepository> getRepositories(String project) {
        ArgumentUtility.checkStringForNullOrEmpty((String)project, (String)"project", (boolean)true);
        return super.getRepositories(project, null);
    }

    public List<GitRepository> getRepositories(String project, boolean includeLinks) {
        ArgumentUtility.checkStringForNullOrEmpty((String)project, (String)"project", (boolean)true);
        return super.getRepositories(project, (Boolean)includeLinks);
    }
}

