/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.refactoring.rename;

import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.lang.properties.editor.ResourceBundleFileStructureViewElement;
import com.intellij.lang.properties.editor.ResourceBundlePropertyStructureViewElement;
import com.intellij.lang.properties.editor.ResourceBundleUtil;
import com.intellij.lang.properties.refactoring.rename.ResourceBundleRenameUtil;
import com.intellij.lang.properties.structureView.PropertiesPrefixGroup;
import com.intellij.lang.properties.structureView.PropertiesStructureViewElement;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleFromEditorRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        Project project;
        if (dataContext == null) {
            ResourceBundleFromEditorRenameHandler.$$$reportNull$$$0(0);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return false;
        }
        ResourceBundle bundle = ResourceBundleUtil.getResourceBundleFromDataContext(dataContext);
        if (bundle == null) {
            return false;
        }
        FileEditor fileEditor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(dataContext);
        if (!(fileEditor instanceof ResourceBundleEditor)) {
            return false;
        }
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        return virtualFile instanceof ResourceBundleAsVirtualFile;
    }

    public boolean isRenaming(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ResourceBundleFromEditorRenameHandler.$$$reportNull$$$0(1);
        }
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            ResourceBundleFromEditorRenameHandler.$$$reportNull$$$0(2);
        }
        ResourceBundleEditor resourceBundleEditor = (ResourceBundleEditor)((Object)PlatformDataKeys.FILE_EDITOR.getData(dataContext));
        assert (resourceBundleEditor != null);
        ResourceBundleEditorViewElement selectedElement = resourceBundleEditor.getSelectedElementIfOnlyOne();
        if (selectedElement != null) {
            CommandProcessor.getInstance().runUndoTransparentAction(() -> {
                if (project == null) {
                    ResourceBundleFromEditorRenameHandler.$$$reportNull$$$0(5);
                }
                if (selectedElement instanceof PropertiesPrefixGroup) {
                    PropertiesPrefixGroup group = (PropertiesPrefixGroup)selectedElement;
                    ResourceBundleRenameUtil.renameResourceBundleKeySection(ResourceBundleFromEditorRenameHandler.getPsiElementsFromGroup(group), group.getPresentableName(), group.getPrefix().length() - group.getPresentableName().length());
                } else if (selectedElement instanceof ResourceBundlePropertyStructureViewElement) {
                    PsiElement psiElement = ((ResourceBundlePropertyStructureViewElement)selectedElement).getPsiElement();
                    ResourceBundleRenameUtil.renameResourceBundleKey(psiElement, project);
                } else if (selectedElement instanceof ResourceBundleFileStructureViewElement) {
                    ResourceBundleRenameUtil.renameResourceBundleBaseName(((ResourceBundleFileStructureViewElement)selectedElement).getValue(), project);
                } else {
                    throw new IllegalStateException("unsupported type: " + selectedElement.getClass());
                }
            });
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            ResourceBundleFromEditorRenameHandler.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            ResourceBundleFromEditorRenameHandler.$$$reportNull$$$0(4);
        }
        this.invoke(project, null, null, dataContext);
    }

    private static List<PsiElement> getPsiElementsFromGroup(PropertiesPrefixGroup propertiesPrefixGroup) {
        return ContainerUtil.mapNotNull(propertiesPrefixGroup.getChildren(), (Function)((NullableFunction)treeElement -> {
            if (treeElement instanceof PropertiesStructureViewElement) {
                return ((PropertiesStructureViewElement)treeElement).getValue().getPsiElement();
            }
            if (treeElement instanceof ResourceBundlePropertyStructureViewElement) {
                return ((ResourceBundlePropertyStructureViewElement)treeElement).getPsiElement();
            }
            return null;
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/properties/refactoring/rename/ResourceBundleFromEditorRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isRenaming";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$invoke$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

