/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extension;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExtensionPointImpl<T>
implements ExtensionPoint<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.extensions.impl.ExtensionPointImpl");
    private final AreaInstance myArea;
    private final String myName;
    private final String myClassName;
    private final ExtensionPoint.Kind myKind;
    private volatile List<T> myExtensionsCache;
    private volatile T[] myExtensionsCacheAsArray;
    private final ExtensionsAreaImpl myOwner;
    private final PluginDescriptor myDescriptor;
    @NotNull
    private Set<ExtensionComponentAdapter> myExtensionAdapters;
    @NotNull
    private ExtensionPointListener<T>[] myEPListeners;
    @NotNull
    private List<ExtensionComponentAdapter> myLoadedAdapters;
    private Class<T> myExtensionClass;
    private static final StringInterner INTERNER = new StringInterner();
    private boolean processingAdaptersNow;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExtensionPointImpl(@NotNull String name, @NotNull String className, @NotNull ExtensionPoint.Kind kind, @NotNull ExtensionsAreaImpl owner, AreaInstance area, @NotNull PluginDescriptor descriptor) {
        if (name == null) {
            ExtensionPointImpl.$$$reportNull$$$0(0);
        }
        if (className == null) {
            ExtensionPointImpl.$$$reportNull$$$0(1);
        }
        if (kind == null) {
            ExtensionPointImpl.$$$reportNull$$$0(2);
        }
        if (owner == null) {
            ExtensionPointImpl.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(4);
        }
        this.myExtensionAdapters = Collections.emptySet();
        this.myEPListeners = ExtensionPointListener.EMPTY_ARRAY;
        this.myLoadedAdapters = Collections.emptyList();
        StringInterner stringInterner = INTERNER;
        synchronized (stringInterner) {
            this.myName = (String)INTERNER.intern((Object)name);
        }
        this.myClassName = className;
        this.myKind = kind;
        this.myOwner = owner;
        this.myArea = area;
        this.myDescriptor = descriptor;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ExtensionPointImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public AreaInstance getArea() {
        return this.myArea;
    }

    @Override
    @NotNull
    public String getClassName() {
        String string = this.myClassName;
        if (string == null) {
            ExtensionPointImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public ExtensionPoint.Kind getKind() {
        ExtensionPoint.Kind kind = this.myKind;
        if (kind == null) {
            ExtensionPointImpl.$$$reportNull$$$0(7);
        }
        return kind;
    }

    @Override
    public void registerExtension(@NotNull T extension) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(8);
        }
        this.registerExtension(extension, LoadingOrder.ANY);
    }

    @NotNull
    public PluginDescriptor getDescriptor() {
        PluginDescriptor pluginDescriptor = this.myDescriptor;
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(9);
        }
        return pluginDescriptor;
    }

    @Override
    public synchronized void registerExtension(@NotNull T extension, @NotNull LoadingOrder order) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(10);
        }
        if (order == null) {
            ExtensionPointImpl.$$$reportNull$$$0(11);
        }
        ObjectComponentAdapter adapter = new ObjectComponentAdapter(extension, order);
        if (LoadingOrder.ANY == order) {
            ExtensionComponentAdapter lastAdapter;
            int index;
            for (index = this.myLoadedAdapters.size(); index > 0 && (lastAdapter = this.myLoadedAdapters.get(index - 1)).getOrder() == LoadingOrder.LAST; --index) {
            }
            if (this.getExtensionIndex(extension) != -1) {
                LOG.error("Extension was already added: " + extension);
                return;
            }
            this.registerExtension(extension, adapter, index, true);
        } else {
            this.registerExtensionAdapter(adapter);
            this.processAdapters();
        }
    }

    private void registerExtension(@NotNull T extension, @NotNull ExtensionComponentAdapter adapter, int index, boolean runNotifications) {
        Class<T> extensionClass;
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(12);
        }
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(13);
        }
        if (!(extensionClass = this.getExtensionClass()).isInstance(extension)) {
            LOG.error("Extension " + extension.getClass() + " does not implement " + extensionClass);
            return;
        }
        if (this.myLoadedAdapters == Collections.emptyList()) {
            this.myLoadedAdapters = new ArrayList<ExtensionComponentAdapter>();
        }
        this.myLoadedAdapters.add(index, adapter);
        if (runNotifications) {
            this.clearCache();
            if (!adapter.isNotificationSent()) {
                if (extension instanceof Extension) {
                    try {
                        ((Extension)extension).extensionAdded(this);
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
                this.notifyListenersOnAdd(extension, adapter.getPluginDescriptor());
                adapter.setNotificationSent(true);
            }
        }
    }

    private void notifyListenersOnAdd(@NotNull T extension, PluginDescriptor pluginDescriptor) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(14);
        }
        for (ExtensionPointListener<T> listener : this.myEPListeners) {
            try {
                listener.extensionAdded(extension, pluginDescriptor);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<T> getExtensionList() {
        List<T> result = this.myExtensionsCache;
        if (result == null) {
            ExtensionPointImpl extensionPointImpl = this;
            synchronized (extensionPointImpl) {
                result = this.myExtensionsCache;
                if (result == null) {
                    T[] array = this.processAdapters();
                    if (array == null) {
                        result = Collections.emptyList();
                    } else {
                        this.myExtensionsCacheAsArray = array;
                        result = Collections.unmodifiableList(Arrays.asList(array));
                    }
                    this.myExtensionsCache = result;
                }
            }
        }
        List<T> list = result;
        if (list == null) {
            ExtensionPointImpl.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Override
    @NotNull
    public T[] getExtensions() {
        List<T> list = this.getExtensionList();
        if (list.isEmpty()) {
            Object[] objectArray = (Object[])Array.newInstance(this.getExtensionClass(), 0);
            if (objectArray == null) {
                ExtensionPointImpl.$$$reportNull$$$0(16);
            }
            return objectArray;
        }
        Object[] objectArray = (Object[])this.myExtensionsCacheAsArray.clone();
        if (objectArray == null) {
            ExtensionPointImpl.$$$reportNull$$$0(17);
        }
        return objectArray;
    }

    @Override
    @NotNull
    public Stream<T> extensions() {
        Stream stream = this.getExtensionList().stream();
        if (stream == null) {
            ExtensionPointImpl.$$$reportNull$$$0(18);
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAnyExtensions() {
        List<T> cache = this.myExtensionsCache;
        if (cache != null) {
            return !cache.isEmpty();
        }
        ExtensionPointImpl extensionPointImpl = this;
        synchronized (extensionPointImpl) {
            return this.myExtensionAdapters.size() + this.myLoadedAdapters.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable(value="null means empty")
    private T[] processAdapters() {
        if (this.processingAdaptersNow) {
            throw new IllegalStateException("Recursive processAdapters() detected. You must have called 'getExtensions()' from within your extension constructor - don't. Either pass extension via constructor parameter or call getExtensions() later.");
        }
        int totalSize = this.myExtensionAdapters.size() + this.myLoadedAdapters.size();
        if (totalSize == 0) {
            return null;
        }
        this.processingAdaptersNow = true;
        try {
            Class<T> extensionClass = this.getExtensionClass();
            Object[] result = (Object[])Array.newInstance(extensionClass, totalSize);
            ArrayList adapters = ContainerUtil.newArrayListWithCapacity((int)totalSize);
            adapters.addAll(this.myExtensionAdapters);
            adapters.addAll(this.myLoadedAdapters);
            LoadingOrder.sort(adapters);
            this.myExtensionAdapters = new LinkedHashSet<ExtensionComponentAdapter>(adapters);
            Set loaded = ContainerUtil.newHashOrEmptySet(this.myLoadedAdapters);
            this.myLoadedAdapters = Collections.emptyList();
            boolean errorHappened = false;
            for (int i = 0; i < adapters.size(); ++i) {
                ExtensionComponentAdapter adapter = (ExtensionComponentAdapter)adapters.get(i);
                try {
                    Object extension = adapter.getExtension();
                    if (extension == null) {
                        errorHappened = true;
                        LOG.error("null extension in: " + adapter + ";\ngetExtensionClass(): " + this.getExtensionClass() + ";\n");
                    }
                    if (i > 0 && extension == result[i - 1]) {
                        errorHappened = true;
                        LOG.error("Duplicate extension found: " + extension + ";  Adapter:      " + adapter + ";\n Prev adapter: " + adapters.get(i - 1) + ";\n getExtensionClass(): " + this.getExtensionClass() + ";\n result:" + Arrays.asList(result));
                    }
                    if (!extensionClass.isInstance(extension)) {
                        errorHappened = true;
                        LOG.error("Extension " + (extension == null ? null : extension.getClass()) + " does not implement " + extensionClass + ". It came from " + adapter);
                        continue;
                    }
                    result[i] = extension;
                    this.registerExtension(extension, adapter, this.myLoadedAdapters.size(), !loaded.contains(adapter));
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    errorHappened = true;
                    LOG.error((Throwable)e);
                }
                this.myExtensionAdapters.remove(adapter);
            }
            this.myExtensionAdapters = Collections.emptySet();
            if (errorHappened) {
                result = ContainerUtil.findAllAsArray((Object[])result, (Condition)Condition.NOT_NULL);
            }
            Object[] objectArray = result;
            return objectArray;
        }
        finally {
            this.processingAdaptersNow = false;
        }
    }

    public synchronized void removeUnloadableExtensions() {
        ExtensionComponentAdapter[] adapters;
        for (ExtensionComponentAdapter adapter : adapters = this.myExtensionAdapters.toArray(ExtensionComponentAdapter.EMPTY_ARRAY)) {
            try {
                adapter.getComponentImplementation();
            }
            catch (Throwable e) {
                this.unregisterExtensionAdapter(adapter);
            }
        }
    }

    @Override
    @Nullable
    public T getExtension() {
        List<T> extensions = this.getExtensionList();
        return extensions.isEmpty() ? null : (T)extensions.get(0);
    }

    @Override
    public synchronized boolean hasExtension(@NotNull T extension) {
        Object[] extensions;
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(19);
        }
        return (extensions = this.processAdapters()) != null && ArrayUtil.contains(extension, (Object[])extensions);
    }

    @Override
    public synchronized void unregisterExtension(@NotNull T extension) {
        int index;
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(20);
        }
        if ((index = this.getExtensionIndex(extension)) == -1) {
            throw new IllegalArgumentException("Extension to be removed not found: " + extension);
        }
        ExtensionComponentAdapter adapter = this.myLoadedAdapters.get(index);
        Object key = adapter.getComponentKey();
        this.myOwner.getPicoContainer().unregisterComponent(key);
        this.processAdapters();
        this.unregisterExtension(extension, null);
    }

    @Override
    public void unregisterExtension(@NotNull Class<? extends T> extensionClass) {
        if (extensionClass == null) {
            ExtensionPointImpl.$$$reportNull$$$0(21);
        }
        for (ExtensionComponentAdapter adapter : ContainerUtil.concat((Iterable[])new Iterable[]{this.myExtensionAdapters, this.myLoadedAdapters})) {
            if (!adapter.getAssignableToClassName().equals(extensionClass.getCanonicalName())) continue;
            this.unregisterExtensionAdapter(adapter);
            return;
        }
        throw new IllegalArgumentException("Extension to be removed not found: " + extensionClass);
    }

    private int getExtensionIndex(@NotNull T extension) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(22);
        }
        for (int i = 0; i < this.myLoadedAdapters.size(); ++i) {
            ExtensionComponentAdapter adapter = this.myLoadedAdapters.get(i);
            if (!Comparing.equal((Object)adapter.getExtension(), extension)) continue;
            return i;
        }
        return -1;
    }

    private void unregisterExtension(@NotNull T extension, PluginDescriptor pluginDescriptor) {
        int index;
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(23);
        }
        if ((index = this.getExtensionIndex(extension)) == -1) {
            throw new IllegalArgumentException("Extension to be removed not found: " + extension);
        }
        this.myLoadedAdapters.remove(index);
        this.clearCache();
        this.notifyListenersOnRemove(extension, pluginDescriptor);
        if (extension instanceof Extension) {
            try {
                ((Extension)extension).extensionRemoved(this);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    private void notifyListenersOnRemove(@NotNull T extensionObject, PluginDescriptor pluginDescriptor) {
        if (extensionObject == null) {
            ExtensionPointImpl.$$$reportNull$$$0(24);
        }
        for (ExtensionPointListener<T> listener : this.myEPListeners) {
            try {
                listener.extensionRemoved(extensionObject, pluginDescriptor);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    @Override
    public void addExtensionPointListener(@NotNull ExtensionPointListener<T> listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(25);
        }
        if (parentDisposable == null) {
            ExtensionPointImpl.$$$reportNull$$$0(26);
        }
        this.addExtensionPointListener(listener, true, parentDisposable);
    }

    public synchronized void addExtensionPointListener(@NotNull ExtensionPointListener<T> listener, boolean invokeForLoadedExtensions, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(27);
        }
        if (parentDisposable == null) {
            ExtensionPointImpl.$$$reportNull$$$0(28);
        }
        if (invokeForLoadedExtensions) {
            this.addExtensionPointListener(listener);
        } else {
            this.addListener(listener);
        }
        Disposer.register((Disposable)parentDisposable, () -> {
            if (listener == null) {
                ExtensionPointImpl.$$$reportNull$$$0(38);
            }
            this.removeExtensionPointListener(listener, invokeForLoadedExtensions);
        });
    }

    private boolean addListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(29);
        }
        if (ArrayUtil.indexOf((Object[])this.myEPListeners, listener) != -1) {
            return false;
        }
        this.myEPListeners = (ExtensionPointListener[])ArrayUtil.append((Object[])this.myEPListeners, listener, n -> n == 0 ? ExtensionPointListener.EMPTY_ARRAY : new ExtensionPointListener[n]);
        return true;
    }

    private boolean removeListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(30);
        }
        if (ArrayUtil.indexOf((Object[])this.myEPListeners, listener) == -1) {
            return false;
        }
        this.myEPListeners = (ExtensionPointListener[])ArrayUtil.remove((Object[])this.myEPListeners, listener, n -> n == 0 ? ExtensionPointListener.EMPTY_ARRAY : new ExtensionPointListener[n]);
        return true;
    }

    @Override
    public synchronized void addExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(31);
        }
        this.processAdapters();
        if (this.addListener(listener)) {
            ExtensionComponentAdapter[] array;
            for (ExtensionComponentAdapter componentAdapter : array = this.myLoadedAdapters.toArray(ExtensionComponentAdapter.EMPTY_ARRAY)) {
                try {
                    Object extension = componentAdapter.getExtension();
                    listener.extensionAdded(extension, componentAdapter.getPluginDescriptor());
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }

    @Override
    public void removeExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(32);
        }
        this.removeExtensionPointListener(listener, true);
    }

    private synchronized void removeExtensionPointListener(@NotNull ExtensionPointListener<T> listener, boolean invokeForLoadedExtensions) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(33);
        }
        if (this.removeListener(listener) && invokeForLoadedExtensions) {
            ExtensionComponentAdapter[] array;
            for (ExtensionComponentAdapter componentAdapter : array = this.myLoadedAdapters.toArray(ExtensionComponentAdapter.EMPTY_ARRAY)) {
                try {
                    Object extension = componentAdapter.getExtension();
                    listener.extensionRemoved(extension, componentAdapter.getPluginDescriptor());
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }

    @Override
    public synchronized void reset() {
        this.myOwner.removeAllComponents(this.myExtensionAdapters);
        this.myExtensionAdapters = Collections.emptySet();
        for (T extension : this.getExtensionList()) {
            this.unregisterExtension(extension);
        }
    }

    @Override
    @NotNull
    public Class<T> getExtensionClass() {
        Class<Object> extensionClass = this.myExtensionClass;
        if (extensionClass == null) {
            try {
                ClassLoader pluginClassLoader = this.myDescriptor.getPluginClassLoader();
                Class<?> extClass = pluginClassLoader == null ? Class.forName(this.myClassName) : Class.forName(this.myClassName, true, pluginClassLoader);
                this.myExtensionClass = extensionClass = extClass;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        Class<T> clazz = extensionClass;
        if (clazz == null) {
            ExtensionPointImpl.$$$reportNull$$$0(34);
        }
        return clazz;
    }

    public String toString() {
        return this.getName();
    }

    synchronized void registerExtensionAdapter(@NotNull ExtensionComponentAdapter adapter) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(35);
        }
        if (this.myExtensionAdapters == Collections.emptySet()) {
            this.myExtensionAdapters = new LinkedHashSet<ExtensionComponentAdapter>();
        }
        this.myExtensionAdapters.add(adapter);
        this.clearCache();
    }

    private void clearCache() {
        this.myExtensionsCache = null;
        this.myExtensionsCacheAsArray = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterExtensionAdapter(@NotNull ExtensionComponentAdapter adapter) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(36);
        }
        try {
            if (!this.myExtensionAdapters.isEmpty() && this.myExtensionAdapters.remove(adapter)) {
                return;
            }
            if (this.myLoadedAdapters.contains(adapter)) {
                Object key = adapter.getComponentKey();
                this.myOwner.getPicoContainer().unregisterComponent(key);
                Object extension = adapter.getExtension();
                this.unregisterExtension(extension, adapter.getPluginDescriptor());
            }
        }
        finally {
            this.clearCache();
        }
    }

    final synchronized void notifyAreaReplaced(@NotNull ExtensionsArea oldArea) {
        if (oldArea == null) {
            ExtensionPointImpl.$$$reportNull$$$0(37);
        }
        for (ExtensionPointListener<T> listener : this.myEPListeners) {
            if (!(listener instanceof ExtensionPointAndAreaListener)) continue;
            ((ExtensionPointAndAreaListener)listener).areaReplaced(oldArea);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 13: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapter";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClass";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionObject";
                break;
            }
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldArea";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionList";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "extensions";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 34: {
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "notifyListenersOnAdd";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "hasExtension";
                break;
            }
            case 20: 
            case 21: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtension";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionIndex";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "notifyListenersOnRemove";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionPointListener";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "removeExtensionPointListener";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionAdapter";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensionAdapter";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "notifyAreaReplaced";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addExtensionPointListener$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ObjectComponentAdapter
    extends ExtensionComponentAdapter {
        private final Object myExtension;
        private final LoadingOrder myLoadingOrder;

        private ObjectComponentAdapter(@NotNull Object extension, @NotNull LoadingOrder loadingOrder) {
            if (extension == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(0);
            }
            if (loadingOrder == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(1);
            }
            super(extension.getClass().getName(), null, null, null);
            this.myExtension = extension;
            this.myLoadingOrder = loadingOrder;
        }

        @Override
        public Object getExtension() {
            return this.myExtension;
        }

        @Override
        public LoadingOrder getOrder() {
            return this.myLoadingOrder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "loadingOrder";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl$ObjectComponentAdapter";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

