/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.distributedtask.webapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.AlmHttpClientBase;
import com.microsoft.alm.client.model.ApiResourceVersion;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.distributedtask.webapi.model.TaskAttachment;
import com.microsoft.alm.distributedtask.webapi.model.TaskLog;
import com.microsoft.alm.distributedtask.webapi.model.TaskOrchestrationPlan;
import com.microsoft.alm.distributedtask.webapi.model.Timeline;
import com.microsoft.alm.distributedtask.webapi.model.TimelineRecord;
import com.microsoft.visualstudio.services.webapi.model.VssJsonCollectionWrapper;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.client.Invocation;

public abstract class TaskHttpClientBase
extends AlmHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected TaskHttpClientBase(Object jaxrsClient, URI baseUrl) {
        super(jaxrsClient, baseUrl);
    }

    protected TaskHttpClientBase(Object tfsConnection) {
        super(tfsConnection);
    }

    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public List<TaskAttachment> getPlanAttachments(UUID scopeIdentifier, String hubName, UUID planId, String type) {
        UUID locationId = UUID.fromString("eb55e5d6-2f30-4295-b5ed-38da50b1fc52");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        routeValues.put("type", type);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TaskAttachment>>(){});
    }

    public TaskAttachment createAttachment(InputStream uploadStream, UUID scopeIdentifier, String hubName, UUID planId, UUID timelineId, UUID recordId, String type, String name) {
        UUID locationId = UUID.fromString("7898f959-9cdf-4096-b29e-7f293031629e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        routeValues.put("timelineId", timelineId);
        routeValues.put("recordId", recordId);
        routeValues.put("type", type);
        routeValues.put("name", name);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PUT, locationId, routeValues, apiVersion, (Object)uploadStream, APPLICATION_OCTET_STREAM_TYPE, APPLICATION_JSON_TYPE);
        return (TaskAttachment)super.sendRequest((Object)httpRequest, TaskAttachment.class);
    }

    public TaskAttachment getAttachment(UUID scopeIdentifier, String hubName, UUID planId, UUID timelineId, UUID recordId, String type, String name) {
        UUID locationId = UUID.fromString("7898f959-9cdf-4096-b29e-7f293031629e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        routeValues.put("timelineId", timelineId);
        routeValues.put("recordId", recordId);
        routeValues.put("type", type);
        routeValues.put("name", name);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (TaskAttachment)super.sendRequest((Object)httpRequest, TaskAttachment.class);
    }

    public InputStream getAttachmentContent(UUID scopeIdentifier, String hubName, UUID planId, UUID timelineId, UUID recordId, String type, String name) {
        UUID locationId = UUID.fromString("7898f959-9cdf-4096-b29e-7f293031629e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        routeValues.put("timelineId", timelineId);
        routeValues.put("recordId", recordId);
        routeValues.put("type", type);
        routeValues.put("name", name);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_OCTET_STREAM_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public List<TaskAttachment> getAttachments(UUID scopeIdentifier, String hubName, UUID planId, UUID timelineId, UUID recordId, String type) {
        UUID locationId = UUID.fromString("7898f959-9cdf-4096-b29e-7f293031629e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        routeValues.put("timelineId", timelineId);
        routeValues.put("recordId", recordId);
        routeValues.put("type", type);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TaskAttachment>>(){});
    }

    public void appendTimelineRecordFeed(VssJsonCollectionWrapper<List<String>> lines, UUID scopeIdentifier, String hubName, UUID planId, UUID timelineId, UUID recordId) {
        UUID locationId = UUID.fromString("858983e4-19bd-4c5e-864c-507b59b58b12");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        routeValues.put("timelineId", timelineId);
        routeValues.put("recordId", recordId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, lines, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public TaskLog appendLogContent(InputStream uploadStream, UUID scopeIdentifier, String hubName, UUID planId, int logId) {
        UUID locationId = UUID.fromString("46f5667d-263a-4684-91b1-dff7fdcf64e2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        routeValues.put("logId", logId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)uploadStream, APPLICATION_OCTET_STREAM_TYPE, APPLICATION_JSON_TYPE);
        return (TaskLog)super.sendRequest((Object)httpRequest, TaskLog.class);
    }

    public TaskLog createLog(TaskLog log, UUID scopeIdentifier, String hubName, UUID planId) {
        UUID locationId = UUID.fromString("46f5667d-263a-4684-91b1-dff7fdcf64e2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)log, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (TaskLog)super.sendRequest((Object)httpRequest, TaskLog.class);
    }

    public List<String> getLog(UUID scopeIdentifier, String hubName, UUID planId, int logId, Integer startLine, Integer endLine) {
        UUID locationId = UUID.fromString("46f5667d-263a-4684-91b1-dff7fdcf64e2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        routeValues.put("logId", logId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("startLine", (Object)startLine);
        queryParameters.addIfNotNull("endLine", (Object)endLine);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<String>>(){});
    }

    public List<TaskLog> getLogs(UUID scopeIdentifier, String hubName, UUID planId) {
        UUID locationId = UUID.fromString("46f5667d-263a-4684-91b1-dff7fdcf64e2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TaskLog>>(){});
    }

    public TaskOrchestrationPlan getPlan(UUID scopeIdentifier, String hubName, UUID planId) {
        UUID locationId = UUID.fromString("5cecd946-d704-471e-a45f-3b4064fcfaba");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (TaskOrchestrationPlan)super.sendRequest((Object)httpRequest, TaskOrchestrationPlan.class);
    }

    public List<TimelineRecord> getRecords(UUID scopeIdentifier, String hubName, UUID planId, UUID timelineId, Integer changeId) {
        UUID locationId = UUID.fromString("8893bc5b-35b2-4be7-83cb-99e683551db4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        routeValues.put("timelineId", timelineId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("changeId", (Object)changeId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TimelineRecord>>(){});
    }

    public List<TimelineRecord> updateRecords(VssJsonCollectionWrapper<List<TimelineRecord>> records, UUID scopeIdentifier, String hubName, UUID planId, UUID timelineId) {
        UUID locationId = UUID.fromString("8893bc5b-35b2-4be7-83cb-99e683551db4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        routeValues.put("timelineId", timelineId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PATCH, locationId, routeValues, apiVersion, records, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TimelineRecord>>(){});
    }

    public Timeline createTimeline(Timeline timeline, UUID scopeIdentifier, String hubName, UUID planId) {
        UUID locationId = UUID.fromString("83597576-cc2c-453c-bea6-2882ae6a1653");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)timeline, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (Timeline)super.sendRequest((Object)httpRequest, Timeline.class);
    }

    public void deleteTimeline(UUID scopeIdentifier, String hubName, UUID planId, UUID timelineId) {
        UUID locationId = UUID.fromString("83597576-cc2c-453c-bea6-2882ae6a1653");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        routeValues.put("timelineId", timelineId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public Timeline getTimeline(UUID scopeIdentifier, String hubName, UUID planId, UUID timelineId, Integer changeId, Boolean includeRecords) {
        UUID locationId = UUID.fromString("83597576-cc2c-453c-bea6-2882ae6a1653");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        routeValues.put("timelineId", timelineId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("changeId", (Object)changeId);
        queryParameters.addIfNotNull("includeRecords", (Object)includeRecords);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (Timeline)super.sendRequest((Object)httpRequest, Timeline.class);
    }

    public List<Timeline> getTimelines(UUID scopeIdentifier, String hubName, UUID planId) {
        UUID locationId = UUID.fromString("83597576-cc2c-453c-bea6-2882ae6a1653");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("hubName", hubName);
        routeValues.put("planId", planId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<Timeline>>(){});
    }
}

