/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.distributedtask.webapi.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.alm.distributedtask.webapi.model.TaskOrchestrationContainer;
import com.microsoft.alm.distributedtask.webapi.model.TaskOrchestrationItem;
import com.microsoft.alm.distributedtask.webapi.model.TaskOrchestrationItemType;
import com.microsoft.alm.distributedtask.webapi.model.TaskOrchestrationJob;
import java.io.IOException;

public class TaskOrchestrationItemDeserializer
extends JsonDeserializer<TaskOrchestrationItem> {
    public TaskOrchestrationItem deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        JsonNode rootNode = (JsonNode)mapper.readTree(parser);
        JsonNode itenTypeNode = rootNode.findValue("ItemType");
        if (itenTypeNode != null) {
            TaskOrchestrationItemType itemType = null;
            if (itenTypeNode.isInt() && itenTypeNode.asInt() == TaskOrchestrationItemType.CONTAINER.getValue()) {
                itemType = TaskOrchestrationItemType.CONTAINER;
            } else if (itenTypeNode.isInt() && itenTypeNode.asInt() == TaskOrchestrationItemType.JOB.getValue()) {
                itemType = TaskOrchestrationItemType.JOB;
            } else if (itenTypeNode.isTextual() && TaskOrchestrationItemType.CONTAINER.toString().equalsIgnoreCase(itenTypeNode.asText())) {
                itemType = TaskOrchestrationItemType.CONTAINER;
            } else if (itenTypeNode.isTextual() && TaskOrchestrationItemType.JOB.toString().equalsIgnoreCase(itenTypeNode.asText())) {
                itemType = TaskOrchestrationItemType.JOB;
            }
            if (TaskOrchestrationItemType.JOB == itemType) {
                return (TaskOrchestrationItem)rootNode.traverse((ObjectCodec)mapper).readValueAs(TaskOrchestrationJob.class);
            }
            if (TaskOrchestrationItemType.CONTAINER == itemType) {
                return (TaskOrchestrationItem)rootNode.traverse((ObjectCodec)mapper).readValueAs(TaskOrchestrationContainer.class);
            }
        }
        return null;
    }
}

