/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.razor.psi;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.rider.razor.psi.RazorElementTypes;
import com.jetbrains.rider.razor.psi.RazorLanguage;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0006H\u0014J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0016\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/razor/psi/RazorFileViewProvider;", "Lcom/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider;", "Lcom/intellij/psi/templateLanguages/TemplateLanguageFileViewProvider;", "manager", "Lcom/intellij/psi/PsiManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "physical", "", "(Lcom/intellij/psi/PsiManager;Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "cloneInner", "fileCopy", "createFile", "Lcom/intellij/psi/PsiFile;", "lang", "Lcom/intellij/lang/Language;", "getBaseLanguage", "Lcom/jetbrains/rider/razor/psi/RazorLanguage;", "getLanguages", "", "getTemplateDataLanguage", "Companion", "rider-razor"})
public final class RazorFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    private static final Set<Language> LANGUAGES;
    public static final Companion Companion;

    @NotNull
    public Language getTemplateDataLanguage() {
        HTMLLanguage hTMLLanguage = HTMLLanguage.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)hTMLLanguage, (String)"HTMLLanguage.INSTANCE");
        return (Language)hTMLLanguage;
    }

    @NotNull
    public Set<Language> getLanguages() {
        return LANGUAGES;
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        PsiFile psiFile;
        Intrinsics.checkParameterIsNotNull((Object)lang, (String)"lang");
        if (lang == this.getTemplateDataLanguage()) {
            Object object = LanguageParserDefinitions.INSTANCE.forLanguage(lang);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            PsiFile psiFile2 = ((ParserDefinition)object).createFile((FileViewProvider)this);
            if (psiFile2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.source.PsiFileImpl");
            }
            PsiFileImpl file = (PsiFileImpl)psiFile2;
            file.setContentElementType((IElementType)RazorElementTypes.INSTANCE.getRAZOR_TEMPLATE_DATA());
            return (PsiFile)file;
        }
        if (lang == this.getBaseLanguage()) {
            Object object = LanguageParserDefinitions.INSTANCE.forLanguage(lang);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            psiFile = ((ParserDefinition)object).createFile((FileViewProvider)this);
        } else {
            psiFile = null;
        }
        return psiFile;
    }

    @NotNull
    public RazorLanguage getBaseLanguage() {
        return RazorLanguage.INSTANCE;
    }

    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile fileCopy) {
        Intrinsics.checkParameterIsNotNull((Object)fileCopy, (String)"fileCopy");
        PsiManagerEx psiManagerEx = this.getManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiManagerEx, (String)"manager");
        return new RazorFileViewProvider((PsiManager)psiManagerEx, fileCopy, false);
    }

    public RazorFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file, boolean physical) {
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        super(manager, file, physical);
    }

    static {
        Companion = new Companion(null);
        LANGUAGES = SetsKt.setOf((Object[])new Language[]{(Language)RazorLanguage.INSTANCE, (Language)HTMLLanguage.INSTANCE});
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/razor/psi/RazorFileViewProvider$Companion;", "", "()V", "LANGUAGES", "", "Lcom/intellij/lang/Language;", "kotlin.jvm.PlatformType", "rider-razor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

