/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.TypeEvaluator;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.UastContext;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class ClickableViewAccessibilityDetector
extends Detector
implements SourceCodeScanner {
    public static final Issue ISSUE = Issue.create((String)"ClickableViewAccessibility", (String)"Accessibility in Custom Views", (String)"If a `View` that overrides `onTouchEvent` or uses an `OnTouchListener` does not also implement `performClick` and call it when clicks are detected, the `View` may not handle accessibility actions properly. Logic handling the click actions should ideally be placed in `View#performClick` as some accessibility services invoke `performClick` when a click action should occur.", (Category)Category.A11Y, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(ClickableViewAccessibilityDetector.class, Scope.JAVA_FILE_SCOPE));
    private static final String PERFORM_CLICK = "performClick";
    public static final String ON_TOUCH_EVENT = "onTouchEvent";
    private static final String ON_TOUCH = "onTouch";
    private static final String CLASS_ON_TOUCH_LISTENER = "android.view.View.OnTouchListener";

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("setOnTouchListener");
    }

    public void visitMethod(JavaContext context, UCallExpression node, PsiMethod method) {
        JavaEvaluator evaluator = context.getEvaluator();
        if (!evaluator.isMemberInSubClassOf((PsiMember)method, "android.view.View", false)) {
            return;
        }
        if (!evaluator.parametersMatch(method, new String[]{CLASS_ON_TOUCH_LISTENER})) {
            return;
        }
        PsiType type = TypeEvaluator.evaluate((UElement)node.getReceiver());
        if (!(type instanceof PsiClassType)) {
            return;
        }
        PsiClass viewClass = ((PsiClassType)type).resolve();
        if (viewClass == null) {
            return;
        }
        if (viewClass instanceof PsiTypeParameter) {
            type = node.getReceiverType();
            if (!(type instanceof PsiClassType)) {
                return;
            }
            viewClass = ((PsiClassType)type).resolve();
            if (viewClass == null) {
                return;
            }
        }
        if (evaluator.isAbstract((PsiModifierListOwner)viewClass)) {
            return;
        }
        PsiMethod performClick = ClickableViewAccessibilityDetector.findPerformClickMethod(viewClass);
        if (performClick == null) {
            String message = String.format("Custom view `%1$s` has `setOnTouchListener` called on it but does not override `performClick`", ClickableViewAccessibilityDetector.describeClass(viewClass));
            context.report(ISSUE, (UElement)node, context.getLocation((UElement)node), message);
        }
    }

    public List<String> applicableSuperClasses() {
        return Arrays.asList("android.view.View", CLASS_ON_TOUCH_LISTENER);
    }

    public void visitClass(JavaContext context, UClass declaration) {
        JavaEvaluator evaluator = context.getEvaluator();
        if (evaluator.isAbstract((PsiModifierListOwner)declaration)) {
            return;
        }
        if (!evaluator.implementsInterface((PsiClass)declaration, "android.view.View", true)) {
            ClickableViewAccessibilityDetector.checkOnTouchListener(context, declaration);
        } else {
            ClickableViewAccessibilityDetector.checkCustomView(context, declaration);
        }
    }

    public void visitClass(JavaContext context, ULambdaExpression lambda) {
        ClickableViewAccessibilityDetector.checkOnTouchListenerLambda(context, lambda);
    }

    private static void checkCustomView(JavaContext context, UClass declaration) {
        UastContext uastContext;
        UElement uastMethod;
        String message;
        PsiMethod[] onTouchEvents;
        JavaEvaluator evaluator = context.getEvaluator();
        PsiMethod onTouchEvent = null;
        for (PsiMethod method : onTouchEvents = declaration.findMethodsByName(ON_TOUCH_EVENT, false)) {
            if (!evaluator.parametersMatch(method, new String[]{"android.view.MotionEvent"})) continue;
            onTouchEvent = method;
            break;
        }
        PsiMethod performClick = ClickableViewAccessibilityDetector.findPerformClickMethod((PsiClass)declaration);
        if (onTouchEvent != null) {
            if (performClick == null) {
                String message2 = String.format("Custom view %1$s overrides `onTouchEvent` but not `performClick`", ClickableViewAccessibilityDetector.describeClass((PsiClass)declaration));
                context.report(ISSUE, (PsiElement)onTouchEvent, context.getNameLocation((PsiElement)onTouchEvent), message2);
            } else {
                UastContext uastContext2 = UastUtils.getUastContext((UElement)declaration);
                UElement uastMethod2 = uastContext2.convertElement(onTouchEvent, null, UMethod.class);
                if (uastMethod2 != null && !ClickableViewAccessibilityDetector.performsClick(uastMethod2)) {
                    message = String.format("%1$s should call %2$s when a click is detected", ClickableViewAccessibilityDetector.describeMethod(ON_TOUCH_EVENT, (PsiClass)declaration), ClickableViewAccessibilityDetector.describeMethod(PERFORM_CLICK, (PsiClass)declaration));
                    context.report(ISSUE, (PsiElement)onTouchEvent, context.getNameLocation((PsiElement)onTouchEvent), message);
                }
            }
        }
        if (performClick != null && (uastMethod = (uastContext = UastUtils.getUastContext((UElement)declaration)).convertElement((PsiElement)performClick, null, UMethod.class)) != null && !ClickableViewAccessibilityDetector.performsClickCallsSuper(uastMethod)) {
            message = String.format("%1$s should call `super#performClick`", ClickableViewAccessibilityDetector.describeMethod(PERFORM_CLICK, (PsiClass)declaration));
            context.report(ISSUE, (PsiElement)performClick, context.getNameLocation((PsiElement)performClick), message);
        }
    }

    private static void checkOnTouchListener(JavaContext context, UClass declaration) {
        PsiMethod[] onTouchMethods;
        JavaEvaluator evaluator = context.getEvaluator();
        for (PsiMethod method : onTouchMethods = declaration.findMethodsByName(ON_TOUCH, false)) {
            if (!evaluator.parametersMatch(method, new String[]{"android.view.View", "android.view.MotionEvent"})) continue;
            UastContext uastContext = UastUtils.getUastContext((UElement)declaration);
            UElement uastMethod = uastContext.convertElement((PsiElement)method, null, UMethod.class);
            if (uastMethod == null || ClickableViewAccessibilityDetector.performsClick(uastMethod)) break;
            String message = String.format("%1$s should call `View#performClick` when a click is detected", ClickableViewAccessibilityDetector.describeMethod(ON_TOUCH, (PsiClass)declaration));
            context.report(ISSUE, (PsiElement)method, context.getNameLocation((PsiElement)method), message);
            break;
        }
    }

    private static void checkOnTouchListenerLambda(JavaContext context, ULambdaExpression lambda) {
        if (!ClickableViewAccessibilityDetector.performsClick((UElement)lambda.getBody())) {
            String message = String.format("%1$s lambda should call `View#performClick` when a click is detected", ClickableViewAccessibilityDetector.describeMethod(ON_TOUCH, null));
            context.report(ISSUE, (UElement)lambda, context.getNameLocation((UElement)lambda), message);
        }
    }

    private static PsiMethod findPerformClickMethod(PsiClass clz) {
        PsiMethod[] performClicks;
        PsiMethod performClick = null;
        for (PsiMethod method : performClicks = clz.findMethodsByName(PERFORM_CLICK, false)) {
            if (method.getParameterList().getParametersCount() != 0) continue;
            performClick = method;
            break;
        }
        return performClick;
    }

    private static String describeClass(PsiClass declaration) {
        String name = declaration.getName();
        if (name != null) {
            return '`' + name + '`';
        }
        return "anonymous class";
    }

    private static String describeMethod(String methodName, PsiClass inClass) {
        String name;
        if (inClass != null && (name = inClass.getName()) != null) {
            return '`' + name + '#' + methodName + '`';
        }
        return '`' + methodName + '`';
    }

    private static boolean performsClick(UElement element) {
        PerformsClickVisitor visitor = new PerformsClickVisitor();
        element.accept((UastVisitor)visitor);
        return visitor.performsClick();
    }

    private static boolean performsClickCallsSuper(UElement element) {
        PerformsClickCallsSuperVisitor visitor = new PerformsClickCallsSuperVisitor();
        element.accept((UastVisitor)visitor);
        return visitor.callsSuper();
    }

    private static class PerformsClickCallsSuperVisitor
    extends AbstractUastVisitor {
        private boolean callsSuper;

        public boolean visitSuperExpression(USuperExpression node) {
            PsiElement resolved;
            UElement parent = LintUtils.skipParentheses((UElement)node.getUastParent());
            if (parent instanceof UReferenceExpression && (resolved = ((UReferenceExpression)parent).resolve()) instanceof PsiMethod && ClickableViewAccessibilityDetector.PERFORM_CLICK.equals(((PsiMethod)resolved).getName())) {
                this.callsSuper = true;
                return true;
            }
            return false;
        }

        public boolean callsSuper() {
            return this.callsSuper;
        }
    }

    private static class PerformsClickVisitor
    extends AbstractUastVisitor {
        private boolean performsClick;

        public boolean visitCallExpression(UCallExpression node) {
            if (ClickableViewAccessibilityDetector.PERFORM_CLICK.equals(LintUtils.getMethodName((UCallExpression)node)) && node.getValueArgumentCount() == 0) {
                this.performsClick = true;
            }
            return super.visitCallExpression(node);
        }

        public boolean performsClick() {
            return this.performsClick;
        }
    }
}

