/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.TypeEvaluator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastUtils;

public class SecureRandomDetector
extends Detector
implements SourceCodeScanner {
    public static final Issue ISSUE = Issue.create((String)"SecureRandom", (String)"Using a fixed seed with `SecureRandom`", (String)"Specifying a fixed seed will cause the instance to return a predictable sequence of numbers. This may be useful for testing but it is not appropriate for secure use.", (Category)Category.SECURITY, (int)9, (Severity)Severity.WARNING, (Implementation)new Implementation(SecureRandomDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/reference/java/security/SecureRandom.html");
    private static final String SET_SEED = "setSeed";
    public static final String JAVA_SECURITY_SECURE_RANDOM = "java.security.SecureRandom";
    public static final String JAVA_UTIL_RANDOM = "java.util.Random";

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(SET_SEED);
    }

    public void visitMethod(JavaContext context, UCallExpression call, PsiMethod method) {
        List arguments = call.getValueArguments();
        if (arguments.isEmpty()) {
            return;
        }
        UExpression seedArgument = (UExpression)arguments.get(0);
        JavaEvaluator evaluator = context.getEvaluator();
        if (evaluator.isMemberInClass((PsiMember)method, JAVA_SECURITY_SECURE_RANDOM) || evaluator.isMemberInSubClassOf((PsiMember)method, JAVA_UTIL_RANDOM, false) && SecureRandomDetector.isSecureRandomReceiver(context, call)) {
            Object seed = ConstantEvaluator.evaluate((JavaContext)context, (UElement)seedArgument);
            if (seed != null) {
                context.report(ISSUE, (UElement)call, context.getLocation((UElement)call), "Do not call `setSeed()` on a `SecureRandom` with a fixed seed: it is not secure. Use `getSeed()`.");
            } else {
                PsiMethod seedMethod;
                String methodName;
                PsiElement resolvedArgument = UastUtils.tryResolve((UElement)seedArgument);
                if (resolvedArgument instanceof PsiMethod && ((methodName = (seedMethod = (PsiMethod)resolvedArgument).getName()).equals("currentTimeMillis") || methodName.equals("nanoTime"))) {
                    context.report(ISSUE, (UElement)call, context.getLocation((UElement)call), "It is dangerous to seed `SecureRandom` with the current time because that value is more predictable to an attacker than the default seed.");
                }
            }
        }
    }

    private static boolean isSecureRandomReceiver(JavaContext context, UCallExpression call) {
        UExpression operand = call.getReceiver();
        return operand != null && SecureRandomDetector.isSecureRandomType((UElement)operand);
    }

    private static boolean isSecureRandomType(UElement node) {
        PsiType type = TypeEvaluator.evaluate((UElement)node);
        return type != null && JAVA_SECURITY_SECURE_RANDOM.equals(type.getCanonicalText());
    }
}

