/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.cli.DockerComposeRunCliBuilder;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeConfigurationV2;
import com.intellij.docker.compose.service.commands.ServiceCmdExecUtils;
import com.intellij.docker.compose.service.commands.SharedVolume;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.ui.EdtInvocationManager;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J,\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/docker/compose/DockerComposeIntegrationService;", "", "()V", "lock", "processed", "", "Lcom/intellij/docker/compose/DockerComposeIntegrationService$SharedVolumeKey;", "Ljava/util/concurrent/CountDownLatch;", "doPrePopulateSharedVolume", "", "dockerRuntime", "Lcom/intellij/docker/remote/run/runtime/RemoteDockerRuntime;", "configurationPaths", "", "Ljava/nio/file/Path;", "volume", "Lcom/intellij/docker/compose/service/commands/SharedVolume;", "executeCommandLine", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "progressText", "", "prePopulateSharedVolume", "configurationVersion", "Companion", "SharedVolumeKey", "intellij.clouds.docker"})
@ApiStatus.Experimental
public final class DockerComposeIntegrationService {
    private final Object lock = new Object();
    private final Map<SharedVolumeKey, CountDownLatch> processed = new HashMap();
    private static final Logger LOG;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void prePopulateSharedVolume(@NotNull RemoteDockerRuntime dockerRuntime, @NotNull List<? extends Path> configurationPaths, @NotNull String configurationVersion, @NotNull SharedVolume volume) {
        void latch;
        Pair pair;
        Intrinsics.checkParameterIsNotNull((Object)dockerRuntime, (String)"dockerRuntime");
        Intrinsics.checkParameterIsNotNull(configurationPaths, (String)"configurationPaths");
        Intrinsics.checkParameterIsNotNull((Object)configurationVersion, (String)"configurationVersion");
        Intrinsics.checkParameterIsNotNull((Object)volume, (String)"volume");
        DockerComposeConfigurationV2 helpersConfiguration = ServiceCmdExecUtils.setupSharedService(configurationVersion, volume);
        File helpersConfigurationFile = ServiceCmdExecUtils.writeDockerComposeOverrideYml(helpersConfiguration);
        Object object = this.lock;
        synchronized (object) {
            Pair pair2;
            DockerCloudConfiguration dockerCloudConfiguration = dockerRuntime.getAccount();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)dockerCloudConfiguration), (String)"dockerRuntime.account");
            String string = dockerCloudConfiguration.getApiUrl();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dockerRuntime.account.apiUrl");
            SharedVolumeKey key = new SharedVolumeKey(string);
            CountDownLatch latch2 = this.processed.get(key);
            if (latch2 == null) {
                CountDownLatch newLatch = new CountDownLatch(1);
                Map<SharedVolumeKey, CountDownLatch> map = this.processed;
                CountDownLatch countDownLatch = newLatch;
                map.put(key, countDownLatch);
                pair2 = TuplesKt.to((Object)newLatch, (Object)true);
            } else {
                pair2 = TuplesKt.to((Object)latch2, (Object)false);
            }
            pair = pair2;
        }
        Pair pair3 = pair;
        CountDownLatch countDownLatch = (CountDownLatch)pair3.component1();
        boolean startPopulate = (Boolean)pair3.component2();
        if (startPopulate) {
            try {
                this.doPrePopulateSharedVolume(dockerRuntime, CollectionsKt.plus((Collection)configurationPaths, (Iterable)CollectionsKt.listOf((Object)helpersConfigurationFile.toPath())), volume);
            }
            finally {
                latch.countDown();
            }
        } else {
            latch.await();
        }
    }

    private final void doPrePopulateSharedVolume(RemoteDockerRuntime dockerRuntime, List<? extends Path> configurationPaths, SharedVolume volume) {
        LOG.info("Populate shared volume " + volume.getVolumeName());
        GeneralCommandLine commandLine = ((DockerComposeRunCliBuilder)DockerComposeCliUtil.buildRunCommand(dockerRuntime).withFiles(configurationPaths)).withRemove(true).withService(volume.getServiceName()).buildCommandLine();
        String progressText = "Updating " + volume.getVolumeName() + " Volume";
        EdtInvocationManager edtInvocationManager = EdtInvocationManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)edtInvocationManager, (String)"EdtInvocationManager.getInstance()");
        if (edtInvocationManager.isEventDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(this, commandLine, progressText){
                final /* synthetic */ DockerComposeIntegrationService this$0;
                final /* synthetic */ GeneralCommandLine $commandLine;
                final /* synthetic */ String $progressText;

                public final void run() {
                    DockerComposeIntegrationService.access$executeCommandLine(this.this$0, this.$commandLine, this.$progressText);
                }
                {
                    this.this$0 = dockerComposeIntegrationService;
                    this.$commandLine = generalCommandLine;
                    this.$progressText = string;
                }
            }, progressText, true, null);
        } else {
            this.executeCommandLine(commandLine, progressText);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void executeCommandLine(GeneralCommandLine commandLine, String progressText) {
        ProgressIndicator progressIndicator;
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
        ProgressIndicator progressIndicator2 = progressIndicator = progressManager.getProgressIndicator();
        if (progressIndicator2 != null) {
            progressIndicator2.pushState();
        }
        try {
            String commandLineString = commandLine.getCommandLineString();
            ProgressIndicator progressIndicator3 = progressIndicator;
            if (progressIndicator3 != null) {
                progressIndicator3.setText(progressText);
            }
            KillableProcessHandler processHandler = new KillableProcessHandler(commandLine);
            processHandler.startNotify();
            boolean processFinished = processHandler.waitFor();
            if (!processFinished) {
                LOG.warn("Populating shared volume with using command " + commandLineString + " cancelled");
            } else {
                Integer exitCode;
                Integer n = exitCode = processHandler.getExitCode();
                if (n == null || n != 0) {
                    LOG.warn("Populating shared volume with using command " + commandLineString + " returned " + exitCode + " exit code");
                }
            }
        }
        finally {
            ProgressIndicator progressIndicator4 = progressIndicator;
            if (progressIndicator4 != null) {
                progressIndicator4.popState();
            }
        }
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(DockerComposeIntegrationService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Docke\u2026ationService::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$executeCommandLine(DockerComposeIntegrationService $this, @NotNull GeneralCommandLine commandLine, @NotNull String progressText) {
        $this.executeCommandLine(commandLine, progressText);
    }

    @JvmStatic
    @NotNull
    public static final DockerComposeIntegrationService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/intellij/docker/compose/DockerComposeIntegrationService$SharedVolumeKey;", "", "account", "", "(Ljava/lang/String;)V", "getAccount", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.clouds.docker"})
    private static final class SharedVolumeKey {
        @NotNull
        private final String account;

        @NotNull
        public final String getAccount() {
            return this.account;
        }

        public SharedVolumeKey(@NotNull String account) {
            Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
            this.account = account;
        }

        @NotNull
        public final String component1() {
            return this.account;
        }

        @NotNull
        public final SharedVolumeKey copy(@NotNull String account) {
            Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
            return new SharedVolumeKey(account);
        }

        @NotNull
        public static /* synthetic */ SharedVolumeKey copy$default(SharedVolumeKey sharedVolumeKey, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = sharedVolumeKey.account;
            }
            return sharedVolumeKey.copy(string);
        }

        @NotNull
        public String toString() {
            return "SharedVolumeKey(account=" + this.account + ")";
        }

        public int hashCode() {
            String string = this.account;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SharedVolumeKey)) break block3;
                    SharedVolumeKey sharedVolumeKey = (SharedVolumeKey)object;
                    if (!Intrinsics.areEqual((Object)this.account, (Object)sharedVolumeKey.account)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/docker/compose/DockerComposeIntegrationService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/docker/compose/DockerComposeIntegrationService;", "intellij.clouds.docker"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final DockerComposeIntegrationService getInstance() {
            Object object = ServiceManager.getService(DockerComposeIntegrationService.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
            return (DockerComposeIntegrationService)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

