/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.libraries.versions;

import com.intellij.facet.frameworks.LibrariesDownloadAssistant;
import com.intellij.facet.frameworks.beans.Artifact;
import com.intellij.facet.ui.libraries.FacetLibrariesValidator;
import com.intellij.facet.ui.libraries.FacetLibrariesValidatorDescription;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.libraries.JarVersionDetectionUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VersionsComponent {
    private JPanel myMainPanel;
    private static final String UNKNOWN_RI_NAME = "Unknown";
    @NotNull
    private final Module myModule;
    private final FacetLibrariesValidator myValidator;
    private final ButtonGroup myButtonGroup;
    private final Map<String, Pair<JRadioButton, JComboBox>> myButtons;
    private Artifact myCurrentVersion;

    public VersionsComponent(@NotNull Module module, FacetLibrariesValidator validator2) {
        if (module == null) {
            VersionsComponent.$$$reportNull$$$0(0);
        }
        this.myButtonGroup = new ButtonGroup();
        this.myButtons = new HashMap();
        this.myCurrentVersion = null;
        this.myModule = module;
        this.myValidator = validator2;
    }

    public JPanel getJComponent() {
        if (this.myMainPanel == null) {
            this.init();
        }
        return this.myMainPanel;
    }

    @Nullable
    public Artifact getCurrentVersion() {
        return this.myCurrentVersion;
    }

    private void init() {
        this.myMainPanel = new JPanel(new GridBagLayout());
        Set<String> referenceImplementations = this.getRIs();
        if (referenceImplementations.size() == 1) {
            String ri = referenceImplementations.iterator().next();
            this.addSingletonReferenceImplementationUI(ri);
        } else {
            Pair<JRadioButton, JComboBox> currentPair;
            for (String ri : referenceImplementations) {
                this.addMultipleReferenceImplementationUI(ri);
                if (this.myCurrentVersion != null) continue;
                this.myCurrentVersion = this.getCurrentVersion(ri);
            }
            if (this.myCurrentVersion != null && (currentPair = this.myButtons.get(this.myCurrentVersion.getName())) != null) {
                ((JRadioButton)currentPair.first).setSelected(true);
                ((JComboBox)currentPair.second).setSelectedItem(this.myCurrentVersion);
                for (Pair<JRadioButton, JComboBox> buttonsPair : this.myButtons.values()) {
                    ((JComboBox)buttonsPair.second).setEnabled(buttonsPair == currentPair);
                }
            }
        }
    }

    @Nullable
    protected String getFacetDetectionClass(@NotNull String currentRI) {
        if (currentRI == null) {
            VersionsComponent.$$$reportNull$$$0(1);
        }
        return null;
    }

    @NotNull
    protected abstract Artifact[] getLibraries();

    @Nullable
    private Artifact getCurrentVersion(@NotNull String currentRI) {
        String version;
        String detectionClass;
        if (currentRI == null) {
            VersionsComponent.$$$reportNull$$$0(2);
        }
        if ((detectionClass = this.getFacetDetectionClass(currentRI)) != null && (version = JarVersionDetectionUtil.detectJarVersion(detectionClass, this.myModule)) != null) {
            Artifact approximatedVersion = null;
            for (Artifact info : this.getLibraries()) {
                if (version.equals(info.getVersion())) {
                    return info;
                }
                if (!version.contains(info.getVersion())) continue;
                approximatedVersion = info;
            }
            return approximatedVersion;
        }
        return null;
    }

    private List<Artifact> getSupportedVersions(@NotNull String ri) {
        if (ri == null) {
            VersionsComponent.$$$reportNull$$$0(3);
        }
        ArrayList<Artifact> versions = new ArrayList<Artifact>();
        for (Artifact version : this.getLibraries()) {
            if (!ri.equals(version.getName())) continue;
            versions.add(version);
        }
        return versions;
    }

    private void addSingletonReferenceImplementationUI(@NotNull String ri) {
        if (ri == null) {
            VersionsComponent.$$$reportNull$$$0(4);
        }
        JComboBox comboBox = this.createComboBox(ri);
        this.addToPanel(new JLabel(ri), comboBox);
        Artifact version = this.getCurrentVersion(ri);
        if (version != null) {
            comboBox.setSelectedItem(version);
        }
    }

    private void addMultipleReferenceImplementationUI(@NotNull String ri) {
        if (ri == null) {
            VersionsComponent.$$$reportNull$$$0(5);
        }
        JRadioButton radioButton = this.createRadioButton(ri);
        JComboBox comboBox = this.createComboBox(ri);
        comboBox.setEnabled(false);
        this.addToPanel(radioButton, comboBox);
        this.myButtons.put(ri, (Pair<JRadioButton, JComboBox>)Pair.create((Object)radioButton, (Object)comboBox));
        this.myButtonGroup.add(radioButton);
    }

    private void addToPanel(@NotNull JComponent first, @NotNull JComponent second) {
        if (first == null) {
            VersionsComponent.$$$reportNull$$$0(6);
        }
        if (second == null) {
            VersionsComponent.$$$reportNull$$$0(7);
        }
        this.myMainPanel.add((Component)first, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 21, 1, (Insets)JBUI.insets((int)2), 0, 0));
        this.myMainPanel.add((Component)second, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 22, 1, (Insets)JBUI.insets((int)2), 0, 0));
    }

    private JRadioButton createRadioButton(final String ri) {
        final JRadioButton radioButton = new JRadioButton(ri);
        radioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (Pair pair : VersionsComponent.this.myButtons.values()) {
                    if (((JRadioButton)pair.getFirst()).equals(radioButton)) {
                        JComboBox comboBox = (JComboBox)pair.second;
                        comboBox.setEnabled(true);
                        Artifact currentVersion = VersionsComponent.this.getCurrentVersion(ri);
                        if (currentVersion != null) {
                            comboBox.setSelectedItem(currentVersion);
                            continue;
                        }
                        if (comboBox.getSelectedIndex() < 0) {
                            comboBox.setSelectedItem(VersionsComponent.getAppropriateVersion(VersionsComponent.this.getSupportedVersions(ri)));
                            continue;
                        }
                        VersionsComponent.this.updateCurrentVersion(comboBox);
                        continue;
                    }
                    ((JComboBox)pair.second).setEnabled(false);
                }
            }
        });
        return radioButton;
    }

    private JComboBox createComboBox(String ri) {
        final JComboBox comboBox = new JComboBox();
        List<Artifact> versions = this.getSupportedVersions(ri);
        comboBox.setModel(new CollectionComboBoxModel(versions, null));
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersionsComponent.this.updateCurrentVersion(comboBox);
            }
        });
        return comboBox;
    }

    private void updateCurrentVersion(JComboBox comboBox) {
        Artifact versionInfo = VersionsComponent.getSelectedVersion(comboBox);
        if (versionInfo != null) {
            this.myCurrentVersion = versionInfo;
            this.myValidator.setDescription(this.getFacetLibrariesValidatorDescription(versionInfo));
            this.myValidator.setRequiredLibraries(VersionsComponent.getRequiredLibraries(versionInfo));
        }
    }

    protected FacetLibrariesValidatorDescription getFacetLibrariesValidatorDescription(Artifact version) {
        return new FacetLibrariesValidatorDescription(version.getVersion()){

            @Override
            @NonNls
            public String getDefaultLibraryName() {
                if (VersionsComponent.this.myCurrentVersion != null) {
                    String ri = VersionsComponent.this.myCurrentVersion.getName();
                    String version = VersionsComponent.this.myCurrentVersion.getVersion();
                    return StringUtil.isEmptyOrSpaces((String)ri) ? version : ri + "." + version;
                }
                return super.getDefaultLibraryName();
            }
        };
    }

    @Nullable
    private static Artifact getAppropriateVersion(List<Artifact> versions) {
        return versions.size() > 0 ? versions.get(0) : null;
    }

    private static LibraryInfo[] getRequiredLibraries(Artifact version) {
        LibraryInfo[] infos = LibrariesDownloadAssistant.getLibraryInfos((Artifact)version);
        return infos == null ? LibraryInfo.EMPTY_ARRAY : infos;
    }

    @Nullable
    private static Artifact getSelectedVersion(@NotNull JComboBox comboBox) {
        Object version;
        if (comboBox == null) {
            VersionsComponent.$$$reportNull$$$0(8);
        }
        return (version = comboBox.getModel().getSelectedItem()) instanceof Artifact ? (Artifact)version : null;
    }

    public FacetLibrariesValidator getValidator() {
        return this.myValidator;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            VersionsComponent.$$$reportNull$$$0(9);
        }
        return module;
    }

    public Set<String> getRIs() {
        HashSet<String> ris = new HashSet<String>();
        for (Artifact version : this.getLibraries()) {
            String ri = version.getName();
            if (!StringUtil.isEmptyOrSpaces((String)ri)) {
                ris.add(ri);
                continue;
            }
            ris.add(UNKNOWN_RI_NAME);
        }
        return ris;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRI";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ri";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/ui/libraries/versions/VersionsComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/ui/libraries/versions/VersionsComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFacetDetectionClass";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentVersion";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSupportedVersions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addSingletonReferenceImplementationUI";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addMultipleReferenceImplementationUI";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addToPanel";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedVersion";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

