/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.library;

import com.intellij.framework.library.DownloadableLibraryDescription;
import com.intellij.framework.library.DownloadableLibraryService;
import com.intellij.framework.library.LibraryVersionProperties;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.JarVersionDetectionUtil;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.LibraryPropertiesEditor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DownloadableLibraryType
extends LibraryType<LibraryVersionProperties> {
    private final Icon myIcon;
    private final String myLibraryCategoryName;
    private final DownloadableLibraryDescription myLibraryDescription;

    protected DownloadableLibraryType(@NotNull String libraryCategoryName, @NotNull String libraryTypeId, @NotNull String groupId, URL ... localUrls) {
        if (libraryCategoryName == null) {
            DownloadableLibraryType.$$$reportNull$$$0(0);
        }
        if (libraryTypeId == null) {
            DownloadableLibraryType.$$$reportNull$$$0(1);
        }
        if (groupId == null) {
            DownloadableLibraryType.$$$reportNull$$$0(2);
        }
        if (localUrls == null) {
            DownloadableLibraryType.$$$reportNull$$$0(3);
        }
        this(libraryCategoryName, libraryTypeId, groupId, (Icon)null, localUrls);
    }

    @Deprecated
    public DownloadableLibraryType(@NotNull String libraryCategoryName, @NotNull String libraryTypeId, @NotNull String groupId, @Nullable Icon icon, URL ... localUrls) {
        if (libraryCategoryName == null) {
            DownloadableLibraryType.$$$reportNull$$$0(4);
        }
        if (libraryTypeId == null) {
            DownloadableLibraryType.$$$reportNull$$$0(5);
        }
        if (groupId == null) {
            DownloadableLibraryType.$$$reportNull$$$0(6);
        }
        if (localUrls == null) {
            DownloadableLibraryType.$$$reportNull$$$0(7);
        }
        super((PersistentLibraryKind)new PersistentLibraryKind<LibraryVersionProperties>(libraryTypeId){

            @NotNull
            public LibraryVersionProperties createDefaultProperties() {
                LibraryVersionProperties libraryVersionProperties = new LibraryVersionProperties();
                if (libraryVersionProperties == null) {
                    1.$$$reportNull$$$0(0);
                }
                return libraryVersionProperties;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/library/DownloadableLibraryType$1", "createDefaultProperties"));
            }
        });
        this.myLibraryCategoryName = libraryCategoryName;
        this.myLibraryDescription = DownloadableLibraryService.getInstance().createLibraryDescription(groupId, localUrls);
        this.myIcon = icon;
    }

    @Nullable
    private static LibraryVersionProperties detectVersion(List<VirtualFile> classesRoots, String detectionClass) {
        if (!LibraryUtil.isClassAvailableInLibrary(classesRoots, (String)detectionClass)) {
            return null;
        }
        String version = JarVersionDetectionUtil.detectJarVersion(detectionClass, classesRoots);
        return new LibraryVersionProperties(version);
    }

    public String getCreateActionName() {
        return null;
    }

    public NewLibraryConfiguration createNewLibrary(@NotNull JComponent parentComponent, @Nullable VirtualFile contextDirectory, @NotNull Project project) {
        if (parentComponent == null) {
            DownloadableLibraryType.$$$reportNull$$$0(8);
        }
        if (project == null) {
            DownloadableLibraryType.$$$reportNull$$$0(9);
        }
        return null;
    }

    @NotNull
    public DownloadableLibraryDescription getLibraryDescription() {
        DownloadableLibraryDescription downloadableLibraryDescription = this.myLibraryDescription;
        if (downloadableLibraryDescription == null) {
            DownloadableLibraryType.$$$reportNull$$$0(10);
        }
        return downloadableLibraryDescription;
    }

    public String getLibraryCategoryName() {
        return this.myLibraryCategoryName;
    }

    public String getDescription(@NotNull LibraryVersionProperties properties) {
        if (properties == null) {
            DownloadableLibraryType.$$$reportNull$$$0(11);
        }
        String versionString = properties.getVersionString();
        return StringUtil.capitalize((String)this.myLibraryCategoryName) + " library" + (versionString != null ? " of version " + versionString : "");
    }

    public LibraryPropertiesEditor createPropertiesEditor(@NotNull LibraryEditorComponent<LibraryVersionProperties> editorComponent) {
        if (editorComponent == null) {
            DownloadableLibraryType.$$$reportNull$$$0(12);
        }
        return DownloadableLibraryService.getInstance().createDownloadableLibraryEditor(this.myLibraryDescription, editorComponent, this);
    }

    @NotNull
    public Icon getLibraryTypeIcon() {
        if (this.myIcon == null) {
            throw PluginManagerCore.createPluginException((String)("'DownloadableLibraryType::getLibraryTypeIcon' isn't overriden or returns 'null' in " + ((Object)((Object)this)).getClass().getName()), null, ((Object)((Object)this)).getClass());
        }
        Icon icon = this.myIcon;
        if (icon == null) {
            DownloadableLibraryType.$$$reportNull$$$0(13);
        }
        return icon;
    }

    @NotNull
    public Icon getIcon(LibraryVersionProperties properties) {
        Icon icon = this.getLibraryTypeIcon();
        if (icon == null) {
            DownloadableLibraryType.$$$reportNull$$$0(14);
        }
        return icon;
    }

    protected abstract String[] getDetectionClassNames();

    public LibraryVersionProperties detect(@NotNull List<VirtualFile> classesRoots) {
        if (classesRoots == null) {
            DownloadableLibraryType.$$$reportNull$$$0(15);
        }
        for (String className : this.getDetectionClassNames()) {
            LibraryVersionProperties versionProperties = DownloadableLibraryType.detectVersion(classesRoots, className);
            if (versionProperties == null) continue;
            return versionProperties;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryCategoryName";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryTypeId";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localUrls";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/framework/library/DownloadableLibraryType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorComponent";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/framework/library/DownloadableLibraryType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryDescription";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryTypeIcon";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createNewLibrary";
                break;
            }
            case 10: 
            case 13: 
            case 14: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createPropertiesEditor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

