/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetFinder;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetRootsProvider;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WrappingVirtualFile;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureSelectInTarget
implements SelectInTarget,
DumbAware {
    public boolean canSelect(SelectInContext context) {
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)context.getProject()).getFileIndex();
        VirtualFile file = context.getVirtualFile();
        if (file instanceof WrappingVirtualFile) {
            Object o = ((WrappingVirtualFile)file).getWrappedObject(context.getProject());
            return o instanceof Facet;
        }
        return fileIndex.isInContent(file) || fileIndex.isInLibraryClasses(file) || fileIndex.isInLibrarySource(file) || StdFileTypes.IDEA_MODULE.equals(file.getFileType()) && ProjectStructureSelectInTarget.findModuleByModuleFile(context.getProject(), file) != null;
    }

    public void selectIn(SelectInContext context, boolean requestFocus) {
        Module module;
        Facet facet;
        Project project = context.getProject();
        VirtualFile file = context.getVirtualFile();
        if (file instanceof WrappingVirtualFile) {
            Object o = ((WrappingVirtualFile)file).getWrappedObject(project);
            facet = o instanceof Facet ? (Facet)o : null;
            module = facet == null ? null : facet.getModule();
        } else {
            Module moduleByIml = file.getFileType().equals(StdFileTypes.IDEA_MODULE) ? ProjectStructureSelectInTarget.findModuleByModuleFile(project, file) : null;
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            module = moduleByIml != null ? moduleByIml : fileIndex.getModuleForFile(file);
            Facet facet2 = facet = fileIndex.isInSourceContent(file) ? null : ProjectStructureSelectInTarget.findFacet(project, file);
        }
        if (module != null || facet != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (facet != null) {
                    ModulesConfigurator.showFacetSettingsDialog(facet, null);
                } else {
                    ProjectSettingsService.getInstance((Project)project).openModuleSettings(module);
                }
            });
            return;
        }
        OrderEntry orderEntry = LibraryUtil.findLibraryEntry((VirtualFile)file, (Project)project);
        if (orderEntry != null) {
            ApplicationManager.getApplication().invokeLater(() -> ProjectSettingsService.getInstance((Project)project).openLibraryOrSdkSettings(orderEntry));
        }
    }

    @Nullable
    private static Module findModuleByModuleFile(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ProjectStructureSelectInTarget.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ProjectStructureSelectInTarget.$$$reportNull$$$0(1);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!ModuleUtilCore.isModuleFile((Module)module, (VirtualFile)file)) continue;
            return module;
        }
        return null;
    }

    @Nullable
    private static Facet findFacet(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ProjectStructureSelectInTarget.$$$reportNull$$$0(2);
        }
        if (file == null) {
            ProjectStructureSelectInTarget.$$$reportNull$$$0(3);
        }
        for (FacetTypeId id : FacetTypeRegistry.getInstance().getFacetTypeIds()) {
            Facet facet;
            if (!ProjectStructureSelectInTarget.hasFacetWithRoots(project, id) || (facet = FacetFinder.getInstance((Project)project).findFacet(file, id)) == null) continue;
            return facet;
        }
        return null;
    }

    private static <F extends Facet> boolean hasFacetWithRoots(@NotNull Project project, @NotNull FacetTypeId<F> id) {
        if (project == null) {
            ProjectStructureSelectInTarget.$$$reportNull$$$0(4);
        }
        if (id == null) {
            ProjectStructureSelectInTarget.$$$reportNull$$$0(5);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            Collection facets = FacetManager.getInstance((Module)module).getFacetsByType(id);
            Iterator iterator = facets.iterator();
            if (!iterator.hasNext()) continue;
            return iterator.next() instanceof FacetRootsProvider;
        }
        return false;
    }

    public String toString() {
        return IdeBundle.message((String)"select.in.project.settings", (Object[])new Object[0]);
    }

    public float getWeight() {
        return 10.0f;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/impl/ProjectStructureSelectInTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findModuleByModuleFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findFacet";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "hasFacetWithRoots";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

