/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.ide.util.projectWizard.AbstractModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StepSequence {
    private final List<ModuleWizardStep> myCommonSteps;
    private final List<Pair<ModuleWizardStep, Set<String>>> myCommonFinishingSteps = new ArrayList<Pair<ModuleWizardStep, Set<String>>>();
    private final MultiMap<String, ModuleWizardStep> mySpecificSteps = new MultiMap();
    private final MultiMap<String, ModuleWizardStep> mySpecificFinishingSteps = new MultiMap();
    @NonNls
    private final List<String> myTypes = new ArrayList<String>();
    private List<ModuleWizardStep> mySelectedSteps;

    public StepSequence(ModuleWizardStep ... commonSteps) {
        this.myCommonSteps = new SmartList((Object[])commonSteps);
    }

    public void addCommonStep(@NotNull ModuleWizardStep step) {
        if (step == null) {
            StepSequence.$$$reportNull$$$0(0);
        }
        this.myCommonSteps.add(step);
    }

    public void addCommonFinishingStep(@NotNull ModuleWizardStep step, @Nullable Set<String> suitableTypes) {
        if (step == null) {
            StepSequence.$$$reportNull$$$0(1);
        }
        this.myCommonFinishingSteps.add((Pair<ModuleWizardStep, Set<String>>)Pair.create((Object)step, suitableTypes));
    }

    public void addStepsForBuilder(@NotNull AbstractModuleBuilder builder, @NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        String id;
        if (builder == null) {
            StepSequence.$$$reportNull$$$0(2);
        }
        if (wizardContext == null) {
            StepSequence.$$$reportNull$$$0(3);
        }
        if (modulesProvider == null) {
            StepSequence.$$$reportNull$$$0(4);
        }
        if (!this.mySpecificSteps.containsKey((Object)(id = builder.getBuilderId()))) {
            this.mySpecificSteps.put((Object)id, Arrays.asList(builder.createWizardSteps(wizardContext, modulesProvider)));
        }
        if (!this.mySpecificFinishingSteps.containsKey((Object)id)) {
            this.mySpecificFinishingSteps.put((Object)id, Arrays.asList(builder.createFinishingSteps(wizardContext, modulesProvider)));
        }
    }

    public void addSpecificStep(String type, ModuleWizardStep step) {
        this.mySpecificSteps.putValue((Object)type, (Object)step);
    }

    public List<ModuleWizardStep> getSelectedSteps() {
        if (this.mySelectedSteps == null) {
            Collection steps;
            this.mySelectedSteps = new ArrayList<ModuleWizardStep>();
            this.mySelectedSteps.addAll(this.myCommonSteps);
            for (String string : this.myTypes) {
                steps = this.mySpecificSteps.get((Object)string);
                this.mySelectedSteps.addAll(steps);
            }
            for (Pair pair : this.myCommonFinishingSteps) {
                Set types = (Set)pair.getSecond();
                if (types != null && !ContainerUtil.intersects(this.myTypes, (Collection)types)) continue;
                this.mySelectedSteps.add((ModuleWizardStep)pair.getFirst());
            }
            for (String string : this.myTypes) {
                steps = this.mySpecificFinishingSteps.get((Object)string);
                this.mySelectedSteps.addAll(steps);
            }
            ContainerUtil.removeDuplicates(this.mySelectedSteps);
        }
        return this.mySelectedSteps;
    }

    @Nullable
    public ModuleWizardStep getNextStep(ModuleWizardStep step) {
        List<ModuleWizardStep> steps = this.getSelectedSteps();
        int i = steps.indexOf(step);
        return i < steps.size() - 1 ? steps.get(i + 1) : null;
    }

    @Nullable
    public ModuleWizardStep getPreviousStep(ModuleWizardStep step) {
        List<ModuleWizardStep> steps = this.getSelectedSteps();
        int i = steps.indexOf(step);
        return i > 0 ? steps.get(i - 1) : null;
    }

    public void setTypes(Collection<String> types) {
        this.myTypes.clear();
        this.myTypes.addAll(types);
        this.mySelectedSteps = null;
    }

    public void setType(@Nullable @NonNls String type) {
        this.setTypes(Collections.singletonList(type == null ? ModuleType.EMPTY.getId() : type));
    }

    public String getSelectedType() {
        return (String)ContainerUtil.getFirstItem(this.myTypes);
    }

    public List<ModuleWizardStep> getAllSteps() {
        ArrayList<ModuleWizardStep> result = new ArrayList<ModuleWizardStep>();
        result.addAll(this.myCommonSteps);
        result.addAll(this.mySpecificSteps.values());
        for (Pair<ModuleWizardStep, Set<String>> pair : this.myCommonFinishingSteps) {
            result.add((ModuleWizardStep)pair.getFirst());
        }
        result.addAll(this.mySpecificFinishingSteps.values());
        ContainerUtil.removeDuplicates(result);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizardContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesProvider";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/util/newProjectWizard/StepSequence";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCommonStep";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addCommonFinishingStep";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addStepsForBuilder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

