/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard.importSources;

import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.ide.util.projectWizard.importSources.util.CommonSourceRootDetectionUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.NullableFunction;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JavaSourceRootDetector
extends ProjectStructureDetector {
    @Override
    @NotNull
    public ProjectStructureDetector.DirectoryProcessingResult detectRoots(@NotNull File dir, @NotNull File[] children, @NotNull File base, @NotNull List<DetectedProjectRoot> result) {
        if (dir == null) {
            JavaSourceRootDetector.$$$reportNull$$$0(0);
        }
        if (children == null) {
            JavaSourceRootDetector.$$$reportNull$$$0(1);
        }
        if (base == null) {
            JavaSourceRootDetector.$$$reportNull$$$0(2);
        }
        if (result == null) {
            JavaSourceRootDetector.$$$reportNull$$$0(3);
        }
        if (dir.getName().equals("node_modules")) {
            ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.SKIP_CHILDREN;
            if (directoryProcessingResult == null) {
                JavaSourceRootDetector.$$$reportNull$$$0(4);
            }
            return directoryProcessingResult;
        }
        String fileExtension = this.getFileExtension();
        if ("java".equals(fileExtension)) {
            for (File child : children) {
                if (!child.isFile() || !"module-info.java".equals(child.getName())) continue;
                JavaModuleSourceRoot sourceRoot = new JavaModuleSourceRoot(dir, this.getLanguageName(), true);
                result.add(sourceRoot);
                ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.SKIP_CHILDREN;
                if (directoryProcessingResult == null) {
                    JavaSourceRootDetector.$$$reportNull$$$0(5);
                }
                return directoryProcessingResult;
            }
        }
        for (File child : children) {
            if (!child.isFile() || !FileUtilRt.extensionEquals((String)child.getName(), (String)fileExtension)) continue;
            Pair<File, String> root = CommonSourceRootDetectionUtil.IO_FILE.suggestRootForFileWithPackageStatement(child, base, this.getPackageNameFetcher(), true);
            if (root != null) {
                JavaModuleSourceRoot sourceRoot = new JavaModuleSourceRoot((File)root.getFirst(), (String)root.getSecond(), this.getLanguageName());
                result.add(sourceRoot);
                if (JavaSourceRootDetector.areLastRootsTheSame(result, sourceRoot, 20)) {
                    ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.skipChildrenAndParentsUpTo((File)root.getFirst());
                    if (directoryProcessingResult == null) {
                        JavaSourceRootDetector.$$$reportNull$$$0(6);
                    }
                    return directoryProcessingResult;
                }
            }
            ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.SKIP_CHILDREN;
            if (directoryProcessingResult == null) {
                JavaSourceRootDetector.$$$reportNull$$$0(7);
            }
            return directoryProcessingResult;
        }
        ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.PROCESS_CHILDREN;
        if (directoryProcessingResult == null) {
            JavaSourceRootDetector.$$$reportNull$$$0(8);
        }
        return directoryProcessingResult;
    }

    private static boolean areLastRootsTheSame(List<DetectedProjectRoot> result, JavaModuleSourceRoot root, int threshold) {
        if (result.size() < threshold) {
            return false;
        }
        List<DetectedProjectRoot> lastItems = result.subList(result.size() - threshold, result.size());
        for (DetectedProjectRoot item : lastItems) {
            if (!(item instanceof JavaModuleSourceRoot)) {
                return false;
            }
            JavaModuleSourceRoot oldRoot = (JavaModuleSourceRoot)item;
            if (FileUtil.filesEqual((File)oldRoot.getDirectory(), (File)root.getDirectory()) && oldRoot.getPackagePrefix().equals(root.getPackagePrefix()) && oldRoot.getRootTypeName().equals(root.getRootTypeName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getDetectorId() {
        return "Java";
    }

    @NotNull
    protected abstract String getLanguageName();

    @NotNull
    protected abstract String getFileExtension();

    @NotNull
    protected abstract NullableFunction<CharSequence, String> getPackageNameFetcher();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/projectWizard/importSources/JavaSourceRootDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/projectWizard/importSources/JavaSourceRootDetector";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "detectRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectRoots";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

