/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RepositoryAttachDialog
extends DialogWrapper {
    @NonNls
    private static final String PROPERTY_DOWNLOAD_TO_PATH = "Downloaded.Files.Path";
    @NonNls
    private static final String PROPERTY_DOWNLOAD_TO_PATH_ENABLED = "Downloaded.Files.Path.Enabled";
    @NonNls
    private static final String PROPERTY_ATTACH_JAVADOC = "Repository.Attach.JavaDocs";
    @NonNls
    private static final String PROPERTY_ATTACH_SOURCES = "Repository.Attach.Sources";
    @NonNls
    private static final String PROPERTY_ATTACH_ANNOTATIONS = "Repository.Attach.Annotations";
    @NotNull
    private final Mode myMode;
    private final Project myProject;
    private JBLabel myInfoLabel;
    private JCheckBox myJavaDocCheckBox;
    private JCheckBox mySourcesCheckBox;
    private AsyncProcessIcon myProgressIcon;
    private ComboboxWithBrowseButton myComboComponent;
    private JPanel myPanel;
    private TextFieldWithBrowseButton myDirectoryField;
    private JBCheckBox myDownloadToCheckBox;
    private JBLabel myCaptionLabel;
    private JPanel myDownloadOptionsPanel;
    private JBCheckBox myIncludeTransitiveDepsCheckBox;
    private JPanel mySearchOptionsPanel;
    private JBCheckBox myIncludeTransitiveDependenciesForSearchCheckBox;
    private JBCheckBox myAnnotationsCheckBox;
    private final JComboBox myCombobox;
    private final Map<String, RepositoryArtifactDescription> myCoordinates;
    private final List<String> myShownItems;
    private final String myDefaultDownloadFolder;
    private String myFilterString;
    private boolean myInUpdate;

    public RepositoryAttachDialog(@NotNull Project project, @Nullable String initialFilter, @NotNull Mode mode) {
        if (project == null) {
            RepositoryAttachDialog.$$$reportNull$$$0(0);
        }
        if (mode == null) {
            RepositoryAttachDialog.$$$reportNull$$$0(1);
        }
        super(project, true);
        this.$$$setupUI$$$();
        this.myCoordinates = ContainerUtil.newTroveMap();
        this.myShownItems = ContainerUtil.newArrayList();
        this.myMode = mode;
        this.setTitle(mode == Mode.DOWNLOAD ? "Download Library from Maven Repository" : "Search Library in Maven Repositories");
        this.myProject = project;
        this.myProgressIcon.suspend();
        this.myCaptionLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)StringUtil.escapeXml((String)"keyword or class name to search by or exact Maven coordinates, i.e. 'spring', 'Logger' or 'ant:ant-junit:1.6.5'")));
        this.myInfoLabel.setPreferredSize(new Dimension(this.myInfoLabel.getFontMetrics(this.myInfoLabel.getFont()).stringWidth("Showing: 1000"), this.myInfoLabel.getPreferredSize().height));
        this.myComboComponent.setButtonIcon(AllIcons.Actions.Find);
        this.myComboComponent.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoryAttachDialog.this.performSearch();
            }
        });
        this.myCombobox = this.myComboComponent.getComboBox();
        this.myCombobox.setModel(new CollectionComboBoxModel(this.myShownItems, null));
        this.myCombobox.setEditable(true);
        final JTextField textField = (JTextField)this.myCombobox.getEditor().getEditorComponent();
        textField.setColumns(20);
        if (initialFilter != null) {
            textField.setText(initialFilter);
        }
        textField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (e == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (RepositoryAttachDialog.this.myProgressIcon.isDisposed()) {
                        return;
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (e == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        if (RepositoryAttachDialog.this.myProgressIcon.isDisposed()) {
                            return;
                        }
                        RepositoryAttachDialog.handleMavenDependencyInsertion(e, textField);
                        RepositoryAttachDialog.this.updateComboboxSelection(false);
                    });
                    RepositoryAttachDialog.this.updateComboboxSelection(false);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/jarRepository/RepositoryAttachDialog$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "textChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$textChanged$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$null$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean popupVisible = RepositoryAttachDialog.this.myCombobox.isPopupVisible();
                if (!(RepositoryAttachDialog.this.myInUpdate || popupVisible && !RepositoryAttachDialog.this.myCoordinates.isEmpty())) {
                    RepositoryAttachDialog.this.performSearch();
                } else {
                    String item = (String)RepositoryAttachDialog.this.myCombobox.getSelectedItem();
                    if (StringUtil.isNotEmpty((String)item)) {
                        ((JTextField)RepositoryAttachDialog.this.myCombobox.getEditor().getEditorComponent()).setText(item);
                    }
                }
            }
        });
        VirtualFile baseDir = !this.myProject.isDefault() ? this.myProject.getBaseDir() : null;
        this.myDefaultDownloadFolder = baseDir != null ? FileUtil.toSystemDependentName((String)(baseDir.getPath() + "/lib")) : "";
        PropertiesComponent storage = PropertiesComponent.getInstance((Project)this.myProject);
        this.myDownloadToCheckBox.setSelected(storage.isTrueValue(PROPERTY_DOWNLOAD_TO_PATH_ENABLED));
        this.myDirectoryField.setText(StringUtil.notNullize((String)StringUtil.nullize((String)storage.getValue(PROPERTY_DOWNLOAD_TO_PATH)), (String)this.myDefaultDownloadFolder));
        this.myDirectoryField.setEnabled(this.myDownloadToCheckBox.isSelected());
        this.myDownloadToCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoryAttachDialog.this.myDirectoryField.setEnabled(RepositoryAttachDialog.this.myDownloadToCheckBox.isSelected());
            }
        });
        this.myJavaDocCheckBox.setSelected(storage.isTrueValue(PROPERTY_ATTACH_JAVADOC));
        this.mySourcesCheckBox.setSelected(storage.isTrueValue(PROPERTY_ATTACH_SOURCES));
        this.mySourcesCheckBox.setSelected(storage.isTrueValue(PROPERTY_ATTACH_ANNOTATIONS));
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.putUserData(FileChooserDialog.PREFER_LAST_OVER_TO_SELECT, (Object)Boolean.TRUE);
        this.myDirectoryField.addBrowseFolderListener(ProjectBundle.message((String)"file.chooser.directory.for.downloaded.libraries.title", (Object[])new Object[0]), ProjectBundle.message((String)"file.chooser.directory.for.downloaded.libraries.description", (Object[])new Object[0]), null, descriptor);
        this.updateInfoLabel();
        this.myDownloadOptionsPanel.setVisible(mode == Mode.DOWNLOAD);
        this.mySearchOptionsPanel.setVisible(mode == Mode.SEARCH);
        this.init();
    }

    private static void handleMavenDependencyInsertion(DocumentEvent e, JTextField textField) {
        String text;
        if (e.getType() == DocumentEvent.EventType.INSERT && RepositoryAttachDialog.isMvnDependency(text = textField.getText())) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                try {
                    Document document = builder.parse(new InputSource(new StringReader(text)));
                    String mavenCoordinates = RepositoryAttachDialog.extractMavenCoordinates(document);
                    if (mavenCoordinates != null) {
                        textField.setText(mavenCoordinates);
                    }
                }
                catch (IOException | SAXException exception) {}
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
        }
    }

    public boolean getAttachJavaDoc() {
        return this.myJavaDocCheckBox.isSelected();
    }

    public boolean getAttachSources() {
        return this.mySourcesCheckBox.isSelected();
    }

    public boolean getAttachExternalAnnotations() {
        return this.myAnnotationsCheckBox.isSelected();
    }

    public boolean getIncludeTransitiveDependencies() {
        return this.myMode == Mode.DOWNLOAD ? this.myIncludeTransitiveDepsCheckBox.isSelected() : this.myIncludeTransitiveDependenciesForSearchCheckBox.isSelected();
    }

    @Nullable
    public String getDirectoryPath() {
        return this.myDownloadToCheckBox.isSelected() ? this.myDirectoryField.getText() : null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCombobox;
    }

    private void updateComboboxSelection(boolean force) {
        boolean filtered;
        boolean itemSelected;
        String prevFilter = this.myFilterString;
        JTextComponent field = (JTextComponent)this.myCombobox.getEditor().getEditorComponent();
        int caret = field.getCaretPosition();
        this.myFilterString = field.getText();
        if (!force && Comparing.equal((String)this.myFilterString, (String)prevFilter)) {
            return;
        }
        int prevSize = this.myShownItems.size();
        this.myShownItems.clear();
        this.myInUpdate = true;
        boolean bl = itemSelected = this.myCoordinates.containsKey(this.myFilterString) && Comparing.strEqual((String)((String)this.myCombobox.getSelectedItem()), (String)this.myFilterString, (boolean)false);
        if (itemSelected) {
            this.myShownItems.addAll(this.myCoordinates.keySet());
            filtered = false;
        } else {
            String[] parts = this.myFilterString.split(" ");
            block0: for (String coordinate : this.myCoordinates.keySet()) {
                for (String part : parts) {
                    if (!StringUtil.containsIgnoreCase((String)coordinate, (String)part)) continue block0;
                }
                this.myShownItems.add(coordinate);
            }
            boolean bl2 = filtered = !this.myShownItems.isEmpty();
            if (!filtered) {
                this.myShownItems.addAll(this.myCoordinates.keySet());
            }
            this.myCombobox.setSelectedItem(null);
        }
        ArrayList<LibItem> items = new ArrayList<LibItem>(this.myShownItems.size());
        for (String coord : this.myShownItems) {
            items.add(new LibItem(coord));
        }
        Collections.sort(items, (o1, o2) -> Comparing.compare((Comparable)o1, (Comparable)o2));
        this.myShownItems.clear();
        for (LibItem it : items) {
            this.myShownItems.add(it.coord);
        }
        ((CollectionComboBoxModel)this.myCombobox.getModel()).update();
        this.myInUpdate = false;
        field.setText(this.myFilterString);
        field.setCaretPosition(caret);
        this.updateInfoLabel();
        if (filtered) {
            if (prevSize < 10 && this.myShownItems.size() > prevSize && this.myCombobox.isPopupVisible()) {
                this.myCombobox.setPopupVisible(false);
            }
            if (!this.myCombobox.isPopupVisible()) {
                this.myCombobox.setPopupVisible(true);
            }
        }
    }

    private boolean performSearch() {
        String text = this.getCoordinateText();
        if (this.myProgressIcon.isRunning() || StringUtil.isEmptyOrSpaces((String)text) || this.myCoordinates.containsKey(text)) {
            return false;
        }
        this.myProgressIcon.resume();
        JarRepositoryManager.searchArtifacts(this.myProject, text, pairs -> {
            try {
                if (this.myProgressIcon.isDisposed()) {
                    return;
                }
                this.myProgressIcon.suspend();
                int prevSize = this.myCoordinates.size();
                for (Pair pair : pairs) {
                    RepositoryArtifactDescription artifact = (RepositoryArtifactDescription)pair.first;
                    this.myCoordinates.put(artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion(), artifact);
                }
                this.updateComboboxSelection(prevSize != this.myCoordinates.size());
            }
            finally {
                this.setOKActionEnabled(true);
            }
        });
        return true;
    }

    private void updateInfoLabel() {
        this.myInfoLabel.setText("<html>Found: " + this.myCoordinates.size() + "<br>Showing: " + this.myCombobox.getModel().getSize() + "</html>");
    }

    protected ValidationInfo doValidate() {
        File dir;
        if (!this.isValidCoordinateSelected()) {
            return new ValidationInfo("Please enter valid coordinate, discover it or select one from the list", (JComponent)this.myCombobox);
        }
        if (this.myDownloadToCheckBox.isSelected() && (!(dir = new File(this.myDirectoryField.getText())).exists() && !dir.mkdirs() || !dir.isDirectory())) {
            return new ValidationInfo("Please enter valid library files path", (JComponent)this.myDirectoryField.getTextField());
        }
        return super.doValidate();
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    protected JComponent createNorthPanel() {
        return this.myPanel;
    }

    protected void dispose() {
        Disposer.dispose((Disposable)this.myProgressIcon);
        PropertiesComponent storage = PropertiesComponent.getInstance((Project)this.myProject);
        storage.setValue(PROPERTY_DOWNLOAD_TO_PATH_ENABLED, String.valueOf(this.myDownloadToCheckBox.isSelected()));
        String downloadPath = this.myDirectoryField.getText();
        if (StringUtil.isEmptyOrSpaces((String)downloadPath)) {
            downloadPath = this.myDefaultDownloadFolder;
        }
        storage.setValue(PROPERTY_DOWNLOAD_TO_PATH, downloadPath, this.myDefaultDownloadFolder);
        storage.setValue(PROPERTY_ATTACH_JAVADOC, String.valueOf(this.myJavaDocCheckBox.isSelected()));
        storage.setValue(PROPERTY_ATTACH_SOURCES, String.valueOf(this.mySourcesCheckBox.isSelected()));
        storage.setValue(PROPERTY_ATTACH_ANNOTATIONS, String.valueOf(this.myAnnotationsCheckBox.isSelected()));
        super.dispose();
    }

    protected String getDimensionServiceKey() {
        return RepositoryAttachDialog.class.getName() + "-" + (Object)((Object)this.myMode);
    }

    private boolean isValidCoordinateSelected() {
        String text = this.getCoordinateText();
        return text.split(":").length == 3;
    }

    public String getCoordinateText() {
        JTextField field = (JTextField)this.myCombobox.getEditor().getEditorComponent();
        return field.getText();
    }

    private void createUIComponents() {
        this.myProgressIcon = new AsyncProcessIcon("Progress");
    }

    private static boolean isMvnDependency(String text) {
        String trimmed = text.trim();
        return trimmed.startsWith("<dependency>") && trimmed.endsWith("</dependency>");
    }

    @Nullable
    private static String extractMavenCoordinates(Document document) {
        String groupId = RepositoryAttachDialog.getGroupId(document);
        String artifactId = RepositoryAttachDialog.getArtifactId(document);
        if (groupId.isEmpty() && artifactId.isEmpty()) {
            return null;
        }
        String version = RepositoryAttachDialog.getVersion(document);
        String classifier = RepositoryAttachDialog.getClassifier(document);
        String gradleClassifier = classifier.isEmpty() ? "" : ":" + classifier;
        return groupId + ":" + artifactId + ":" + version + gradleClassifier;
    }

    private static String getVersion(@NotNull Document document) {
        if (document == null) {
            RepositoryAttachDialog.$$$reportNull$$$0(2);
        }
        return RepositoryAttachDialog.firstOrEmpty(document.getElementsByTagName("version"));
    }

    private static String getArtifactId(@NotNull Document document) {
        if (document == null) {
            RepositoryAttachDialog.$$$reportNull$$$0(3);
        }
        return RepositoryAttachDialog.firstOrEmpty(document.getElementsByTagName("artifactId"));
    }

    private static String getGroupId(@NotNull Document document) {
        if (document == null) {
            RepositoryAttachDialog.$$$reportNull$$$0(4);
        }
        return RepositoryAttachDialog.firstOrEmpty(document.getElementsByTagName("groupId"));
    }

    private static String getClassifier(@NotNull Document document) {
        if (document == null) {
            RepositoryAttachDialog.$$$reportNull$$$0(5);
        }
        return RepositoryAttachDialog.firstOrEmpty(document.getElementsByTagName("classifier"));
    }

    private static String firstOrEmpty(@NotNull NodeList list) {
        Node first;
        if (list == null) {
            RepositoryAttachDialog.$$$reportNull$$$0(6);
        }
        return (first = list.item(0)) != null ? first.getTextContent() : "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jarRepository/RepositoryAttachDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getVersion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getArtifactId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getGroupId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getClassifier";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "firstOrEmpty";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JBCheckBox jBCheckBox4;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel2;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        ComboboxWithBrowseButton comboboxWithBrowseButton;
        JPanel jPanel3;
        this.createUIComponents();
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 15, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myComboComponent = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
        jPanel4.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.myProgressIcon;
        jPanel4.add((Component)asyncProcessIcon, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInfoLabel = jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.MINI);
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel2.setText("Info");
        jPanel4.add((Component)jBLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCaptionLabel = jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel.setText("Description");
        jPanel4.add((Component)jBLabel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myDownloadOptionsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 2, 2, 0, 3, 3, 3, null, null, null));
        this.myDirectoryField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText("");
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.mySourcesCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Sources");
        jCheckBox2.setMnemonic('S');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jCheckBox2, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myJavaDocCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("JavaDocs");
        jCheckBox.setMnemonic('D');
        jCheckBox.setDisplayedMnemonicIndex(4);
        jPanel5.add((Component)jCheckBox, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myIncludeTransitiveDepsCheckBox = jBCheckBox4 = new JBCheckBox();
        jBCheckBox4.setSelected(true);
        jBCheckBox4.setText("Transitive dependencies");
        jBCheckBox4.setMnemonic('T');
        jBCheckBox4.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jBCheckBox4, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myAnnotationsCheckBox = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("Annotations");
        jBCheckBox3.setMnemonic('N');
        jBCheckBox3.setDisplayedMnemonicIndex(1);
        jPanel5.add((Component)jBCheckBox3, new GridConstraints(0, 4, 1, 1, 0, 0, 3, 0, null, null, null));
        this.myDownloadToCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Download to:  ");
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.mySearchOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myIncludeTransitiveDependenciesForSearchCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(true);
        jBCheckBox.setText("Include transitive dependencies");
        jBCheckBox.setMnemonic('T');
        jBCheckBox.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static final class LibItem
    implements Comparable<LibItem> {
        final String prefix;
        final Version ver;
        final String coord;

        LibItem(String coord) {
            this.coord = coord;
            JpsMavenRepositoryLibraryDescriptor desc = new JpsMavenRepositoryLibraryDescriptor(coord);
            this.prefix = desc.getGroupId() + ":" + desc.getArtifactId();
            Version ver = null;
            try {
                ver = ArtifactRepositoryManager.asVersion(desc.getVersion());
            }
            catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
                // empty catch block
            }
            this.ver = ver;
        }

        @Override
        public int compareTo(@NotNull LibItem that) {
            int prefixCompare;
            if (that == null) {
                LibItem.$$$reportNull$$$0(0);
            }
            return (prefixCompare = this.prefix.compareTo(that.prefix)) != 0 ? prefixCompare : Comparing.compare((Comparable)that.ver, (Comparable)this.ver);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/jarRepository/RepositoryAttachDialog$LibItem", "compareTo"));
        }
    }

    public static enum Mode {
        SEARCH,
        DOWNLOAD;

    }
}

