/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.jarRepository.settings.RepositoryLibraryPropertiesDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryPropertiesEditorBase;
import java.util.Collection;
import java.util.EnumSet;
import org.jetbrains.idea.maven.aether.ArtifactKind;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryUtils;
import org.jetbrains.idea.maven.utils.library.propertiesEditor.RepositoryLibraryPropertiesModel;

public class RepositoryLibraryWithDescriptionEditor
extends LibraryPropertiesEditorBase<RepositoryLibraryProperties, RepositoryLibraryType> {
    public RepositoryLibraryWithDescriptionEditor(LibraryEditorComponent<RepositoryLibraryProperties> editorComponent) {
        super(editorComponent, RepositoryLibraryType.getInstance(), null);
    }

    public void apply() {
    }

    @Override
    protected void edit() {
        RepositoryLibraryProperties properties = (RepositoryLibraryProperties)this.myEditorComponent.getProperties();
        boolean wasGeneratedName = RepositoryLibraryType.getInstance().getDescription(properties).equals(this.myEditorComponent.getLibraryEditor().getName());
        EnumSet<ArtifactKind> artifactKinds = ArtifactKind.kindsOf(RepositoryUtils.libraryHasSources(this.myEditorComponent.getLibraryEditor()), RepositoryUtils.libraryHasJavaDocs(this.myEditorComponent.getLibraryEditor()));
        if (RepositoryUtils.libraryHasExternalAnnotations(this.myEditorComponent.getLibraryEditor())) {
            artifactKinds.add(ArtifactKind.ANNOTATIONS);
        }
        RepositoryLibraryPropertiesModel model = new RepositoryLibraryPropertiesModel(properties.getVersion(), artifactKinds, properties.isIncludeTransitiveDependencies(), properties.getExcludedDependencies());
        Project project = this.myEditorComponent.getProject();
        assert (project != null) : "EditorComponent's project must not be null in order to be used with RepositoryLibraryWithDescriptionEditor";
        RepositoryLibraryPropertiesDialog dialog = new RepositoryLibraryPropertiesDialog(project, model, RepositoryLibraryDescription.findDescription(properties), true, true);
        if (!dialog.showAndGet()) {
            return;
        }
        ((RepositoryLibraryProperties)this.myEditorComponent.getProperties()).changeVersion(model.getVersion());
        ((RepositoryLibraryProperties)this.myEditorComponent.getProperties()).setIncludeTransitiveDependencies(model.isIncludeTransitiveDependencies());
        ((RepositoryLibraryProperties)this.myEditorComponent.getProperties()).setExcludedDependencies(model.getExcludedDependencies());
        if (wasGeneratedName) {
            this.myEditorComponent.renameLibrary(RepositoryLibraryType.getInstance().getDescription(properties));
        }
        LibraryEditor libraryEditor = this.myEditorComponent.getLibraryEditor();
        String copyTo = RepositoryUtils.getStorageRoot(this.myEditorComponent.getLibraryEditor().getUrls(OrderRootType.CLASSES), project);
        Collection<OrderRoot> roots = JarRepositoryManager.loadDependenciesModal(project, properties.getRepositoryLibraryDescriptor(), model.getArtifactKinds(), null, copyTo);
        libraryEditor.removeAllRoots();
        if (roots != null) {
            libraryEditor.addRoots(roots);
        }
        this.myEditorComponent.updateRootsTree();
        this.updateDescription();
    }
}

