/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.jarRepository.RepositoryAddLibraryAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;

public abstract class RepositoryUnresolvedReferenceQuickFixProvider
extends UnresolvedReferenceQuickFixProvider<PsiJavaCodeReferenceElement> {
    @NotNull
    private static String getFQTypeName(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            RepositoryUnresolvedReferenceQuickFixProvider.$$$reportNull$$$0(0);
        }
        while (ref.getParent() != null && ref.getParent() instanceof PsiJavaCodeReferenceElement) {
            ref = (PsiJavaCodeReferenceElement)ref.getParent();
        }
        String name = ref.getCanonicalText();
        PsiFile file = ref.getContainingFile();
        if (!(file instanceof PsiJavaFile)) {
            String string = name;
            if (string == null) {
                RepositoryUnresolvedReferenceQuickFixProvider.$$$reportNull$$$0(1);
            }
            return string;
        }
        String suffix = "." + name;
        PsiJavaFile javaFile = (PsiJavaFile)file;
        PsiImportList importList = javaFile.getImportList();
        if (importList != null) {
            for (PsiImportStatement importStatement : importList.getImportStatements()) {
                String qualifiedName = importStatement.getQualifiedName();
                if (qualifiedName == null || !qualifiedName.endsWith(suffix) && !qualifiedName.equals(name)) continue;
                String string = qualifiedName;
                if (string == null) {
                    RepositoryUnresolvedReferenceQuickFixProvider.$$$reportNull$$$0(2);
                }
                return string;
            }
        }
        String string = name;
        if (string == null) {
            RepositoryUnresolvedReferenceQuickFixProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected abstract boolean isSuspectedName(@NotNull String var1);

    @NotNull
    protected abstract RepositoryLibraryDescription getLibraryDescription();

    public void registerFixes(@NotNull PsiJavaCodeReferenceElement ref, @NotNull QuickFixActionRegistrar registrar) {
        Module module;
        if (ref == null) {
            RepositoryUnresolvedReferenceQuickFixProvider.$$$reportNull$$$0(4);
        }
        if (registrar == null) {
            RepositoryUnresolvedReferenceQuickFixProvider.$$$reportNull$$$0(5);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)ref)) != null && this.isSuspectedName(RepositoryUnresolvedReferenceQuickFixProvider.getFQTypeName(ref))) {
            registrar.register((IntentionAction)new RepositoryAddLibraryAction(module, this.getLibraryDescription()));
        }
    }

    @NotNull
    public Class<PsiJavaCodeReferenceElement> getReferenceClass() {
        if (PsiJavaCodeReferenceElement.class == null) {
            RepositoryUnresolvedReferenceQuickFixProvider.$$$reportNull$$$0(6);
        }
        return PsiJavaCodeReferenceElement.class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarRepository/RepositoryUnresolvedReferenceQuickFixProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarRepository/RepositoryUnresolvedReferenceQuickFixProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQTypeName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFQTypeName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerFixes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

