/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository.settings;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RemoteRepositoriesConfiguration;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.services.MavenRepositoryServicesManager;
import com.intellij.jarRepository.settings.RepositoryLibrariesReloaderKt;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.ListUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class RemoteRepositoriesConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private JPanel myMainPanel;
    private JBList<String> myServiceList;
    private JButton myAddServiceButton;
    private JButton myEditServiceButton;
    private JButton myRemoveServiceButton;
    private JButton myTestServiceButton;
    private JBList<RemoteRepositoryDescription> myJarRepositoryList;
    private JButton myAddRepoButton;
    private JButton myEditRepoButton;
    private JButton myRemoveRepoButton;
    private JButton myResetToDefaultReposButton;
    private JButton myResetToDefaultServicesButton;
    private final Project myProject;
    private final CollectionListModel<String> myServicesModel;
    private final CollectionListModel<RemoteRepositoryDescription> myReposModel;

    public RemoteRepositoriesConfigurable(Project project) {
        Object[] objectArray = new String[]{};
        this.$$$setupUI$$$();
        this.myServicesModel = new CollectionListModel(objectArray);
        this.myReposModel = new CollectionListModel((Object[])new RemoteRepositoryDescription[0]);
        this.myProject = project;
        this.configControls();
    }

    public boolean isModified() {
        return this.isServiceListModified() || this.isRepoListModified();
    }

    private boolean isServiceListModified() {
        return !this.myServicesModel.getItems().equals(MavenRepositoryServicesManager.getInstance((Project)this.myProject).getUrls());
    }

    private boolean isRepoListModified() {
        List repos = RemoteRepositoriesConfiguration.getInstance((Project)this.myProject).getRepositories();
        return !this.myReposModel.getItems().equals(repos);
    }

    private void configControls() {
        RemoteRepositoriesConfigurable.setupListControls(this.myServiceList, this.myServicesModel, this.myAddServiceButton, this.myEditServiceButton, this.myRemoveServiceButton, "Artifactory, Nexus or Bintray Service URLs", "Service URL", "No services", DataAdapter.STRING_ADAPTER);
        RemoteRepositoriesConfigurable.setupListControls(this.myJarRepositoryList, this.myReposModel, this.myAddRepoButton, this.myEditRepoButton, this.myRemoveRepoButton, "Maven Repository URL", "maven Repository URL", "No remote repositories", DataAdapter.REPOSITORY_DESCRIPTION_ADAPTER);
        ListUtil.disableWhenNoSelection((JButton)this.myTestServiceButton, this.myServiceList);
        this.myTestServiceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String value = (String)RemoteRepositoriesConfigurable.this.myServiceList.getSelectedValue();
                if (!StringUtil.isEmpty((String)value)) {
                    RemoteRepositoriesConfigurable.this.myTestServiceButton.setEnabled(false);
                    JarRepositoryManager.searchRepositories(RemoteRepositoriesConfigurable.this.myProject, Collections.singletonList(value), (Processor<? super Collection<RemoteRepositoryDescription>>)((Processor)infos -> {
                        RemoteRepositoriesConfigurable.this.myTestServiceButton.setEnabled(true);
                        if (infos.isEmpty()) {
                            Messages.showMessageDialog((String)"No repositories found", (String)"Service Connection Failed", (Icon)Messages.getWarningIcon());
                        } else {
                            StringBuilder sb = new StringBuilder();
                            sb.append(infos.size()).append(" ").append(StringUtil.pluralize((String)"repository", (int)infos.size())).append(" found");
                            Messages.showMessageDialog((String)sb.toString(), (String)"Service Connection Successful", (Icon)Messages.getInformationIcon());
                        }
                        return true;
                    }));
                }
            }
        });
        this.myResetToDefaultReposButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteRepositoriesConfigurable.this.resetReposModel(RemoteRepositoryDescription.DEFAULT_REPOSITORIES);
            }
        });
        this.myResetToDefaultServicesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteRepositoriesConfigurable.this.resetServicesModel(MavenRepositoryServicesManager.DEFAULT_SERVICES);
            }
        });
    }

    private static <T> void setupListControls(final JBList<T> list, final CollectionListModel<T> model, JButton addButton, JButton editButton, JButton removeButton, final String modificationDialogTitle, final String modificationDialogHint, String emptyListHint, final DataAdapter<T, String> adapter) {
        list.setModel(model);
        list.setSelectionMode(0);
        list.setCellRenderer((ListCellRenderer)new ListCellRendererWrapper<T>(){

            public void customize(JList list, T value, int index, boolean selected, boolean hasFocus) {
                this.setText((String)adapter.toPresentation(value));
            }
        });
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object value = list.getSelectedValue();
                String text = Messages.showInputDialog((String)modificationDialogTitle, (String)("Add " + modificationDialogHint), (Icon)Messages.getQuestionIcon(), (String)(value == null ? "https://" : (String)adapter.toPresentation(value)), (InputValidator)new URLInputVaslidator());
                if (StringUtil.isNotEmpty((String)text)) {
                    model.add(adapter.create(text));
                    list.setSelectedValue((Object)text, true);
                }
            }
        });
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = list.getSelectedIndex();
                Object element = model.getElementAt(index);
                String text = Messages.showInputDialog((String)modificationDialogTitle, (String)("Edit " + modificationDialogHint), (Icon)Messages.getQuestionIcon(), (String)((String)adapter.toPresentation(element)), (InputValidator)new URLInputVaslidator());
                if (StringUtil.isNotEmpty((String)text)) {
                    model.setElementAt(adapter.change(element, text), index);
                }
            }
        });
        ListUtil.addRemoveListener((JButton)removeButton, list);
        ListUtil.disableWhenNoSelection((JButton)editButton, list);
        list.getEmptyText().setText(emptyListHint);
    }

    public String getDisplayName() {
        return "Remote Jar Repositories";
    }

    public String getHelpTopic() {
        return "reference.jar.repositories";
    }

    @NotNull
    public String getId() {
        String string = this.getClass().getName();
        if (string == null) {
            RemoteRepositoriesConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public void apply() throws ConfigurationException {
        List newUrls = ContainerUtil.map((Collection)this.myReposModel.getItems(), RemoteRepositoryDescription::getUrl);
        List oldUrls = ContainerUtil.map((Collection)RemoteRepositoriesConfiguration.getInstance((Project)this.myProject).getRepositories(), RemoteRepositoryDescription::getUrl);
        MavenRepositoryServicesManager.getInstance((Project)this.myProject).setUrls(this.myServicesModel.getItems());
        RemoteRepositoriesConfiguration.getInstance((Project)this.myProject).setRepositories(this.myReposModel.getItems());
        if (!newUrls.containsAll(oldUrls)) {
            RepositoryLibrariesReloaderKt.reloadAllRepositoryLibraries(this.myProject);
        }
    }

    public void reset() {
        this.resetServicesModel(MavenRepositoryServicesManager.getInstance((Project)this.myProject).getUrls());
        this.resetReposModel(RemoteRepositoriesConfiguration.getInstance((Project)this.myProject).getRepositories());
    }

    private void resetServicesModel(List<String> urls) {
        this.myServicesModel.removeAll();
        this.myServicesModel.add(urls);
    }

    private void resetReposModel(List<RemoteRepositoryDescription> repositories) {
        this.myReposModel.replaceAll(repositories);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/settings/RemoteRepositoriesConfigurable", "getId"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JBList jBList;
        JButton jButton6;
        JButton jButton7;
        JButton jButton8;
        JButton jButton9;
        JBList jBList2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Maven Jar Repositories", (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myJarRepositoryList = jBList2 = new JBList();
        jBScrollPane.setViewportView((Component)jBList2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAddRepoButton = jButton9 = new JButton();
        jButton9.setFocusable(false);
        jButton9.setText("Add");
        jButton9.setMnemonic('D');
        jButton9.setDisplayedMnemonicIndex(1);
        jPanel3.add((Component)jButton9, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myEditRepoButton = jButton8 = new JButton();
        jButton8.setText("Edit");
        jPanel3.add((Component)jButton8, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRemoveRepoButton = jButton7 = new JButton();
        jButton7.setText("Remove");
        jPanel3.add((Component)jButton7, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myResetToDefaultReposButton = jButton6 = new JButton();
        jButton6.setText("Reset Defaults");
        jPanel3.add((Component)jButton6, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Artifactory, Nexus or Bintray Service URLs:", (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel4.add((Component)jBScrollPane2, new GridConstraints(0, 0, 1, 1, 0, 3, 4, 0, null, new Dimension(406, 128), null));
        this.myServiceList = jBList = new JBList();
        jBList.setLayoutOrientation(0);
        jBScrollPane2.setViewportView((Component)jBList);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 4, 2, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAddServiceButton = jButton5 = new JButton();
        jButton5.setFocusable(false);
        jButton5.setText("Add");
        jButton5.setMnemonic('A');
        jButton5.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jButton5, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRemoveServiceButton = jButton4 = new JButton();
        jButton4.setText("Remove");
        jButton4.setMnemonic('R');
        jButton4.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jButton4, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myTestServiceButton = jButton3 = new JButton();
        jButton3.setText("Test");
        jButton3.setMnemonic('T');
        jButton3.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jButton3, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myEditServiceButton = jButton2 = new JButton();
        jButton2.setText("Edit");
        jButton2.setMnemonic('E');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jButton2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myResetToDefaultServicesButton = jButton = new JButton();
        jButton.setText("Reset Defaults");
        jPanel5.add((Component)jButton, new GridConstraints(5, 0, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static final class URLInputVaslidator
    implements InputValidator {
        private URLInputVaslidator() {
        }

        public boolean checkInput(String inputString) {
            try {
                return StringUtil.isNotEmpty((String)new URL(inputString).getHost());
            }
            catch (MalformedURLException e) {
                return false;
            }
        }

        public boolean canClose(String inputString) {
            return this.checkInput(inputString);
        }
    }

    private static interface DataAdapter<Data, Presentation> {
        public static final DataAdapter<String, String> STRING_ADAPTER = new DataAdapter<String, String>(){

            @Override
            public String toPresentation(String s) {
                return s;
            }

            @Override
            public String create(String s) {
                return s;
            }

            @Override
            public String change(String current, String changes) {
                return changes;
            }
        };
        public static final DataAdapter<RemoteRepositoryDescription, String> REPOSITORY_DESCRIPTION_ADAPTER = new DataAdapter<RemoteRepositoryDescription, String>(){

            @Override
            public String toPresentation(RemoteRepositoryDescription description) {
                return description.getUrl();
            }

            @Override
            public RemoteRepositoryDescription create(String url) {
                UUID uuid = UUID.randomUUID();
                return new RemoteRepositoryDescription(uuid.toString(), uuid.toString(), url);
            }

            @Override
            public RemoteRepositoryDescription change(RemoteRepositoryDescription current, String url) {
                return new RemoteRepositoryDescription(current.getId(), current.getName(), url);
            }
        };

        public Presentation toPresentation(Data var1);

        public Data create(Presentation var1);

        public Data change(Data var1, Presentation var2);
    }
}

