/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.execution;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.xmlb.annotations.Tag;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="ExternalSystemSettings")
public class ExternalSystemTaskExecutionSettings
implements Cloneable {
    @NotNull
    @NonNls
    public static final String TAG_NAME = "ExternalSystemSettings";
    @NotNull
    @NonNls
    public static final Key<ParametersList> JVM_AGENT_SETUP_KEY = Key.create((String)"jvmAgentSetup");
    @NotNull
    private List<String> myTaskNames;
    @NotNull
    private List<String> myTaskDescriptions;
    @Nullable
    private String myExecutionName;
    private String myExternalSystemIdString;
    private String myExternalProjectPath;
    private String myVmOptions;
    private String myScriptParameters;
    @NotNull
    private Map<String, String> myEnv;
    private boolean myPassParentEnvs;

    public ExternalSystemTaskExecutionSettings() {
        this.myTaskNames = ContainerUtilRt.newArrayList();
        this.myTaskDescriptions = ContainerUtilRt.newArrayList();
        this.myEnv = ContainerUtilRt.newHashMap();
        this.myPassParentEnvs = true;
    }

    private ExternalSystemTaskExecutionSettings(@NotNull ExternalSystemTaskExecutionSettings source) {
        if (source == null) {
            ExternalSystemTaskExecutionSettings.$$$reportNull$$$0(0);
        }
        this.myTaskNames = ContainerUtilRt.newArrayList();
        this.myTaskDescriptions = ContainerUtilRt.newArrayList();
        this.myEnv = ContainerUtilRt.newHashMap();
        this.myPassParentEnvs = true;
        this.setFrom(source);
    }

    public void setFrom(@NotNull ExternalSystemTaskExecutionSettings source) {
        if (source == null) {
            ExternalSystemTaskExecutionSettings.$$$reportNull$$$0(1);
        }
        this.myExecutionName = source.myExecutionName;
        this.myExternalSystemIdString = source.myExternalSystemIdString;
        this.myExternalProjectPath = source.myExternalProjectPath;
        this.myVmOptions = source.myVmOptions;
        this.myScriptParameters = source.myScriptParameters;
        this.myTaskNames = ContainerUtil.copyList(source.myTaskNames);
        this.myTaskDescriptions = ContainerUtil.copyList(source.myTaskDescriptions);
        this.myEnv = source.myEnv.isEmpty() ? Collections.emptyMap() : new THashMap(source.myEnv);
        this.myPassParentEnvs = source.myPassParentEnvs;
    }

    @Nullable
    public String getExecutionName() {
        return this.myExecutionName;
    }

    public void setExecutionName(@Nullable String executionName) {
        this.myExecutionName = executionName;
    }

    public String getExternalSystemIdString() {
        return this.myExternalSystemIdString;
    }

    public ProjectSystemId getExternalSystemId() {
        return new ProjectSystemId(this.myExternalSystemIdString);
    }

    public void setExternalSystemIdString(String externalSystemIdString) {
        this.myExternalSystemIdString = externalSystemIdString;
    }

    public String getExternalProjectPath() {
        return this.myExternalProjectPath;
    }

    public void setExternalProjectPath(String externalProjectPath) {
        this.myExternalProjectPath = externalProjectPath;
    }

    public String getVmOptions() {
        return this.myVmOptions;
    }

    public void setVmOptions(String vmOptions) {
        this.myVmOptions = vmOptions;
    }

    public String getScriptParameters() {
        return this.myScriptParameters;
    }

    public void setScriptParameters(String scriptParameters) {
        this.myScriptParameters = scriptParameters;
    }

    @NotNull
    public List<String> getTaskNames() {
        List<String> list = this.myTaskNames;
        if (list == null) {
            ExternalSystemTaskExecutionSettings.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void setTaskNames(@NotNull List<String> taskNames) {
        if (taskNames == null) {
            ExternalSystemTaskExecutionSettings.$$$reportNull$$$0(3);
        }
        this.myTaskNames = taskNames;
    }

    @NotNull
    public List<String> getTaskDescriptions() {
        List<String> list = this.myTaskDescriptions;
        if (list == null) {
            ExternalSystemTaskExecutionSettings.$$$reportNull$$$0(4);
        }
        return list;
    }

    public void setTaskDescriptions(@NotNull List<String> taskDescriptions) {
        if (taskDescriptions == null) {
            ExternalSystemTaskExecutionSettings.$$$reportNull$$$0(5);
        }
        this.myTaskDescriptions = taskDescriptions;
    }

    @NotNull
    public Map<String, String> getEnv() {
        Map<String, String> map = this.myEnv;
        if (map == null) {
            ExternalSystemTaskExecutionSettings.$$$reportNull$$$0(6);
        }
        return map;
    }

    public void setEnv(@NotNull Map<String, String> value) {
        if (value == null) {
            ExternalSystemTaskExecutionSettings.$$$reportNull$$$0(7);
        }
        this.myEnv = value;
    }

    public boolean isPassParentEnvs() {
        return this.myPassParentEnvs;
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.myPassParentEnvs = passParentEnvs;
    }

    public ExternalSystemTaskExecutionSettings clone() {
        return new ExternalSystemTaskExecutionSettings(this);
    }

    public int hashCode() {
        int result = this.myTaskNames.hashCode();
        result = 31 * result + (this.myExecutionName != null ? this.myExecutionName.hashCode() : 0);
        result = 31 * result + (this.myExternalSystemIdString != null ? this.myExternalSystemIdString.hashCode() : 0);
        result = 31 * result + (this.myExternalProjectPath != null ? this.myExternalProjectPath.hashCode() : 0);
        result = 31 * result + (this.myVmOptions != null ? this.myVmOptions.hashCode() : 0);
        result = 31 * result + (this.myScriptParameters != null ? this.myScriptParameters.hashCode() : 0);
        result = 31 * result + this.myEnv.hashCode();
        result = 31 * result + (this.myPassParentEnvs ? 1 : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalSystemTaskExecutionSettings settings = (ExternalSystemTaskExecutionSettings)o;
        if (!Objects.equals(this.myExecutionName, settings.myExecutionName)) {
            return false;
        }
        if (!Objects.equals(this.myExternalProjectPath, settings.myExternalProjectPath)) {
            return false;
        }
        if (!Objects.equals(this.myExternalSystemIdString, settings.myExternalSystemIdString)) {
            return false;
        }
        if (!Objects.equals(this.myTaskNames, settings.myTaskNames)) {
            return false;
        }
        if (StringUtil.isEmpty((String)this.myVmOptions) ^ StringUtil.isEmpty((String)settings.myVmOptions)) {
            return false;
        }
        if (StringUtil.isEmpty((String)this.myScriptParameters) ^ StringUtil.isEmpty((String)settings.myScriptParameters)) {
            return false;
        }
        if (!Objects.equals(this.myEnv, settings.myEnv)) {
            return false;
        }
        return this.myPassParentEnvs == settings.myPassParentEnvs;
    }

    public String toString() {
        return StringUtil.join(this.myTaskNames, (String)" ") + (StringUtil.isEmpty((String)this.myScriptParameters) ? "" : " " + this.myScriptParameters) + (StringUtil.isEmpty((String)this.myVmOptions) ? "" : " " + this.myVmOptions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/model/execution/ExternalSystemTaskExecutionSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskNames";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskDescriptions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/model/execution/ExternalSystemTaskExecutionSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskNames";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskDescriptions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnv";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setFrom";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setTaskNames";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setTaskDescriptions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setEnv";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

