/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.FileAppearanceService;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.roots.ui.util.SimpleTextCellAppearance;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import java.awt.Color;
import java.io.File;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrderEntryAppearanceServiceImpl
extends OrderEntryAppearanceService {
    private static final String NO_JDK = ProjectBundle.message((String)"jdk.missing.item", (Object[])new Object[0]);

    @Override
    @NotNull
    public CellAppearanceEx forOrderEntry(Project project, @NotNull OrderEntry orderEntry, boolean selected) {
        if (orderEntry == null) {
            OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(0);
        }
        if (orderEntry instanceof JdkOrderEntry) {
            JdkOrderEntry jdkLibraryEntry = (JdkOrderEntry)orderEntry;
            Sdk jdk = jdkLibraryEntry.getJdk();
            if (!orderEntry.isValid()) {
                String oldJdkName = jdkLibraryEntry.getJdkName();
                CellAppearanceEx cellAppearanceEx = FileAppearanceService.getInstance().forInvalidUrl(oldJdkName != null ? oldJdkName : NO_JDK);
                if (cellAppearanceEx == null) {
                    OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(1);
                }
                return cellAppearanceEx;
            }
            CellAppearanceEx cellAppearanceEx = this.forJdk(jdk, false, selected, true);
            if (cellAppearanceEx == null) {
                OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(2);
            }
            return cellAppearanceEx;
        }
        if (!orderEntry.isValid()) {
            CellAppearanceEx cellAppearanceEx = FileAppearanceService.getInstance().forInvalidUrl(orderEntry.getPresentableName());
            if (cellAppearanceEx == null) {
                OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(3);
            }
            return cellAppearanceEx;
        }
        if (orderEntry instanceof LibraryOrderEntry) {
            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry;
            if (!libraryOrderEntry.isValid()) {
                CellAppearanceEx cellAppearanceEx = FileAppearanceService.getInstance().forInvalidUrl(orderEntry.getPresentableName());
                if (cellAppearanceEx == null) {
                    OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(4);
                }
                return cellAppearanceEx;
            }
            Library library = libraryOrderEntry.getLibrary();
            assert (library != null) : libraryOrderEntry;
            CellAppearanceEx cellAppearanceEx = this.forLibrary(project, library, !((LibraryEx)library).getInvalidRootUrls(OrderRootType.CLASSES).isEmpty());
            if (cellAppearanceEx == null) {
                OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(5);
            }
            return cellAppearanceEx;
        }
        if (orderEntry.isSynthetic()) {
            String presentableName = orderEntry.getPresentableName();
            Icon icon = orderEntry instanceof ModuleSourceOrderEntry ? OrderEntryAppearanceServiceImpl.sourceFolderIcon(false) : null;
            SimpleTextCellAppearance simpleTextCellAppearance = new SimpleTextCellAppearance(presentableName, icon, SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
            if (simpleTextCellAppearance == null) {
                OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(6);
            }
            return simpleTextCellAppearance;
        }
        if (orderEntry instanceof ModuleOrderEntry) {
            Icon icon = ModuleType.get((Module)((ModuleOrderEntry)orderEntry).getModule()).getIcon();
            SimpleTextCellAppearance simpleTextCellAppearance = SimpleTextCellAppearance.regular((String)orderEntry.getPresentableName(), (Icon)icon);
            if (simpleTextCellAppearance == null) {
                OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(7);
            }
            return simpleTextCellAppearance;
        }
        CompositeAppearance compositeAppearance = CompositeAppearance.single((String)orderEntry.getPresentableName());
        if (compositeAppearance == null) {
            OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(8);
        }
        return compositeAppearance;
    }

    @Override
    @NotNull
    public CellAppearanceEx forLibrary(Project project, @NotNull Library library, boolean hasInvalidRoots) {
        if (library == null) {
            OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(9);
        }
        StructureConfigurableContext context = ProjectStructureConfigurable.getInstance(project).getContext();
        Icon icon = LibraryPresentationManager.getInstance().getCustomIcon(library, context);
        String name = library.getName();
        if (name != null) {
            CellAppearanceEx cellAppearanceEx = OrderEntryAppearanceServiceImpl.normalOrRedWaved(name, icon != null ? icon : PlatformIcons.LIBRARY_ICON, hasInvalidRoots);
            if (cellAppearanceEx == null) {
                OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(10);
            }
            return cellAppearanceEx;
        }
        String[] files = library.getUrls(OrderRootType.CLASSES);
        if (files.length == 0) {
            SimpleTextCellAppearance simpleTextCellAppearance = SimpleTextCellAppearance.invalid((String)ProjectBundle.message((String)"library.empty.library.item", (Object[])new Object[0]), (Icon)PlatformIcons.LIBRARY_ICON);
            if (simpleTextCellAppearance == null) {
                OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(11);
            }
            return simpleTextCellAppearance;
        }
        if (files.length == 1) {
            CellAppearanceEx cellAppearanceEx = OrderEntryAppearanceServiceImpl.forVirtualFilePointer(new LightFilePointer(files[0]));
            if (cellAppearanceEx == null) {
                OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(12);
            }
            return cellAppearanceEx;
        }
        String url = StringUtil.trimEnd((String)files[0], (String)"!/");
        String text = ProjectBundle.message((String)"library.unnamed.text", (Object[])new Object[]{PathUtil.getFileName((String)url), files.length - 1});
        SimpleTextCellAppearance simpleTextCellAppearance = SimpleTextCellAppearance.regular((String)text, (Icon)PlatformIcons.LIBRARY_ICON);
        if (simpleTextCellAppearance == null) {
            OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(13);
        }
        return simpleTextCellAppearance;
    }

    @Override
    @NotNull
    public CellAppearanceEx forJdk(@Nullable Sdk jdk, boolean isInComboBox, boolean selected, boolean showVersion) {
        String versionString;
        if (jdk == null) {
            CellAppearanceEx cellAppearanceEx = FileAppearanceService.getInstance().forInvalidUrl(NO_JDK);
            if (cellAppearanceEx == null) {
                OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(14);
            }
            return cellAppearanceEx;
        }
        String name = jdk.getName();
        CompositeAppearance appearance = new CompositeAppearance();
        SdkType sdkType = (SdkType)jdk.getSdkType();
        appearance.setIcon(sdkType.getIcon());
        SimpleTextAttributes attributes = OrderEntryAppearanceServiceImpl.getTextAttributes(sdkType.sdkHasValidPath(jdk), selected);
        CompositeAppearance.DequeEnd ending = appearance.getEnding();
        ending.addText(name, attributes);
        if (showVersion && (versionString = jdk.getVersionString()) != null && !versionString.equals(name)) {
            SimpleTextAttributes textAttributes = isInComboBox && !selected ? SimpleTextAttributes.SYNTHETIC_ATTRIBUTES : (SystemInfo.isMac && selected ? new SimpleTextAttributes(0, Color.WHITE) : SimpleTextAttributes.GRAY_ATTRIBUTES);
            ending.addComment(versionString, textAttributes);
        }
        CompositeAppearance compositeAppearance = ending.getAppearance();
        if (compositeAppearance == null) {
            OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(15);
        }
        return compositeAppearance;
    }

    private static SimpleTextAttributes getTextAttributes(boolean valid, boolean selected) {
        if (!valid) {
            return SimpleTextAttributes.ERROR_ATTRIBUTES;
        }
        if (!(!selected || SystemInfo.isWinVistaOrNewer && UIManager.getLookAndFeel().getName().contains("Windows"))) {
            return SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES;
        }
        return SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
    }

    @Override
    @NotNull
    public CellAppearanceEx forContentFolder(@NotNull ContentFolder folder) {
        if (folder == null) {
            OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(16);
        }
        if (folder instanceof SourceFolder) {
            CellAppearanceEx cellAppearanceEx = OrderEntryAppearanceServiceImpl.formatRelativePath(folder, PlatformIcons.FOLDER_ICON);
            if (cellAppearanceEx == null) {
                OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(17);
            }
            return cellAppearanceEx;
        }
        if (folder instanceof ExcludeFolder) {
            CellAppearanceEx cellAppearanceEx = OrderEntryAppearanceServiceImpl.formatRelativePath(folder, IconLoader.getDisabledIcon((Icon)PlatformIcons.FOLDER_ICON));
            if (cellAppearanceEx == null) {
                OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(18);
            }
            return cellAppearanceEx;
        }
        throw new RuntimeException(folder.getClass().getName());
    }

    @Override
    @NotNull
    public CellAppearanceEx forModule(@NotNull Module module) {
        if (module == null) {
            OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(19);
        }
        SimpleTextCellAppearance simpleTextCellAppearance = SimpleTextCellAppearance.regular((String)module.getName(), (Icon)ModuleType.get((Module)module).getIcon());
        if (simpleTextCellAppearance == null) {
            OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(20);
        }
        return simpleTextCellAppearance;
    }

    @NotNull
    private static Icon sourceFolderIcon(boolean testSource) {
        Icon icon = testSource ? PlatformIcons.TEST_SOURCE_FOLDER : PlatformIcons.SOURCE_FOLDERS_ICON;
        if (icon == null) {
            OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(21);
        }
        return icon;
    }

    @NotNull
    private static CellAppearanceEx normalOrRedWaved(@NotNull String text, @Nullable Icon icon, boolean waved) {
        if (text == null) {
            OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(22);
        }
        SimpleTextCellAppearance simpleTextCellAppearance = waved ? new SimpleTextCellAppearance(text, icon, new SimpleTextAttributes(8, null, (Color)JBColor.RED)) : SimpleTextCellAppearance.regular((String)text, (Icon)icon);
        if (simpleTextCellAppearance == null) {
            OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(23);
        }
        return simpleTextCellAppearance;
    }

    @NotNull
    private static CellAppearanceEx forVirtualFilePointer(@NotNull LightFilePointer filePointer) {
        VirtualFile file;
        if (filePointer == null) {
            OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(24);
        }
        CellAppearanceEx cellAppearanceEx = (file = filePointer.getFile()) != null ? FileAppearanceService.getInstance().forVirtualFile(file) : FileAppearanceService.getInstance().forInvalidUrl(filePointer.getPresentableUrl());
        if (cellAppearanceEx == null) {
            OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(25);
        }
        return cellAppearanceEx;
    }

    @NotNull
    private static CellAppearanceEx formatRelativePath(@NotNull ContentFolder folder, @NotNull Icon icon) {
        SimpleTextAttributes textAttributes;
        String relativePath;
        if (folder == null) {
            OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(26);
        }
        if (icon == null) {
            OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(27);
        }
        LightFilePointer folderFile = new LightFilePointer(folder.getUrl());
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(folder.getContentEntry().getUrl());
        if (file == null) {
            CellAppearanceEx cellAppearanceEx = FileAppearanceService.getInstance().forInvalidUrl(folderFile.getPresentableUrl());
            if (cellAppearanceEx == null) {
                OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(28);
            }
            return cellAppearanceEx;
        }
        String contentPath = file.getPath();
        VirtualFile folderFileFile = folderFile.getFile();
        if (folderFileFile == null) {
            String absolutePath = folderFile.getPresentableUrl();
            relativePath = absolutePath.startsWith(contentPath) ? absolutePath.substring(contentPath.length()) : absolutePath;
            textAttributes = SimpleTextAttributes.ERROR_ATTRIBUTES;
        } else {
            relativePath = VfsUtilCore.getRelativePath((VirtualFile)folderFileFile, (VirtualFile)file, (char)File.separatorChar);
            textAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        }
        relativePath = StringUtil.isEmpty((String)relativePath) ? "." + File.separatorChar : relativePath;
        SimpleTextCellAppearance simpleTextCellAppearance = new SimpleTextCellAppearance(relativePath, icon, textAttributes);
        if (simpleTextCellAppearance == null) {
            OrderEntryAppearanceServiceImpl.$$$reportNull$$$0(29);
        }
        return simpleTextCellAppearance;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 16: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePointer";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/OrderEntryAppearanceServiceImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "forOrderEntry";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "forLibrary";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "forJdk";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "forContentFolder";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "forModule";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "sourceFolderIcon";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "normalOrRedWaved";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "forVirtualFilePointer";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "formatRelativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forOrderEntry";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 29: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "forLibrary";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "forContentFolder";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "forModule";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "normalOrRedWaved";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "forVirtualFilePointer";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "formatRelativePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

