/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.artifacts.PlaceInArtifact;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class UsageInArtifact
extends ProjectStructureElementUsage {
    private final Artifact myOriginalArtifact;
    private final ArtifactsStructureConfigurableContext myContext;
    private final ProjectStructureElement mySourceElement;
    private final ProjectStructureElement myContainingElement;
    private final String myParentPath;
    private final PackagingElement<?> myPackagingElement;

    public UsageInArtifact(Artifact originalArtifact, ArtifactsStructureConfigurableContext context, ProjectStructureElement sourceElement, ArtifactProjectStructureElement containingElement, String parentPath, PackagingElement<?> packagingElement) {
        this.myOriginalArtifact = originalArtifact;
        this.myContext = context;
        this.mySourceElement = sourceElement;
        this.myContainingElement = containingElement;
        this.myParentPath = parentPath;
        this.myPackagingElement = packagingElement;
    }

    @Override
    public ProjectStructureElement getSourceElement() {
        return this.mySourceElement;
    }

    @Override
    public ProjectStructureElement getContainingElement() {
        return this.myContainingElement;
    }

    public void removeElement() {
        this.getOrCreateEditor().removePackagingElement(this.myParentPath, this.myPackagingElement);
    }

    private ArtifactEditorEx getOrCreateEditor() {
        return (ArtifactEditorEx)this.myContext.getOrCreateEditor(this.myOriginalArtifact);
    }

    public void replaceElement(PackagingElement<?> replacement) {
        this.getOrCreateEditor().replacePackagingElement(this.myParentPath, this.myPackagingElement, replacement);
    }

    @Override
    public String getPresentableName() {
        return this.myOriginalArtifact.getName();
    }

    @Override
    public PlaceInProjectStructure getPlace() {
        return new PlaceInArtifact(this.myOriginalArtifact, this.myContext, this.myParentPath, this.myPackagingElement);
    }

    @Override
    public int hashCode() {
        return this.myOriginalArtifact.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof UsageInArtifact && ((UsageInArtifact)obj).myOriginalArtifact.equals(this.myOriginalArtifact);
    }

    @Override
    public Icon getIcon() {
        return this.myOriginalArtifact.getArtifactType().getIcon();
    }

    @Override
    @Nullable
    public String getPresentableLocationInElement() {
        return "[" + this.myParentPath + "]";
    }

    @Override
    public void removeSourceElement() {
        this.removeElement();
    }

    @Override
    public void replaceElement(ProjectStructureElement newElement) {
        Library library = ((LibraryProjectStructureElement)newElement).getLibrary();
        PackagingElement<?> newLibraryElement = PackagingElementFactory.getInstance().createLibraryFiles(library.getName(), library.getTable().getTableLevel(), null);
        this.replaceElement(newLibraryElement);
    }
}

