/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeComponent;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeSelection;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.ExtractArtifactDialog;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.IExtractArtifactDialog;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.LayoutTreeActionBase;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.CompositePackagingElementNode;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractArtifactAction
extends LayoutTreeActionBase {
    public ExtractArtifactAction(ArtifactEditorEx editor) {
        super(ProjectBundle.message((String)"action.name.extract.artifact", (Object[])new Object[0]), editor);
    }

    @Override
    protected boolean isEnabled() {
        return this.myArtifactEditor.getLayoutTreeComponent().getSelection().getCommonParentElement() != null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        IExtractArtifactDialog dialog;
        LayoutTreeComponent treeComponent;
        LayoutTreeSelection selection;
        CompositePackagingElement<?> parent;
        if (e == null) {
            ExtractArtifactAction.$$$reportNull$$$0(0);
        }
        if ((parent = (selection = (treeComponent = this.myArtifactEditor.getLayoutTreeComponent()).getSelection()).getCommonParentElement()) == null) {
            return;
        }
        CompositePackagingElementNode parentNode = selection.getNodes().get(0).getParentNode();
        if (parentNode == null) {
            return;
        }
        if (!treeComponent.checkCanModifyChildren(parent, parentNode, selection.getNodes())) {
            return;
        }
        List<PackagingElement<?>> selectedElements = selection.getElements();
        String initialName = "artifact";
        if (selectedElements.size() == 1) {
            initialName = PathUtil.suggestFileName((String)((PackagingElement)ContainerUtil.getFirstItem(selectedElements, null)).createPresentation(this.myArtifactEditor.getContext()).getPresentableName());
        }
        if ((dialog = this.showDialog(treeComponent, initialName)) == null) {
            return;
        }
        Project project = this.myArtifactEditor.getContext().getProject();
        ModifiableArtifactModel model = this.myArtifactEditor.getContext().getOrCreateModifiableArtifactModel();
        ModifiableArtifact artifact = model.addArtifact(dialog.getArtifactName(), dialog.getArtifactType());
        treeComponent.editLayout(() -> {
            for (PackagingElement element : selectedElements) {
                artifact.getRootElement().addOrFindChild(ArtifactUtil.copyWithChildren((PackagingElement)element, (Project)project));
            }
            for (PackagingElement element : selectedElements) {
                parent.removeChild(element);
            }
            parent.addOrFindChild(new ArtifactPackagingElement(project, ArtifactPointerManager.getInstance(project).createPointer(artifact, this.myArtifactEditor.getContext().getArtifactModel())));
        });
        treeComponent.rebuildTree();
    }

    @Nullable
    protected IExtractArtifactDialog showDialog(LayoutTreeComponent treeComponent, String initialName) {
        ExtractArtifactDialog dialog = new ExtractArtifactDialog(this.myArtifactEditor.getContext(), treeComponent, initialName);
        if (!dialog.showAndGet()) {
            return null;
        }
        return dialog;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/roots/ui/configuration/artifacts/actions/ExtractArtifactAction", "actionPerformed"));
    }
}

