/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetTypeId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.DelegatedSourceItemPresentation;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleSourceItemGroup;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.PackagingSourceItemsProvider;
import com.intellij.packaging.ui.SourceItemPresentation;
import com.intellij.packaging.ui.TreeNodePresentation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FacetBasedPackagingSourceItemsProvider<F extends Facet, E extends PackagingElement<?>>
extends PackagingSourceItemsProvider {
    private final FacetTypeId<F> myFacetTypeId;
    private final PackagingElementType<E> myElementType;

    protected FacetBasedPackagingSourceItemsProvider(FacetTypeId<F> facetTypeId, PackagingElementType<E> elementType) {
        this.myFacetTypeId = facetTypeId;
        this.myElementType = elementType;
    }

    @Override
    @NotNull
    public Collection<? extends PackagingSourceItem> getSourceItems(@NotNull ArtifactEditorContext editorContext, @NotNull Artifact artifact, @Nullable PackagingSourceItem parent) {
        if (editorContext == null) {
            FacetBasedPackagingSourceItemsProvider.$$$reportNull$$$0(0);
        }
        if (artifact == null) {
            FacetBasedPackagingSourceItemsProvider.$$$reportNull$$$0(1);
        }
        if (parent instanceof ModuleSourceItemGroup) {
            Module module = ((ModuleSourceItemGroup)parent).getModule();
            HashSet facets = new HashSet(editorContext.getFacetsProvider().getFacetsByType(module, this.myFacetTypeId));
            ArtifactUtil.processPackagingElements((Artifact)artifact, this.myElementType, e -> {
                F facet = this.getFacet(e);
                if (facet != null) {
                    facets.remove(facet);
                }
                return true;
            }, (PackagingElementResolvingContext)editorContext, (boolean)true);
            if (!facets.isEmpty()) {
                List<FacetBasedSourceItem<Facet>> list = Collections.singletonList(new FacetBasedSourceItem<Facet>(this, (Facet)facets.iterator().next()));
                if (list == null) {
                    FacetBasedPackagingSourceItemsProvider.$$$reportNull$$$0(2);
                }
                return list;
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            FacetBasedPackagingSourceItemsProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    protected PackagingElementOutputKind getKindOfProducedElements() {
        return PackagingElementOutputKind.OTHER;
    }

    @Nullable
    protected abstract F getFacet(E var1);

    protected abstract TreeNodePresentation createPresentation(F var1);

    protected abstract PackagingElement<?> createElement(ArtifactEditorContext var1, F var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/FacetBasedPackagingSourceItemsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/FacetBasedPackagingSourceItemsProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSourceItems";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class FacetBasedSourceItem<F extends Facet>
    extends PackagingSourceItem {
        private final FacetBasedPackagingSourceItemsProvider<? super F, ?> myProvider;
        private final F myFacet;

        public FacetBasedSourceItem(FacetBasedPackagingSourceItemsProvider<? super F, ?> provider, F facet) {
            this.myProvider = provider;
            this.myFacet = facet;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof FacetBasedSourceItem && this.myFacet.equals(((FacetBasedSourceItem)obj).myFacet) && this.myProvider.equals(((FacetBasedSourceItem)obj).myProvider);
        }

        @Override
        public int hashCode() {
            return this.myFacet.hashCode() + 31 * this.myProvider.hashCode();
        }

        @Override
        @NotNull
        public SourceItemPresentation createPresentation(@NotNull ArtifactEditorContext context) {
            if (context == null) {
                FacetBasedSourceItem.$$$reportNull$$$0(0);
            }
            DelegatedSourceItemPresentation delegatedSourceItemPresentation = new DelegatedSourceItemPresentation(this.myProvider.createPresentation(this.myFacet));
            if (delegatedSourceItemPresentation == null) {
                FacetBasedSourceItem.$$$reportNull$$$0(1);
            }
            return delegatedSourceItemPresentation;
        }

        @Override
        @NotNull
        public List<? extends PackagingElement<?>> createElements(@NotNull ArtifactEditorContext context) {
            if (context == null) {
                FacetBasedSourceItem.$$$reportNull$$$0(2);
            }
            List<PackagingElement<?>> list = Collections.singletonList(this.myProvider.createElement(context, this.myFacet));
            if (list == null) {
                FacetBasedSourceItem.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        @NotNull
        public PackagingElementOutputKind getKindOfProducedElements() {
            PackagingElementOutputKind packagingElementOutputKind = this.myProvider.getKindOfProducedElements();
            if (packagingElementOutputKind == null) {
                FacetBasedSourceItem.$$$reportNull$$$0(4);
            }
            return packagingElementOutputKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/FacetBasedPackagingSourceItemsProvider$FacetBasedSourceItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/FacetBasedPackagingSourceItemsProvider$FacetBasedSourceItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPresentation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createElements";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKindOfProducedElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createPresentation";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createElements";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

