/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.SourceItemsTree;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions.PutIntoDefaultLocationActionBase;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.ParentElementProcessor;
import com.intellij.packaging.impl.elements.ManifestFileUtil;
import com.intellij.packaging.ui.ArtifactEditor;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PutSourceItemIntoParentAndLinkViaManifestAction
extends PutIntoDefaultLocationActionBase {
    public PutSourceItemIntoParentAndLinkViaManifestAction(SourceItemsTree sourceItemsTree, ArtifactEditorEx artifactEditor) {
        super(sourceItemsTree, artifactEditor);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PutSourceItemIntoParentAndLinkViaManifestAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        Artifact artifact = this.myArtifactEditor.getArtifact();
        ParentElementsInfo parentInfo = this.findParentAndGrandParent(artifact);
        if (parentInfo != null) {
            presentation.setText("Put Into '" + parentInfo.getGrandparentArtifact().getName() + "' and link via manifest");
        }
        boolean enable = parentInfo != null;
        boolean isProvideElements = false;
        for (PackagingSourceItem item : this.mySourceItemsTree.getSelectedItems()) {
            isProvideElements |= item.isProvideElements();
            if (item.getKindOfProducedElements().containsJarFiles()) continue;
            enable = false;
            break;
        }
        presentation.setVisible(enable &= isProvideElements);
        presentation.setEnabled(enable);
    }

    @Nullable
    private ParentElementsInfo findParentAndGrandParent(Artifact artifact) {
        final Ref result = Ref.create(null);
        ArtifactUtil.processParents((Artifact)artifact, (PackagingElementResolvingContext)this.myArtifactEditor.getContext(), (ParentElementProcessor)new ParentElementProcessor(){

            public boolean process(@NotNull CompositePackagingElement<?> element, @NotNull List<Pair<Artifact, CompositePackagingElement<?>>> parents, @NotNull Artifact artifact) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (parents == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (artifact == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (parents.size() == 1) {
                    Pair<Artifact, CompositePackagingElement<?>> parent = parents.get(0);
                    result.set((Object)new ParentElementsInfo((Artifact)parent.getFirst(), (CompositePackagingElement)parent.getSecond(), artifact, element));
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parents";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "artifact";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/actions/PutSourceItemIntoParentAndLinkViaManifestAction$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (int)1);
        return (ParentElementsInfo)result.get();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            PutSourceItemIntoParentAndLinkViaManifestAction.$$$reportNull$$$0(1);
        }
        List<PackagingSourceItem> items = this.mySourceItemsTree.getSelectedItems();
        ParentElementsInfo parentsInfo = this.findParentAndGrandParent(this.myArtifactEditor.getArtifact());
        if (parentsInfo == null) {
            return;
        }
        Artifact artifact = parentsInfo.getGrandparentArtifact();
        ArtifactEditorContext context = this.myArtifactEditor.getContext();
        Runnable emptyRunnable = EmptyRunnable.getInstance();
        context.editLayout(artifact, emptyRunnable);
        context.editLayout(parentsInfo.getParentArtifact(), emptyRunnable);
        parentsInfo = this.findParentAndGrandParent(this.myArtifactEditor.getArtifact());
        if (parentsInfo == null) {
            return;
        }
        CompositePackagingElement<?> grandParent = parentsInfo.getGrandparentElement();
        ArrayList<String> classpath = new ArrayList<String>();
        context.editLayout(artifact, () -> {
            for (PackagingSourceItem item : items) {
                List<? extends PackagingElement<?>> elements = item.createElements(context);
                grandParent.addOrFindChildren(elements);
                classpath.addAll(ManifestFileUtil.getClasspathForElements(elements, (PackagingElementResolvingContext)context, (ArtifactType)artifact.getArtifactType()));
            }
        });
        ArtifactEditor parentArtifactEditor = context.getOrCreateEditor(parentsInfo.getParentArtifact());
        parentArtifactEditor.addToClasspath(parentsInfo.getParentElement(), classpath);
        ((ArtifactEditorImpl)context.getOrCreateEditor(parentsInfo.getGrandparentArtifact())).rebuildTries();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/actions/PutSourceItemIntoParentAndLinkViaManifestAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ParentElementsInfo {
        private final Artifact myParentArtifact;
        private final CompositePackagingElement<?> myParentElement;
        private final Artifact myGrandparentArtifact;
        private final CompositePackagingElement<?> myGrandparentElement;

        private ParentElementsInfo(Artifact parentArtifact, CompositePackagingElement<?> parentElement, Artifact grandparentArtifact, CompositePackagingElement<?> grandparentElement) {
            this.myParentArtifact = parentArtifact;
            this.myParentElement = parentElement;
            this.myGrandparentArtifact = grandparentArtifact;
            this.myGrandparentElement = grandparentElement;
        }

        public Artifact getParentArtifact() {
            return this.myParentArtifact;
        }

        public CompositePackagingElement<?> getParentElement() {
            return this.myParentElement;
        }

        public Artifact getGrandparentArtifact() {
            return this.myGrandparentArtifact;
        }

        public CompositePackagingElement<?> getGrandparentElement() {
            return this.myGrandparentElement;
        }
    }
}

