/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.roots.ui.configuration.GeneralProjectSettingsElement;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructureBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.ui.navigation.Place;
import javax.swing.Icon;

public class UsageInProjectSettings
extends ProjectStructureElementUsage {
    private final StructureConfigurableContext myContext;
    private final ProjectStructureElement mySourceElement;
    private final String myPresentableName;

    public UsageInProjectSettings(StructureConfigurableContext context, ProjectStructureElement sourceElement, String presentableName) {
        this.myContext = context;
        this.mySourceElement = sourceElement;
        this.myPresentableName = presentableName;
    }

    @Override
    public ProjectStructureElement getSourceElement() {
        return this.mySourceElement;
    }

    @Override
    public ProjectStructureElement getContainingElement() {
        return new GeneralProjectSettingsElement(this.myContext);
    }

    @Override
    public String getPresentableName() {
        return this.myPresentableName;
    }

    @Override
    public PlaceInProjectStructure getPlace() {
        Place configurablePlace = ProjectStructureConfigurable.getInstance(this.myContext.getProject()).createProjectConfigurablePlace();
        return new PlaceInProjectStructureBase(this.myContext.getProject(), configurablePlace, this.getContainingElement(), false);
    }

    @Override
    public int hashCode() {
        return this.mySourceElement.hashCode() * 31 + this.myPresentableName.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof UsageInProjectSettings && this.mySourceElement.equals(((UsageInProjectSettings)obj).mySourceElement) && this.myPresentableName.equals(((UsageInProjectSettings)obj).myPresentableName);
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public void removeSourceElement() {
    }

    @Override
    public void replaceElement(ProjectStructureElement newElement) {
    }
}

