/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.projectImport;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectOpenProcessorBase<T extends ProjectImportBuilder>
extends ProjectOpenProcessor {
    private final T myBuilder;

    protected ProjectOpenProcessorBase(@NotNull T builder) {
        if (builder == null) {
            ProjectOpenProcessorBase.$$$reportNull$$$0(0);
        }
        this.myBuilder = builder;
    }

    public String getName() {
        return ((ProjectImportBuilder)((Object)this.getBuilder())).getName();
    }

    @Nullable
    public Icon getIcon() {
        return ((ProjectImportBuilder)((Object)this.getBuilder())).getIcon();
    }

    public boolean canOpenProject(VirtualFile file) {
        String[] supported = this.getSupportedExtensions();
        if (supported != null) {
            if (file.isDirectory()) {
                for (VirtualFile child : ProjectOpenProcessorBase.getFileChildren(file)) {
                    if (!ProjectOpenProcessorBase.canOpenFile(child, supported)) continue;
                    return true;
                }
                return false;
            }
            if (ProjectOpenProcessorBase.canOpenFile(file, supported)) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static VirtualFile[] getFileChildren(VirtualFile file) {
        VirtualFile[] virtualFileArray = (VirtualFile[])ObjectUtils.chooseNotNull((Object)file.getChildren(), (Object)VirtualFile.EMPTY_ARRAY);
        if (virtualFileArray == null) {
            ProjectOpenProcessorBase.$$$reportNull$$$0(1);
        }
        return virtualFileArray;
    }

    protected static boolean canOpenFile(VirtualFile file, String[] supported) {
        String fileName = file.getName();
        for (String name : supported) {
            if (!fileName.equals(name)) continue;
            return true;
        }
        return false;
    }

    protected boolean doQuickImport(VirtualFile file, WizardContext wizardContext) {
        return false;
    }

    @NotNull
    public T getBuilder() {
        T t = this.myBuilder;
        if (t == null) {
            ProjectOpenProcessorBase.$$$reportNull$$$0(2);
        }
        return t;
    }

    @Nullable
    public abstract String[] getSupportedExtensions();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Project doOpenProject(@NotNull VirtualFile virtualFile, Project projectToClose, boolean forceOpenInNewFrame) {
        if (virtualFile == null) {
            ProjectOpenProcessorBase.$$$reportNull$$$0(3);
        }
        try {
            Project projectToOpen;
            Project defaultProject;
            Sdk jdk;
            String[] supported;
            ((ProjectImportBuilder)((Object)this.getBuilder())).setUpdate(false);
            WizardContext wizardContext = new WizardContext(null, null);
            if (virtualFile.isDirectory()) {
                supported = this.getSupportedExtensions();
                for (VirtualFile file : ProjectOpenProcessorBase.getFileChildren(virtualFile)) {
                    if (!ProjectOpenProcessorBase.canOpenFile(file, supported)) continue;
                    virtualFile = file;
                    break;
                }
            }
            wizardContext.setProjectFileDirectory(virtualFile.getParent().getPath());
            if (!this.doQuickImport(virtualFile, wizardContext)) {
                supported = null;
                return supported;
            }
            if (wizardContext.getProjectName() == null) {
                if (wizardContext.getProjectStorageFormat() == StorageScheme.DEFAULT) {
                    wizardContext.setProjectName(IdeBundle.message((String)"project.import.default.name", (Object[])new Object[]{this.getName()}) + ".ipr");
                } else {
                    wizardContext.setProjectName(IdeBundle.message((String)"project.import.default.name.dotIdea", (Object[])new Object[]{this.getName()}));
                }
            }
            if ((jdk = ProjectRootManager.getInstance((Project)(defaultProject = ProjectManager.getInstance().getDefaultProject())).getProjectSdk()) == null) {
                jdk = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)JavaSdk.getInstance());
            }
            wizardContext.setProjectJdk(jdk);
            String dotIdeaFilePath = wizardContext.getProjectFileDirectory() + File.separator + ".idea";
            String projectFilePath = wizardContext.getProjectFileDirectory() + File.separator + wizardContext.getProjectName() + ".ipr";
            File dotIdeaFile = new File(dotIdeaFilePath);
            File projectFile = new File(projectFilePath);
            String pathToOpen = wizardContext.getProjectStorageFormat() == StorageScheme.DEFAULT ? projectFilePath : dotIdeaFile.getParent();
            boolean shouldOpenExisting = false;
            boolean importToProject = true;
            if (projectFile.exists() || dotIdeaFile.exists()) {
                if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    shouldOpenExisting = true;
                    importToProject = true;
                } else {
                    String existingName;
                    if (dotIdeaFile.exists()) {
                        existingName = "an existing project";
                        pathToOpen = dotIdeaFile.getParent();
                    } else {
                        existingName = "'" + projectFile.getName() + "'";
                        pathToOpen = projectFilePath;
                    }
                    int result = Messages.showYesNoCancelDialog((Project)projectToClose, (String)IdeBundle.message((String)"project.import.open.existing", (Object[])new Object[]{existingName, projectFile.getParent(), virtualFile.getName()}), (String)IdeBundle.message((String)"title.open.project", (Object[])new Object[0]), (String)IdeBundle.message((String)"project.import.open.existing.openExisting", (Object[])new Object[0]), (String)IdeBundle.message((String)"project.import.open.existing.reimport", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                    if (result == 2) {
                        Project project = null;
                        return project;
                    }
                    shouldOpenExisting = result == 0;
                    boolean bl = importToProject = !shouldOpenExisting;
                }
            }
            if (shouldOpenExisting) {
                try {
                    projectToOpen = ProjectManagerEx.getInstanceEx().loadProject(pathToOpen);
                }
                catch (Exception e) {
                    Project project = null;
                    this.getBuilder().cleanup();
                    return project;
                }
            } else {
                projectToOpen = ProjectManagerEx.getInstanceEx().newProject(wizardContext.getProjectName(), pathToOpen, true, false);
            }
            if (projectToOpen == null) {
                Project project = null;
                return project;
            }
            if (importToProject) {
                if (!this.getBuilder().validate(projectToClose, projectToOpen)) {
                    Project project = null;
                    return project;
                }
                projectToOpen.save();
                ApplicationManager.getApplication().runWriteAction(() -> {
                    Sdk jdk1 = wizardContext.getProjectJdk();
                    if (jdk1 != null) {
                        NewProjectUtil.applyJdkToProject(projectToOpen, jdk1);
                    }
                    String projectDirPath = wizardContext.getProjectFileDirectory();
                    String path = projectDirPath + (StringUtil.endsWithChar((CharSequence)projectDirPath, (char)'/') ? "classes" : "/classes");
                    CompilerProjectExtension extension = CompilerProjectExtension.getInstance((Project)projectToOpen);
                    if (extension != null) {
                        extension.setCompilerOutputUrl(ProjectOpenProcessorBase.getUrl(path));
                    }
                });
                ((ProjectImportBuilder)((Object)this.getBuilder())).commit(projectToOpen, null, ModulesProvider.EMPTY_MODULES_PROVIDER);
            }
            if (!forceOpenInNewFrame) {
                NewProjectUtil.closePreviousProject(projectToClose);
            }
            ProjectUtil.updateLastProjectLocation((String)pathToOpen);
            ProjectManagerEx.getInstanceEx().openProject(projectToOpen);
            Project project = projectToOpen;
            return project;
        }
        finally {
            this.getBuilder().cleanup();
        }
    }

    public static String getUrl(@NonNls String path) {
        try {
            path = FileUtil.resolveShortWindowsName((String)path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)path));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/projectImport/ProjectOpenProcessorBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/projectImport/ProjectOpenProcessorBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileChildren";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doOpenProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

