/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.descriptors.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileInfo;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.impl.ConfigFileContainerImpl;
import java.lang.ref.Reference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigFileImpl
extends SimpleModificationTracker
implements ConfigFile {
    @NotNull
    private ConfigFileInfo myInfo;
    private final VirtualFilePointer myFilePointer;
    private volatile Reference<PsiFile> myPsiFile;
    private final ConfigFileContainerImpl myContainer;
    private final Project myProject;

    public ConfigFileImpl(@NotNull ConfigFileContainerImpl container, @NotNull ConfigFileInfo configuration) {
        if (container == null) {
            ConfigFileImpl.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            ConfigFileImpl.$$$reportNull$$$0(1);
        }
        this.myContainer = container;
        this.myInfo = configuration;
        VirtualFilePointerManager pointerManager = VirtualFilePointerManager.getInstance();
        this.myFilePointer = pointerManager.create(configuration.getUrl(), (Disposable)this, new VirtualFilePointerListener(){

            public void validityChanged(@NotNull VirtualFilePointer[] pointers) {
                if (pointers == null) {
                    1.$$$reportNull$$$0(0);
                }
                ConfigFileImpl.this.myPsiFile = null;
                ConfigFileImpl.this.onChange();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/util/descriptors/impl/ConfigFileImpl$1", "validityChanged"));
            }
        });
        this.onChange();
        this.myProject = this.myContainer.getProject();
    }

    private void onChange() {
        this.incModificationCount();
        this.myContainer.fireDescriptorChanged(this);
    }

    @Override
    public String getUrl() {
        return this.myFilePointer.getUrl();
    }

    public void setInfo(@NotNull ConfigFileInfo info) {
        if (info == null) {
            ConfigFileImpl.$$$reportNull$$$0(2);
        }
        this.myInfo = info;
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myFilePointer.isValid() ? this.myFilePointer.getFile() : null;
    }

    @Override
    @Nullable
    public PsiFile getPsiFile() {
        PsiFile psiFile = (PsiFile)SoftReference.dereference(this.myPsiFile);
        if (psiFile != null && psiFile.isValid()) {
            return psiFile;
        }
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        psiFile = PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
        this.myPsiFile = new java.lang.ref.SoftReference<PsiFile>(psiFile);
        return psiFile;
    }

    @Override
    @Nullable
    public XmlFile getXmlFile() {
        PsiFile file = this.getPsiFile();
        return file instanceof XmlFile ? (XmlFile)file : null;
    }

    public void dispose() {
    }

    @Override
    @NotNull
    public ConfigFileInfo getInfo() {
        ConfigFileInfo configFileInfo = this.myInfo;
        if (configFileInfo == null) {
            ConfigFileImpl.$$$reportNull$$$0(3);
        }
        return configFileInfo;
    }

    @Override
    public boolean isValid() {
        PsiFile psiFile = this.getPsiFile();
        if (psiFile == null || !psiFile.isValid()) {
            return false;
        }
        if (psiFile instanceof XmlFile) {
            XmlDocument document = ((XmlFile)psiFile).getDocument();
            return document != null && document.getRootTag() != null;
        }
        return true;
    }

    @Override
    @NotNull
    public ConfigFileMetaData getMetaData() {
        ConfigFileMetaData configFileMetaData = this.myInfo.getMetaData();
        if (configFileMetaData == null) {
            ConfigFileImpl.$$$reportNull$$$0(4);
        }
        return configFileMetaData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/descriptors/impl/ConfigFileImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/descriptors/impl/ConfigFileImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setInfo";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

