/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutlib;

import com.android.ide.common.rendering.api.Bridge;
import com.android.io.IAbstractFile;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.tools.idea.io.BufferingFileWrapper;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.LayoutLogWrapper;
import com.android.tools.idea.layoutlib.LayoutlibBundle;
import com.android.tools.idea.layoutlib.LayoutlibClassLoader;
import com.android.tools.idea.layoutlib.LogWrapper;
import com.android.tools.idea.layoutlib.RenderingException;
import com.android.tools.idea.layoutlib.UnsupportedJavaRuntimeException;
import com.android.utils.ILogger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutLibraryLoader {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.uipreview.LayoutLibraryLoader");

    private LayoutLibraryLoader() {
    }

    @Nullable
    public static LayoutLibrary load(@NotNull IAndroidTarget target, @NotNull Map<String, Map<String, Integer>> enumMap) throws RenderingException, IOException {
        if (target == null) {
            LayoutLibraryLoader.$$$reportNull$$$0(0);
        }
        if (enumMap == null) {
            LayoutLibraryLoader.$$$reportNull$$$0(1);
        }
        String fontFolderPath = FileUtil.toSystemIndependentName((String)target.getPath(12));
        VirtualFile fontFolder = LocalFileSystem.getInstance().findFileByPath(fontFolderPath);
        if (fontFolder == null || !fontFolder.isDirectory()) {
            throw new RenderingException(LayoutlibBundle.message("android.directory.cannot.be.found.error", FileUtil.toSystemDependentName((String)fontFolderPath)), new Throwable[0]);
        }
        String platformFolderPath = target.isPlatform() ? target.getLocation() : target.getParent().getLocation();
        File platformFolder = new File(platformFolderPath);
        if (!platformFolder.isDirectory()) {
            throw new RenderingException(LayoutlibBundle.message("android.directory.cannot.be.found.error", FileUtil.toSystemDependentName((String)platformFolderPath)), new Throwable[0]);
        }
        File buildProp = new File(platformFolder, "build.prop");
        if (!buildProp.isFile()) {
            throw new RenderingException(LayoutlibBundle.message("android.file.not.exist.error", FileUtil.toSystemDependentName((String)buildProp.getPath())), new Throwable[0]);
        }
        if (!SystemInfo.isJavaVersionAtLeast((int)8, (int)0, (int)0) && target.getVersion().getFeatureLevel() >= 24) {
            throw new UnsupportedJavaRuntimeException(LayoutlibBundle.message("android.layout.preview.unsupported.jdk", SdkVersionInfo.getCodeName((int)target.getVersion().getFeatureLevel())));
        }
        LogWrapper logger = new LogWrapper(LOG);
        LayoutLibrary library = LayoutLibrary.load((Bridge)new com.android.layoutlib.bridge.Bridge(), new LayoutlibClassLoader(LayoutLibraryLoader.class.getClassLoader()));
        Map buildPropMap = ProjectProperties.parsePropertyFile((IAbstractFile)new BufferingFileWrapper(buildProp), (ILogger)logger);
        LayoutLogWrapper layoutLog = new LayoutLogWrapper(LOG);
        if (library.init(buildPropMap, new File(fontFolder.getPath()), enumMap, layoutLog)) {
            return library;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "target";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "enumMap";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/layoutlib/LayoutLibraryLoader";
        objectArray[2] = "load";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

