/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ObjectUtils;
import com.intellij.webcore.util.JsonUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaConfig {
    private static final Logger LOG = Logger.getInstance(KarmaConfig.class);
    private static final String AUTO_WATCH = "autoWatch";
    private static final String BASE_PATH = "basePath";
    private static final String BROWSERS = "browsers";
    private static final String PROTOCOL = "protocol";
    private static final String HOST_NAME = "hostname";
    private static final String URL_ROOT = "urlRoot";
    private static final String DEBUG_INFO = "debugInfo";
    private static final String REMOTE_DEBUGGING_PORT = "--remote-debugging-port";
    private final boolean myAutoWatch;
    private final List<String> myBrowsers;
    private final String myBasePath;
    private final String myProtocol;
    private final String myHostname;
    private final String myUrlRoot;
    private final int myRemoteDebuggingPort;

    public KarmaConfig(boolean autoWatch, @NotNull String basePath, @NotNull List<String> browsers, @NotNull String protocol, @NotNull String hostname, @NotNull String urlRoot, int remoteDebuggingPort) {
        if (basePath == null) {
            KarmaConfig.$$$reportNull$$$0(0);
        }
        if (browsers == null) {
            KarmaConfig.$$$reportNull$$$0(1);
        }
        if (protocol == null) {
            KarmaConfig.$$$reportNull$$$0(2);
        }
        if (hostname == null) {
            KarmaConfig.$$$reportNull$$$0(3);
        }
        if (urlRoot == null) {
            KarmaConfig.$$$reportNull$$$0(4);
        }
        this.myAutoWatch = autoWatch;
        this.myBasePath = basePath;
        this.myBrowsers = ImmutableList.copyOf(browsers);
        this.myProtocol = protocol;
        this.myHostname = hostname;
        this.myUrlRoot = urlRoot;
        this.myRemoteDebuggingPort = remoteDebuggingPort;
    }

    public boolean isAutoWatch() {
        return this.myAutoWatch;
    }

    @NotNull
    public String getBasePath() {
        String string = this.myBasePath;
        if (string == null) {
            KarmaConfig.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public List<String> getBrowsers() {
        List<String> list = this.myBrowsers;
        if (list == null) {
            KarmaConfig.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public String getProtocol() {
        String string = this.myProtocol;
        if (string == null) {
            KarmaConfig.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getHostname() {
        String string = this.myHostname;
        if (string == null) {
            KarmaConfig.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getUrlRoot() {
        String string = this.myUrlRoot;
        if (string == null) {
            KarmaConfig.$$$reportNull$$$0(9);
        }
        return string;
    }

    public int getRemoteDebuggingPort() {
        return this.myRemoteDebuggingPort;
    }

    @Nullable
    public static KarmaConfig parseFromJson(@NotNull JsonElement jsonElement, @NotNull File configurationFileDir, @NotNull NodeJsInterpreter interpreter) {
        if (jsonElement == null) {
            KarmaConfig.$$$reportNull$$$0(10);
        }
        if (configurationFileDir == null) {
            KarmaConfig.$$$reportNull$$$0(11);
        }
        if (interpreter == null) {
            KarmaConfig.$$$reportNull$$$0(12);
        }
        if (jsonElement.isJsonObject()) {
            JsonObject rootObject = jsonElement.getAsJsonObject();
            boolean autoWatch = JsonUtil.getChildAsBoolean((JsonObject)rootObject, (String)AUTO_WATCH, (boolean)false);
            List<String> browsers = KarmaConfig.parseBrowsers(rootObject);
            String basePath = KarmaConfig.parseBasePath(jsonElement, rootObject, configurationFileDir, interpreter);
            String protocol = (String)ObjectUtils.notNull((Object)JsonUtil.getChildAsString((JsonObject)rootObject, (String)PROTOCOL), (Object)"http:");
            String hostname = KarmaConfig.parseHostname(jsonElement, rootObject);
            String urlRoot = KarmaConfig.parseUrlRoot(jsonElement, rootObject);
            JsonObject debugInfoObj = JsonUtil.getChildAsObject((JsonObject)rootObject, (String)DEBUG_INFO);
            int remoteDebuggingPort = debugInfoObj != null ? JsonUtil.getChildAsInteger((JsonObject)debugInfoObj, (String)REMOTE_DEBUGGING_PORT, (int)-1) : -1;
            return new KarmaConfig(autoWatch, basePath, browsers, protocol, hostname, urlRoot, remoteDebuggingPort);
        }
        return null;
    }

    @NotNull
    private static String parseBasePath(@NotNull JsonElement all, @NotNull JsonObject obj, @NotNull File configurationFileDir, @NotNull NodeJsInterpreter interpreter) {
        String basePath;
        if (all == null) {
            KarmaConfig.$$$reportNull$$$0(13);
        }
        if (obj == null) {
            KarmaConfig.$$$reportNull$$$0(14);
        }
        if (configurationFileDir == null) {
            KarmaConfig.$$$reportNull$$$0(15);
        }
        if (interpreter == null) {
            KarmaConfig.$$$reportNull$$$0(16);
        }
        if ((basePath = JsonUtil.getChildAsString((JsonObject)obj, (String)BASE_PATH)) == null) {
            LOG.warn("Can not parse Karma config.basePath from " + all.toString());
            basePath = configurationFileDir.getAbsolutePath();
        }
        String string = NodeInterpreterUtil.convertRemotePathToLocal((String)basePath, (NodeJsInterpreter)interpreter);
        if (string == null) {
            KarmaConfig.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static String parseUrlRoot(@NotNull JsonElement all, @NotNull JsonObject obj) {
        String urlRoot;
        if (all == null) {
            KarmaConfig.$$$reportNull$$$0(18);
        }
        if (obj == null) {
            KarmaConfig.$$$reportNull$$$0(19);
        }
        if ((urlRoot = JsonUtil.getChildAsString((JsonObject)obj, (String)URL_ROOT)) == null) {
            LOG.warn("Can not parse Karma config.urlRoot from " + all.toString());
            urlRoot = "/";
        }
        if (!urlRoot.startsWith("/")) {
            urlRoot = "/" + urlRoot;
        }
        if (urlRoot.length() > 1 && urlRoot.endsWith("/")) {
            urlRoot = urlRoot.substring(0, urlRoot.length() - 1);
        }
        return urlRoot;
    }

    private static String parseHostname(@NotNull JsonElement all, @NotNull JsonObject obj) {
        String hostname;
        if (all == null) {
            KarmaConfig.$$$reportNull$$$0(20);
        }
        if (obj == null) {
            KarmaConfig.$$$reportNull$$$0(21);
        }
        if ((hostname = JsonUtil.getChildAsString((JsonObject)obj, (String)HOST_NAME)) == null) {
            LOG.warn("Can not parse Karma config.hostname from " + all.toString());
            hostname = "localhost";
        }
        hostname = hostname.toLowerCase(Locale.ENGLISH);
        return hostname;
    }

    @NotNull
    private static List<String> parseBrowsers(@NotNull JsonObject obj) {
        JsonElement browsersElement;
        if (obj == null) {
            KarmaConfig.$$$reportNull$$$0(22);
        }
        if ((browsersElement = obj.get(BROWSERS)) != null && browsersElement.isJsonArray()) {
            JsonArray browsersArray = browsersElement.getAsJsonArray();
            ArrayList browsers = Lists.newArrayList();
            for (JsonElement browserElement : browsersArray) {
                String browser = JsonUtil.getString((JsonElement)browserElement);
                if (browser == null) continue;
                browsers.add(browser);
            }
            ArrayList arrayList = browsers;
            if (arrayList == null) {
                KarmaConfig.$$$reportNull$$$0(23);
            }
            return arrayList;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            KarmaConfig.$$$reportNull$$$0(24);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = BASE_PATH;
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = BROWSERS;
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROTOCOL;
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = HOST_NAME;
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = URL_ROOT;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/KarmaConfig";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonElement";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFileDir";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 13: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "all";
                break;
            }
            case 14: 
            case 19: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/KarmaConfig";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBasePath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowsers";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocol";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostname";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlRoot";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBasePath";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBrowsers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 23: 
            case 24: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseFromJson";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "parseBasePath";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "parseUrlRoot";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "parseHostname";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseBrowsers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

