/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.config;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javascript.karma.config.KarmaConfigFileReference;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaConfigFileInspection
extends JSInspection {
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSLiteralExpression(JSLiteralExpression node) {
                for (PsiReference ref : node.getReferences()) {
                    if (!(ref instanceof KarmaConfigFileReference)) continue;
                    KarmaConfigFileInspection.handleReference((KarmaConfigFileReference)ref, holder);
                }
            }
        };
        if (jSElementVisitor == null) {
            KarmaConfigFileInspection.$$$reportNull$$$0(0);
        }
        return jSElementVisitor;
    }

    private static void handleReference(@NotNull KarmaConfigFileReference ref, @NotNull ProblemsHolder holder) {
        if (ref == null) {
            KarmaConfigFileInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            KarmaConfigFileInspection.$$$reportNull$$$0(2);
        }
        if (ref.isLast()) {
            PsiFileSystemItem fileItem = KarmaConfigFileInspection.resolve(ref);
            if (fileItem == null) {
                return;
            }
            KarmaConfigFileReference.FileType fileType = ref.getExpectedFileType();
            if (fileType == KarmaConfigFileReference.FileType.DIRECTORY && !fileItem.isDirectory()) {
                holder.registerProblemForReference((PsiReference)ref, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, "Directory expected", new LocalQuickFix[0]);
            }
            if (fileType == KarmaConfigFileReference.FileType.FILE && fileItem.isDirectory()) {
                holder.registerProblemForReference((PsiReference)ref, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, "File/Pattern expected", new LocalQuickFix[0]);
            }
        }
    }

    @Nullable
    private static PsiFileSystemItem resolve(@NotNull KarmaConfigFileReference ref) {
        ResolveResult[] results;
        if (ref == null) {
            KarmaConfigFileInspection.$$$reportNull$$$0(3);
        }
        for (ResolveResult result : results = ref.multiResolve(false)) {
            PsiElement element;
            if (!result.isValidResult() || !((element = result.getElement()) instanceof PsiFileSystemItem)) continue;
            return (PsiFileSystemItem)element;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/config/KarmaConfigFileInspection";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/config/KarmaConfigFileInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleReference";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

