/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.NopProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.javascript.jest.JestUtil;
import com.intellij.javascript.karma.KarmaConfig;
import com.intellij.javascript.karma.execution.KarmaConsoleProperties;
import com.intellij.javascript.karma.execution.KarmaConsoleView;
import com.intellij.javascript.karma.execution.KarmaExecutionType;
import com.intellij.javascript.karma.execution.KarmaRunConfiguration;
import com.intellij.javascript.karma.execution.KarmaRunSettings;
import com.intellij.javascript.karma.scope.KarmaScopeKind;
import com.intellij.javascript.karma.server.KarmaJsSourcesLocator;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.server.KarmaServerTerminatedListener;
import com.intellij.javascript.karma.tree.KarmaTestProxyFilterProvider;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructure;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructureBuilder;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructureBuilder;
import com.intellij.lang.javascript.ConsoleCommandLineFolder;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public class KarmaExecutionSession {
    private static final Logger LOG = Logger.getInstance(KarmaExecutionSession.class);
    private final Project myProject;
    private final KarmaRunConfiguration myRunConfiguration;
    private final Executor myExecutor;
    private final KarmaServer myKarmaServer;
    private final KarmaRunSettings myRunSettings;
    private final ProcessHandler myProcessHandler;
    private final KarmaExecutionType myExecutionType;
    private final SMTRunnerConsoleView mySmtConsoleView;
    private final ConsoleCommandLineFolder myFolder;
    private final List<List<String>> myFailedTestNames;

    public KarmaExecutionSession(@NotNull Project project, @NotNull KarmaRunConfiguration runConfiguration, @NotNull Executor executor, @NotNull KarmaServer karmaServer, @NotNull KarmaRunSettings runSettings, @NotNull KarmaExecutionType executionType, @Nullable List<List<String>> failedTestNames) throws ExecutionException {
        if (project == null) {
            KarmaExecutionSession.$$$reportNull$$$0(0);
        }
        if (runConfiguration == null) {
            KarmaExecutionSession.$$$reportNull$$$0(1);
        }
        if (executor == null) {
            KarmaExecutionSession.$$$reportNull$$$0(2);
        }
        if (karmaServer == null) {
            KarmaExecutionSession.$$$reportNull$$$0(3);
        }
        if (runSettings == null) {
            KarmaExecutionSession.$$$reportNull$$$0(4);
        }
        if (executionType == null) {
            KarmaExecutionSession.$$$reportNull$$$0(5);
        }
        this.myFolder = new ConsoleCommandLineFolder(new String[]{"karma", "run"});
        this.myProject = project;
        this.myRunConfiguration = runConfiguration;
        this.myExecutor = executor;
        this.myKarmaServer = karmaServer;
        this.myRunSettings = runSettings;
        this.myExecutionType = executionType;
        this.myFailedTestNames = failedTestNames;
        this.myProcessHandler = this.createProcessHandler(karmaServer);
        this.mySmtConsoleView = this.createSMTRunnerConsoleView();
        if (!(this.myProcessHandler instanceof NopProcessHandler)) {
            this.mySmtConsoleView.attachToProcess(this.myProcessHandler);
            this.myFolder.foldCommandLine((ConsoleView)this.mySmtConsoleView, this.myProcessHandler);
        }
    }

    @NotNull
    private SMTRunnerConsoleView createSMTRunnerConsoleView() {
        KarmaTestProxyFilterProvider filterProvider = new KarmaTestProxyFilterProvider(this.myProject, this.myKarmaServer);
        KarmaConsoleProperties consoleProperties = new KarmaConsoleProperties(this.myRunConfiguration, this.myExecutor, filterProvider);
        consoleProperties.addStackTraceFilter((Filter)new NodeStackTraceFilter(this.myProject, this.myKarmaServer.getServerSettings().getWorkingDirectorySystemDependent()));
        KarmaConsoleView consoleView = new KarmaConsoleView((TestConsoleProperties)consoleProperties, this.myKarmaServer, this.myExecutionType, this.myProcessHandler);
        SMTestRunnerConnectionUtil.initConsoleView((SMTRunnerConsoleView)consoleView, (String)consoleProperties.getTestFrameworkName());
        KarmaConsoleView karmaConsoleView = consoleView;
        if (karmaConsoleView == null) {
            KarmaExecutionSession.$$$reportNull$$$0(6);
        }
        return karmaConsoleView;
    }

    public boolean isDebug() {
        return this.myExecutionType == KarmaExecutionType.DEBUG;
    }

    @NotNull
    private ProcessHandler createProcessHandler(@NotNull KarmaServer server) throws ExecutionException {
        if (server == null) {
            KarmaExecutionSession.$$$reportNull$$$0(7);
        }
        OSProcessHandler processHandler = null;
        if (this.isDebug()) {
            if (server.isPortBound()) {
                processHandler = this.createOSProcessHandler(server);
            }
        } else if (server.areBrowsersReady()) {
            processHandler = this.createOSProcessHandler(server);
        }
        if (processHandler == null) {
            processHandler = new NopProcessHandler();
        }
        KarmaExecutionSession.terminateOnServerShutdown(server, (ProcessHandler)processHandler);
        OSProcessHandler oSProcessHandler = processHandler;
        if (oSProcessHandler == null) {
            KarmaExecutionSession.$$$reportNull$$$0(8);
        }
        return oSProcessHandler;
    }

    private static void terminateOnServerShutdown(final @NotNull KarmaServer server, final @NotNull ProcessHandler processHandler) {
        if (server == null) {
            KarmaExecutionSession.$$$reportNull$$$0(9);
        }
        if (processHandler == null) {
            KarmaExecutionSession.$$$reportNull$$$0(10);
        }
        final KarmaServerTerminatedListener terminationCallback = new KarmaServerTerminatedListener(){

            @Override
            public void onTerminated(int exitCode) {
                ScriptRunnerUtil.terminateProcessHandler((ProcessHandler)processHandler, (long)2000L, null);
            }
        };
        server.onTerminated(terminationCallback);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                server.removeTerminatedListener(terminationCallback);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/karma/execution/KarmaExecutionSession$2", "processTerminated"));
            }
        });
    }

    @NotNull
    private OSProcessHandler createOSProcessHandler(@NotNull KarmaServer server) throws ExecutionException {
        if (server == null) {
            KarmaExecutionSession.$$$reportNull$$$0(11);
        }
        NodeJsInterpreter interpreter = this.myRunSettings.getInterpreterRef().resolveNotNull(this.myProject);
        GeneralCommandLine commandLine = this.createCommandLine(interpreter, server);
        KillableColoredProcessHandler processHandler = new KillableColoredProcessHandler(commandLine);
        server.getRestarter().onRunnerExecutionStarted((OSProcessHandler)processHandler);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        KillableColoredProcessHandler killableColoredProcessHandler = processHandler;
        if (killableColoredProcessHandler == null) {
            KarmaExecutionSession.$$$reportNull$$$0(12);
        }
        return killableColoredProcessHandler;
    }

    @NotNull
    private GeneralCommandLine createCommandLine(@NotNull NodeJsInterpreter interpreter, @NotNull KarmaServer server) throws ExecutionException {
        String testNamesPattern;
        if (interpreter == null) {
            KarmaExecutionSession.$$$reportNull$$$0(13);
        }
        if (server == null) {
            KarmaExecutionSession.$$$reportNull$$$0(14);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setWorkDirectory(this.myRunSettings.getWorkingDirectorySystemDependent());
        commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
        List nodeOptionList = ParametersListUtil.parse((String)this.myRunSettings.getNodeOptions().trim());
        commandLine.addParameters(nodeOptionList);
        File clientAppFile = KarmaJsSourcesLocator.getInstance().getClientAppFile();
        commandLine.addParameter(clientAppFile.getAbsolutePath());
        commandLine.addParameter("--serverPort=" + server.getServerPort());
        KarmaConfig config = server.getKarmaConfig();
        if (config != null) {
            commandLine.addParameter("--protocol=" + config.getProtocol());
            commandLine.addParameter("--urlRoot=" + config.getUrlRoot());
        }
        if (this.isDebug()) {
            commandLine.addParameter("--debug=true");
        }
        if ((testNamesPattern = this.getTestNamesPattern()) != null) {
            commandLine.addParameter("--testName=" + testNamesPattern);
            this.myFolder.addLastParameterFrom(commandLine);
        }
        NodeCommandLineConfigurator.find((NodeJsInterpreter)interpreter).configure(commandLine);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            KarmaExecutionSession.$$$reportNull$$$0(15);
        }
        return generalCommandLine;
    }

    @Nullable
    private String getTestNamesPattern() throws ExecutionException {
        if (this.myFailedTestNames != null) {
            return KarmaExecutionSession.getTestNamesPattern(this.myFailedTestNames, false);
        }
        if (this.myRunSettings.getScopeKind() == KarmaScopeKind.TEST_FILE) {
            List<String> topNames = KarmaExecutionSession.findTopLevelSuiteNames(this.myProject, this.myRunSettings.getTestFileSystemIndependentPath());
            String testFileName = PathUtil.getFileName((String)this.myRunSettings.getTestFileSystemIndependentPath());
            if (topNames.isEmpty()) {
                throw new ExecutionException("No tests found in " + testFileName);
            }
            return KarmaExecutionSession.getTestNamesPattern(ContainerUtil.map(topNames, name -> Collections.singletonList(name)), true);
        }
        if (this.myRunSettings.getScopeKind() == KarmaScopeKind.SUITE) {
            return KarmaExecutionSession.getTestNamesPattern(Collections.singletonList(this.myRunSettings.getTestNames()), true);
        }
        if (this.myRunSettings.getScopeKind() == KarmaScopeKind.TEST) {
            return KarmaExecutionSession.getTestNamesPattern(Collections.singletonList(this.myRunSettings.getTestNames()), false);
        }
        return null;
    }

    @NotNull
    private static String getTestNamesPattern(@NotNull List<List<String>> testNames, boolean suite) {
        List patterns;
        if (testNames == null) {
            KarmaExecutionSession.$$$reportNull$$$0(16);
        }
        if ((patterns = ContainerUtil.map(testNames, testFqn -> {
            List escaped = ContainerUtil.mapNotNull((Collection)testFqn, s -> JestUtil.escapeJavaScriptRegexp((String)s));
            return StringUtil.join((Collection)escaped, (String)" ");
        })).isEmpty()) {
            if ("$^" == null) {
                KarmaExecutionSession.$$$reportNull$$$0(17);
            }
            return "$^";
        }
        String result = patterns.size() == 1 ? (String)patterns.get(0) : "(" + StringUtil.join((Collection)patterns, (String)"|") + ")";
        String string = "^" + result + (suite ? " " : "$");
        if (string == null) {
            KarmaExecutionSession.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static List<String> findTopLevelSuiteNames(@NotNull Project project, @NotNull String testFilePath) throws ExecutionException {
        VirtualFile file;
        if (project == null) {
            KarmaExecutionSession.$$$reportNull$$$0(19);
        }
        if (testFilePath == null) {
            KarmaExecutionSession.$$$reportNull$$$0(20);
        }
        if ((file = LocalFileFinder.findFile((String)testFilePath)) == null) {
            throw new ExecutionException("Cannot find test file by " + testFilePath);
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        JSFile jsFile = (JSFile)ObjectUtils.tryCast((Object)psiFile, JSFile.class);
        if (jsFile == null) {
            LOG.info("Not a JavaScript file " + testFilePath + ", " + (psiFile == null ? "null" : psiFile.getClass()));
            throw new ExecutionException("Not a JavaScript file: " + testFilePath);
        }
        JasmineFileStructure jasmine = (JasmineFileStructure)JasmineFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
        List elements = jasmine.getTopLevelElements();
        if (!elements.isEmpty()) {
            return elements;
        }
        QUnitFileStructure qunit = (QUnitFileStructure)QUnitFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
        elements = qunit.getTopLevelElements();
        if (!elements.isEmpty()) {
            return elements;
        }
        MochaTddFileStructure mochaTdd = (MochaTddFileStructure)MochaTddFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
        elements = mochaTdd.getTopLevelElements();
        if (!elements.isEmpty()) {
            return elements;
        }
        throw new ExecutionException("No tests found in " + testFilePath);
    }

    @NotNull
    public ProcessHandler getProcessHandler() {
        ProcessHandler processHandler = this.myProcessHandler;
        if (processHandler == null) {
            KarmaExecutionSession.$$$reportNull$$$0(21);
        }
        return processHandler;
    }

    @NotNull
    public SMTRunnerConsoleView getSmtConsoleView() {
        SMTRunnerConsoleView sMTRunnerConsoleView = this.mySmtConsoleView;
        if (sMTRunnerConsoleView == null) {
            KarmaExecutionSession.$$$reportNull$$$0(22);
        }
        return sMTRunnerConsoleView;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "karmaServer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionType";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/execution/KarmaExecutionSession";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testNames";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/execution/KarmaExecutionSession";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createSMTRunnerConsoleView";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessHandler";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createOSProcessHandler";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestNamesPattern";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessHandler";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSmtConsoleView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandler";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "terminateOnServerShutdown";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createOSProcessHandler";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTestNamesPattern";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findTopLevelSuiteNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

