/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.JSRunProfileWithCompileBeforeLaunchOption;
import com.intellij.javascript.karma.execution.KarmaProjectSettings;
import com.intellij.javascript.karma.execution.KarmaRunConfigurationEditor;
import com.intellij.javascript.karma.execution.KarmaRunConfigurationRefactoringHandler;
import com.intellij.javascript.karma.execution.KarmaRunProfileState;
import com.intellij.javascript.karma.execution.KarmaRunSettings;
import com.intellij.javascript.karma.execution.KarmaRunSettingsSerializationUtil;
import com.intellij.javascript.karma.scope.KarmaScopeKind;
import com.intellij.javascript.karma.server.KarmaJsSourcesLocator;
import com.intellij.javascript.karma.util.KarmaUtil;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.testFramework.PreferableRunConfiguration;
import com.intellij.javascript.testFramework.util.JsTestFqn;
import com.intellij.javascript.testing.JsTestRunConfigurationProducer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaRunConfiguration
extends LocatableConfigurationBase
implements RefactoringListenerProvider,
PreferableRunConfiguration,
JSRunProfileWithCompileBeforeLaunchOption {
    private KarmaRunSettings myRunSettings;

    protected KarmaRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name) {
        if (project == null) {
            KarmaRunConfiguration.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            KarmaRunConfiguration.$$$reportNull$$$0(1);
        }
        if (name == null) {
            KarmaRunConfiguration.$$$reportNull$$$0(2);
        }
        super(project, factory, name);
        this.myRunSettings = new KarmaRunSettings.Builder().build();
    }

    @NotNull
    public KarmaRunConfigurationEditor getConfigurationEditor() {
        KarmaRunConfigurationEditor karmaRunConfigurationEditor = new KarmaRunConfigurationEditor(this.getProject());
        if (karmaRunConfigurationEditor == null) {
            KarmaRunConfiguration.$$$reportNull$$$0(3);
        }
        return karmaRunConfigurationEditor;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            KarmaRunConfiguration.$$$reportNull$$$0(4);
        }
        super.readExternal(element);
        boolean templateRunConfiguration = KarmaRunConfiguration.isTemplate(element);
        this.myRunSettings = KarmaRunSettingsSerializationUtil.readXml(element, this.getProject(), templateRunConfiguration);
        NodePackage karmaPackage = this.myRunSettings.getKarmaPackage();
        if (templateRunConfiguration && karmaPackage != null && karmaPackage.isEmptyPath()) {
            this.myRunSettings = this.myRunSettings.toBuilder().setKarmaPackage(null).build();
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            KarmaRunConfiguration.$$$reportNull$$$0(5);
        }
        super.writeExternal(element);
        boolean templateRunConfiguration = KarmaRunConfiguration.isTemplate(element);
        KarmaRunSettingsSerializationUtil.writeXml(element, this.myRunSettings, templateRunConfiguration);
    }

    @NotNull
    public NodePackage getKarmaPackage() {
        if (this.isTemplate()) {
            NodePackage pkg = this.myRunSettings.getKarmaPackage();
            NodePackage nodePackage = pkg != null ? pkg : new NodePackage("");
            if (nodePackage == null) {
                KarmaRunConfiguration.$$$reportNull$$$0(6);
            }
            return nodePackage;
        }
        NodePackage karmaPackage = this.getOrInitKarmaPackage();
        if (karmaPackage.isEmptyPath()) {
            karmaPackage = KarmaProjectSettings.getKarmaPackage(this.getProject());
        }
        NodePackage nodePackage = karmaPackage;
        if (nodePackage == null) {
            KarmaRunConfiguration.$$$reportNull$$$0(7);
        }
        return nodePackage;
    }

    @NotNull
    private NodePackage getOrInitKarmaPackage() {
        NodePackage pkg = this.myRunSettings.getKarmaPackage();
        if (pkg == null) {
            VirtualFile contextFile;
            Project project = this.getProject();
            pkg = KarmaUtil.PKG_DESCRIPTOR.findFirstDirectDependencyPackage(project, null, contextFile = this.getContextFile());
            if (this.shouldPreferKarmaPackage(pkg)) {
                pkg = new NodePackageDescriptor("karma").findFirstDirectDependencyPackage(project, null, contextFile);
            }
            if (!pkg.isEmptyPath() && !KarmaUtil.isPathUnderContentRoots(project, pkg)) {
                NodePackage projectKarmaPackage = KarmaProjectSettings.getKarmaPackage(project);
                if (projectKarmaPackage.isEmptyPath()) {
                    KarmaProjectSettings.setKarmaPackage(project, pkg);
                }
                pkg = new NodePackage("");
            }
            this.myRunSettings = this.myRunSettings.toBuilder().setKarmaPackage(pkg).build();
        }
        NodePackage nodePackage = pkg;
        if (nodePackage == null) {
            KarmaRunConfiguration.$$$reportNull$$$0(8);
        }
        return nodePackage;
    }

    private boolean shouldPreferKarmaPackage(@NotNull NodePackage pkg) {
        if (pkg == null) {
            KarmaRunConfiguration.$$$reportNull$$$0(9);
        }
        if (!SystemInfo.isWindows || !pkg.nameMatches("@angular/cli")) {
            return false;
        }
        SemVer version = pkg.getVersion();
        if (version == null || version.getMajor() >= 6) {
            return false;
        }
        String path1 = this.getProject().getBasePath();
        String path2 = KarmaJsSourcesLocator.getInstance().getKarmaIntellijPackageDir().getAbsolutePath();
        return path1 != null && FileUtil.isWindowsAbsolutePath((String)path1) && FileUtil.isWindowsAbsolutePath((String)path2) && !path1.substring(0, 1).equals(path2.substring(0, 1));
    }

    @Nullable
    private VirtualFile getContextFile() {
        VirtualFile f = KarmaRunConfiguration.findFile(this.myRunSettings.getTestFileSystemDependentPath());
        if (f == null) {
            f = KarmaRunConfiguration.findFile(this.myRunSettings.getConfigPathSystemDependent());
        }
        if (f == null) {
            f = KarmaRunConfiguration.findFile(this.myRunSettings.getWorkingDirectorySystemDependent());
        }
        return f;
    }

    @Nullable
    private static VirtualFile findFile(@NotNull String path) {
        if (path == null) {
            KarmaRunConfiguration.$$$reportNull$$$0(10);
        }
        return FileUtil.isAbsolute((String)path) ? LocalFileSystem.getInstance().findFileByPath(path) : null;
    }

    private boolean isTemplate() {
        return RunManager.getInstance((Project)this.getProject()).isTemplate((RunConfiguration)this);
    }

    private static boolean isTemplate(@NotNull Element element) {
        if (element == null) {
            KarmaRunConfiguration.$$$reportNull$$$0(11);
        }
        return "true".equals(element.getAttributeValue("default"));
    }

    public void onNewConfigurationCreated() {
        VirtualFile workingDir;
        if (this.myRunSettings.getWorkingDirectorySystemDependent().isEmpty() && (workingDir = JsTestRunConfigurationProducer.guessWorkingDirectory((Project)this.getProject(), (String)this.myRunSettings.getConfigPathSystemDependent())) != null) {
            this.myRunSettings = this.myRunSettings.toBuilder().setWorkingDirectory(workingDir.getPath()).build();
        }
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        if (executor == null) {
            KarmaRunConfiguration.$$$reportNull$$$0(12);
        }
        if (env == null) {
            KarmaRunConfiguration.$$$reportNull$$$0(13);
        }
        return new KarmaRunProfileState(this.getProject(), this, env, this.getKarmaPackage());
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        this.check(this.getKarmaPackage());
    }

    private void check(@NotNull NodePackage karmaPackage) throws RuntimeConfigurationException {
        if (karmaPackage == null) {
            KarmaRunConfiguration.$$$reportNull$$$0(14);
        }
        NodeInterpreterUtil.checkForRunConfiguration((NodeJsInterpreter)this.myRunSettings.getInterpreterRef().resolve(this.getProject()));
        karmaPackage.validateForRunConfiguration("karma");
        KarmaRunConfiguration.validatePath("configuration file", this.myRunSettings.getConfigPathSystemDependent(), true);
        KarmaRunConfiguration.validatePath("working directory", this.myRunSettings.getWorkingDirectorySystemDependent(), false);
        if (this.myRunSettings.getScopeKind() == KarmaScopeKind.TEST_FILE) {
            KarmaRunConfiguration.validatePath("test file", this.myRunSettings.getTestFileSystemDependentPath(), true);
        }
    }

    private static void validatePath(@NotNull String pathLabelName, @Nullable String path, boolean fileExpected) throws RuntimeConfigurationException {
        if (pathLabelName == null) {
            KarmaRunConfiguration.$$$reportNull$$$0(15);
        }
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            throw new RuntimeConfigurationError("Unspecified " + pathLabelName);
        }
        File file = new File(path);
        if (!file.isAbsolute() || fileExpected && !file.isFile() || !fileExpected && !file.isDirectory()) {
            throw new RuntimeConfigurationError("No such " + pathLabelName);
        }
    }

    @NotNull
    public KarmaRunSettings getRunSettings() {
        KarmaRunSettings karmaRunSettings = this.myRunSettings;
        if (karmaRunSettings == null) {
            KarmaRunConfiguration.$$$reportNull$$$0(16);
        }
        return karmaRunSettings;
    }

    public void setRunSettings(@NotNull KarmaRunSettings runSettings) {
        if (runSettings == null) {
            KarmaRunConfiguration.$$$reportNull$$$0(17);
        }
        NodePackage newKarmaPackage = runSettings.getKarmaPackage();
        NodePackage oldKarmaPackage = this.myRunSettings.getKarmaPackage();
        if (newKarmaPackage == null || newKarmaPackage.equals((Object)oldKarmaPackage)) {
            this.myRunSettings = runSettings;
            return;
        }
        Project project = this.getProject();
        if (!KarmaUtil.isPathUnderContentRoots(project, newKarmaPackage)) {
            KarmaProjectSettings.setKarmaPackage(project, newKarmaPackage);
            newKarmaPackage = new NodePackage("");
        }
        if (newKarmaPackage.isEmptyPath() && this.isTemplate()) {
            newKarmaPackage = null;
        }
        this.myRunSettings = runSettings.toBuilder().setKarmaPackage(newKarmaPackage).build();
    }

    public void setConfigFilePath(@NotNull String configFilePath) {
        if (configFilePath == null) {
            KarmaRunConfiguration.$$$reportNull$$$0(18);
        }
        this.myRunSettings = this.myRunSettings.toBuilder().setConfigPath(configFilePath).build();
    }

    public String suggestedName() {
        KarmaRunSettings settings = this.myRunSettings;
        KarmaScopeKind scopeKind = settings.getScopeKind();
        if (scopeKind == KarmaScopeKind.ALL) {
            return PathUtil.getFileName((String)settings.getConfigPathSystemDependent());
        }
        if (scopeKind == KarmaScopeKind.TEST_FILE) {
            return PathUtil.getFileName((String)settings.getTestFileSystemDependentPath());
        }
        if (scopeKind == KarmaScopeKind.SUITE || scopeKind == KarmaScopeKind.TEST) {
            return JsTestFqn.getPresentableName(settings.getTestNames());
        }
        return super.suggestedName();
    }

    @Nullable
    public String getActionName() {
        KarmaScopeKind scopeKind = this.myRunSettings.getScopeKind();
        if (scopeKind == KarmaScopeKind.SUITE || scopeKind == KarmaScopeKind.TEST) {
            return StringUtil.notNullize((String)((String)ContainerUtil.getLastItem(this.myRunSettings.getTestNames())));
        }
        return super.getActionName();
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        return KarmaRunConfigurationRefactoringHandler.getRefactoringElementListener(this, element);
    }

    public boolean isPreferredOver(@NotNull RunConfiguration otherRc, @NotNull PsiElement sourceElement) {
        VirtualFile virtualFile;
        PsiFile psiFile;
        if (otherRc == null) {
            KarmaRunConfiguration.$$$reportNull$$$0(19);
        }
        if (sourceElement == null) {
            KarmaRunConfiguration.$$$reportNull$$$0(20);
        }
        if ((psiFile = (PsiFile)ObjectUtils.tryCast((Object)sourceElement, PsiFile.class)) != null && (virtualFile = psiFile.getVirtualFile()) != null) {
            return KarmaUtil.isKarmaConfigFile(virtualFile.getNameSequence(), true);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/execution/KarmaRunConfiguration";
                break;
            }
            case 4: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "karmaPackage";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathLabelName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFilePath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherRc";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/execution/KarmaRunConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getKarmaPackage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrInitKarmaPackage";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldPreferKarmaPackage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isTemplate";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "check";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "validatePath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setRunSettings";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setConfigFilePath";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isPreferredOver";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

